/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.golemdungeons.content.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.xkmc.golemdungeons.content.structure.GDSimplePiece;
import dev.xkmc.golemdungeons.init.reg.GDWorldGen;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class GDCustomPiece
extends GDSimplePiece {
    public static final Codec<GDCustomPiece> CODEC = RecordCodecBuilder.create(i -> i.group((App)GDCustomPiece.m_210465_(), (App)GDCustomPiece.m_210462_(), (App)GDCustomPiece.m_210538_(), (App)TerrainAdjustment.f_226918_.fieldOf("terrain_adjustment").forGetter(e -> e.adj), (App)Codec.INT.fieldOf("horizontal_expansion").forGetter(e -> e.xzMargin), (App)Codec.INT.optionalFieldOf("thickness").forGetter(e -> e.fixHeight == 0 ? Optional.empty() : Optional.of(e.fixHeight))).apply((Applicative)i, GDCustomPiece::new));
    private final TerrainAdjustment adj;
    private final int xzMargin;
    private final int fixHeight;

    protected GDCustomPiece(Either<ResourceLocation, StructureTemplate> id, Holder<StructureProcessorList> list, StructureTemplatePool.Projection proj, TerrainAdjustment adj, int xz, Optional<Integer> fixHeight) {
        super(id, list, proj);
        this.adj = adj;
        this.xzMargin = xz;
        this.fixHeight = fixHeight.orElse(0);
    }

    public GDCustomPiece(ResourceLocation template, Holder<StructureProcessorList> list, StructureTemplatePool.Projection proj, TerrainAdjustment adj, int xz, int fixHeight) {
        this((Either<ResourceLocation, StructureTemplate>)Either.left((Object)template), list, proj, adj, xz, Optional.of(fixHeight));
    }

    @Override
    public StructurePoolElementType<?> m_207234_() {
        return (StructurePoolElementType)GDWorldGen.CUSTOM.get();
    }

    public BoundingBox getBeardifierBox(StructurePiece piece) {
        BoundingBox box = piece.m_73547_();
        return new BoundingBox(box.m_162395_() - this.xzMargin, box.m_162396_(), box.m_162398_() - this.xzMargin, box.m_162399_() + this.xzMargin, Math.max(box.m_162396_() + this.fixHeight, box.m_162400_()), box.m_162401_() + this.xzMargin);
    }

    public TerrainAdjustment getTerrainAdjustment() {
        return this.adj;
    }
}

