/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.golemdungeons.content.spawner;

import dev.xkmc.golemdungeons.content.config.SpawnConfig;
import dev.xkmc.golemdungeons.content.config.TrialConfig;
import dev.xkmc.golemdungeons.content.spawner.TrialTicker;
import dev.xkmc.golemdungeons.init.GolemDungeons;
import dev.xkmc.golemdungeons.init.data.GDLang;
import dev.xkmc.golemdungeons.util.GolemUtils;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.bossevents.CustomBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class TrialData {
    private static final int WAVE_DELAY = 40;
    private static final int SUMMON_DELAY = 10;
    private static final int COMPLETE_DELAY = 60;
    @SerialClass.SerialField
    private final List<UUID> trialGolems = new ArrayList<UUID>();
    @SerialClass.SerialField
    @Nullable
    private ResourceLocation id;
    @SerialClass.SerialField
    private int wave = 0;
    @SerialClass.SerialField
    private int entryCount = 0;
    @SerialClass.SerialField
    private int entryIndex = 0;
    @SerialClass.SerialField
    private int toSummon = 0;
    @SerialClass.SerialField
    private int mobIndex = 0;
    @SerialClass.SerialField
    private int totalMob = 0;
    @SerialClass.SerialField
    private long nextAction = 0L;
    @SerialClass.SerialField
    private float totalHealth = 0.0f;
    @Nullable
    private TrialConfig config;

    public boolean tickTrial(TrialTicker be, ServerLevel level, long time) {
        if (this.id == null) {
            if (this.nextAction <= time && be.isOnGoing()) {
                be.stop();
            }
            return false;
        }
        if (this.config == null) {
            this.config = (TrialConfig)GolemDungeons.TRIAL.getEntry(this.id);
        }
        if (this.config == null) {
            return false;
        }
        boolean update = false;
        if (this.entryCount > 0) {
            update = this.tickSummon(this.config, be, level, time);
        } else if (this.trialGolems.isEmpty()) {
            if (this.wave >= this.config.list.size()) {
                be.complete(level, this.config, time);
                this.id = null;
                this.config = null;
                this.totalHealth = 0.0f;
                this.nextAction = time + 60L;
                return true;
            }
            this.initWave(this.config, be, level, time);
            return true;
        }
        return update |= this.trialGolems.removeIf(e -> {
            Entity golem = level.m_8791_(e);
            if (golem == null) {
                return true;
            }
            return !be.isValidTracked(golem);
        });
    }

    private boolean tickSummon(TrialConfig config, TrialTicker be, ServerLevel level, long time) {
        if (time < this.nextAction) {
            return false;
        }
        ArrayList<TrialConfig.WaveEntry> list = config.list.get(this.wave - 1);
        if (this.toSummon == 0 || this.entryIndex < 0) {
            ++this.entryIndex;
            if (this.entryIndex >= list.size()) {
                this.entryCount = 0;
                this.mobIndex = 0;
                this.entryIndex = 0;
                return true;
            }
            this.toSummon = list.get(this.entryIndex).num();
        }
        TrialConfig.WaveEntry entry = list.get(this.entryIndex);
        if (this.toSummon > 0) {
            LivingEntity e;
            --this.toSummon;
            SpawnConfig target = (SpawnConfig)GolemDungeons.SPAWN.getEntry(entry.target());
            if (target != null && (e = target.summon(level)) != null) {
                be.addCost(config.spawnCost, time);
                be.configureEntity(e, this.mobIndex);
                for (Entity le : e.m_20199_().toList()) {
                    if (!(le instanceof AbstractGolemEntity)) continue;
                    AbstractGolemEntity golem = (AbstractGolemEntity)le;
                    this.totalHealth += golem.m_21233_();
                    this.trialGolems.add(golem.m_20148_());
                    be.configureGolem(golem, this.mobIndex);
                }
                GolemUtils.recursiveAdd(level, (Entity)e);
                ++this.mobIndex;
                this.nextAction = time + 10L;
            }
        }
        return true;
    }

    private void initWave(TrialConfig config, TrialTicker be, ServerLevel level, long time) {
        ++this.wave;
        int ind = this.wave - 1;
        ArrayList<TrialConfig.WaveEntry> entry = config.list.get(ind);
        this.entryCount = entry.size();
        this.entryIndex = -1;
        this.toSummon = 0;
        this.totalMob = 0;
        for (int i = 0; i < this.entryCount; ++i) {
            this.totalMob += entry.get(i).num();
        }
        this.mobIndex = 0;
        this.totalHealth = 0.0f;
        this.nextAction = time + 40L;
    }

    public void start(TrialTicker be, long time, ResourceLocation trial, TrialConfig config) {
        this.trialGolems.clear();
        this.id = trial;
        this.config = config;
        this.wave = 0;
        this.entryCount = 0;
    }

    public void stop(ServerLevel level, TrialTicker be) {
        for (UUID e : this.trialGolems) {
            Entity golem = level.m_8791_(e);
            if (golem == null) continue;
            golem.m_146870_();
        }
        this.trialGolems.clear();
        this.id = null;
        this.config = null;
        this.totalHealth = 0.0f;
    }

    public void updateBar(CustomBossEvent bar, ServerLevel level, long time) {
        if (this.id == null) {
            bar.m_6451_(BossEvent.BossBarColor.GREEN);
            bar.m_136278_(60);
            bar.m_136264_((int)(this.nextAction - time));
            bar.m_6456_((Component)GDLang.BAR_VICTORY.get(new Object[0]));
        } else if (this.entryIndex < 0) {
            bar.m_6451_(BossEvent.BossBarColor.YELLOW);
            bar.m_136278_(40);
            bar.m_136264_(40 - (int)(this.nextAction - time));
            bar.m_6456_((Component)GDLang.fromTrial(this.id).m_7220_((Component)GDLang.BAR_WAVE.get(this.wave)).m_7220_((Component)GDLang.BAR_CHARGING.get(new Object[0])));
        } else if (this.entryCount > 0) {
            bar.m_6451_(BossEvent.BossBarColor.PURPLE);
            bar.m_136278_(this.totalMob);
            bar.m_136264_(this.mobIndex - 1);
            bar.m_6456_((Component)GDLang.fromTrial(this.id).m_7220_((Component)GDLang.BAR_WAVE.get(this.wave)).m_7220_((Component)GDLang.BAR_SUMMONING.get(new Object[0])));
        } else if (this.totalHealth > 0.0f) {
            float hp = 0.0f;
            int count = 0;
            for (UUID e : this.trialGolems) {
                Mob mob;
                Entity golem = level.m_8791_(e);
                if (!(golem instanceof Mob) || !(mob = (Mob)golem).m_6084_()) continue;
                hp += mob.m_21223_();
                ++count;
            }
            bar.m_6451_(BossEvent.BossBarColor.RED);
            bar.m_136278_((int)this.totalHealth);
            bar.m_136264_((int)hp);
            bar.m_6456_((Component)GDLang.fromTrial(this.id).m_7220_((Component)GDLang.BAR_WAVE.get(this.wave)).m_7220_((Component)GDLang.BAR_PROGRESS.get(count)));
        } else {
            bar.m_8321_(false);
            return;
        }
        bar.m_8321_(true);
    }
}

