/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.golemdungeons.content.spawner;

import dev.xkmc.golemdungeons.content.config.TrialConfig;
import dev.xkmc.golemdungeons.content.spawner.GolemTrialBlock;
import dev.xkmc.golemdungeons.content.spawner.TrialData;
import dev.xkmc.golemdungeons.content.spawner.TrialTicker;
import dev.xkmc.golemdungeons.init.GolemDungeons;
import dev.xkmc.golemdungeons.init.data.GDLang;
import dev.xkmc.golemdungeons.init.data.advancement.GDTriggers;
import dev.xkmc.l2library.base.tile.BaseBlockEntity;
import dev.xkmc.l2modularblock.BlockProxy;
import dev.xkmc.l2modularblock.tile_api.TickableBlockEntity;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.item.card.PathRecordCard;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.bossevents.CustomBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class GolemTrialBlockEntity
extends BaseBlockEntity
implements TickableBlockEntity,
TrialTicker {
    @SerialClass.SerialField
    private final List<BlockPos> targets = new ArrayList<BlockPos>();
    @SerialClass.SerialField
    private final List<UUID> trialPlayer = new ArrayList<UUID>();
    @SerialClass.SerialField
    private final TrialData data = new TrialData();
    @SerialClass.SerialField
    @Nullable
    public ResourceLocation trial = null;
    @SerialClass.SerialField
    private long lastCost;
    @SerialClass.SerialField
    private long lastTime;
    @Nullable
    private CustomBossEvent bar;

    public GolemTrialBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void clearCharging() {
        if (this.f_58857_ != null && this.m_58900_().m_61143_(GolemTrialBlock.STATE) == GolemTrialBlock.State.CHARGING) {
            this.lastCost = 0L;
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(GolemTrialBlock.STATE, (Comparable)((Object)GolemTrialBlock.State.IDLE)));
        }
    }

    public void setSummonPos(List<PathRecordCard.Pos> list) {
        BlockPos self = this.m_58899_();
        Direction dir = (Direction)this.m_58900_().m_61143_((Property)BlockProxy.HORIZONTAL_FACING);
        Rotation rot = switch (dir) {
            case Direction.WEST -> Rotation.CLOCKWISE_90;
            case Direction.EAST -> Rotation.COUNTERCLOCKWISE_90;
            case Direction.SOUTH -> Rotation.CLOCKWISE_180;
            default -> Rotation.NONE;
        };
        this.targets.clear();
        for (PathRecordCard.Pos e : list) {
            if (e.pos().m_123331_((Vec3i)self) > 2304.0) continue;
            BlockPos diff = e.pos().m_121996_((Vec3i)self).m_7954_(rot);
            this.targets.add(diff);
        }
        this.sync();
        this.m_6596_();
    }

    public List<BlockPos> getTargets() {
        BlockPos self = this.m_58899_();
        Direction dir = (Direction)this.m_58900_().m_61143_((Property)BlockProxy.HORIZONTAL_FACING);
        Rotation rot = switch (dir) {
            case Direction.WEST -> Rotation.COUNTERCLOCKWISE_90;
            case Direction.EAST -> Rotation.CLOCKWISE_90;
            case Direction.SOUTH -> Rotation.CLOCKWISE_180;
            default -> Rotation.NONE;
        };
        ArrayList<BlockPos> ans = new ArrayList<BlockPos>();
        for (BlockPos e : this.targets) {
            ans.add(e.m_7954_(rot).m_121955_((Vec3i)self));
        }
        return ans;
    }

    public void tick() {
        TrialConfig config;
        ServerPlayer sp;
        ArrayList<ServerPlayer> players;
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        long time = this.f_58857_.m_46467_();
        if (!this.trialPlayer.isEmpty()) {
            if (this.trial == null) {
                this.stop();
                return;
            }
            boolean change = this.trialPlayer.removeIf(e -> {
                Player player = this.f_58857_.m_46003_(e);
                return player == null || player.m_5833_() || !this.isValidTracked((Entity)player);
            });
            if (change) {
                this.m_6596_();
            }
            if (this.trialPlayer.isEmpty()) {
                this.stop();
                return;
            }
            if (this.bar == null) {
                this.bar = new CustomBossEvent(this.trial, (Component)GDLang.fromTrial(this.trial));
                change = true;
            }
            if (change) {
                players = new ArrayList<ServerPlayer>();
                for (UUID uUID : this.trialPlayer) {
                    Player player = this.f_58857_.m_46003_(uUID);
                    if (!(player instanceof ServerPlayer)) continue;
                    sp = (ServerPlayer)player;
                    players.add(sp);
                }
                this.bar.m_136268_(players);
            }
        }
        if (this.trial == null) {
            return;
        }
        if (this.trialPlayer.isEmpty() && time % 20L != 0L) {
            return;
        }
        if (this.m_58900_().m_61143_(GolemTrialBlock.STATE) == GolemTrialBlock.State.CHARGING && this.lastCost + this.lastTime < time) {
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(GolemTrialBlock.STATE, (Comparable)((Object)GolemTrialBlock.State.IDLE)));
        }
        if ((config = (TrialConfig)GolemDungeons.TRIAL.getEntry(this.trial)) == null) {
            return;
        }
        if (this.trialPlayer.isEmpty()) {
            if (time - this.lastTime < this.lastCost) {
                return;
            }
            players = new ArrayList();
            for (Player player : this.f_58857_.m_6907_()) {
                if (!this.isTriggeringPlayer(player, config) || !(player instanceof ServerPlayer)) continue;
                sp = (ServerPlayer)player;
                players.add(sp);
            }
            if (players.isEmpty()) {
                return;
            }
            this.lastCost = 0L;
            this.lastTime = time;
            for (ServerPlayer serverPlayer : players) {
                this.trialPlayer.add(serverPlayer.m_20148_());
            }
            this.bar = new CustomBossEvent(this.trial, (Component)GDLang.fromTrial(this.trial));
            this.bar.m_136268_(players);
            this.data.start(this, time, this.trial, config);
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(GolemTrialBlock.STATE, (Comparable)((Object)GolemTrialBlock.State.ACTIVATED)));
            this.sync();
            this.m_6596_();
        } else if (time % 5L == 0L) {
            boolean added = false;
            for (Player player : this.f_58857_.m_6907_()) {
                if (!this.isValidPlayer(player) || this.trialPlayer.contains(player.m_20148_())) continue;
                this.trialPlayer.add(player.m_20148_());
                added = true;
            }
            if (added) {
                ArrayList players2 = new ArrayList();
                if (this.bar == null) {
                    this.bar = new CustomBossEvent(this.trial, (Component)GDLang.fromTrial(this.trial));
                }
                this.bar.m_136268_(players2);
                this.m_6596_();
            }
        }
        if (this.data.tickTrial(this, sl, time)) {
            this.sync();
            this.m_6596_();
        }
        if (this.bar != null) {
            this.data.updateBar(this.bar, sl, time);
        }
    }

    public void setTrial(ResourceLocation id) {
        if (!this.trialPlayer.isEmpty()) {
            this.stop();
        }
        this.trial = id;
        this.m_6596_();
        this.sync();
    }

    @Override
    public void addCost(int cost, long time) {
        long since = time - this.lastTime;
        long remain = this.lastCost - since;
        this.lastCost = remain < 0L ? (long)cost : (long)cost + remain;
        this.lastTime = time;
        this.sync();
        this.m_6596_();
    }

    @Override
    public void stop() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            this.data.stop(sl, this);
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(GolemTrialBlock.STATE, (Comparable)((Object)GolemTrialBlock.State.CHARGING)));
        }
        this.trialPlayer.clear();
        if (this.bar != null) {
            this.bar.m_7706_();
        }
        this.bar = null;
        this.sync();
        this.m_6596_();
    }

    @Override
    public void complete(ServerLevel level, TrialConfig config, long time) {
        Optional opt;
        BlockEntity be;
        for (UUID id : this.trialPlayer) {
            Player pl = level.m_46003_(id);
            if (!(pl instanceof ServerPlayer)) continue;
            ServerPlayer sp = (ServerPlayer)pl;
            GDTriggers.COMPLETE.trigger(sp, config.getID());
        }
        level.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(GolemTrialBlock.STATE, (Comparable)((Object)GolemTrialBlock.State.VICTORY)));
        if (config.reward == null) {
            return;
        }
        LootTable loot = level.m_7654_().m_278653_().m_278676_(config.reward);
        LootParams params = new LootParams.Builder(level).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)this.m_58899_())).m_287235_(LootContextParamSets.f_81411_);
        Object list = loot.m_287195_(params);
        BlockPos up = this.m_58899_().m_7494_();
        if (config.generateChest && level.m_8055_(up).m_60795_()) {
            level.m_46597_(up, Blocks.f_50087_.m_49966_());
        }
        if ((be = level.m_7702_(up)) != null && (opt = be.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve()).isPresent()) {
            ArrayList<ItemStack> ans = new ArrayList<ItemStack>();
            IItemHandler cap = (IItemHandler)opt.get();
            for (ItemStack stack : list) {
                ItemStack remain = ItemHandlerHelper.insertItem((IItemHandler)cap, (ItemStack)stack, (boolean)false);
                if (remain.m_41619_()) continue;
                ans.add(remain);
            }
            list = ans;
        }
        for (ItemStack stack : list) {
            Block.m_49840_((Level)level, (BlockPos)this.m_58899_().m_7494_(), (ItemStack)stack);
        }
    }

    @Override
    public void configureEntity(LivingEntity e, int index) {
        BlockPos self = this.m_58899_();
        Direction dir = (Direction)this.m_58900_().m_61143_((Property)BlockProxy.HORIZONTAL_FACING);
        Rotation rot = switch (dir) {
            case Direction.WEST -> Rotation.COUNTERCLOCKWISE_90;
            case Direction.EAST -> Rotation.CLOCKWISE_90;
            case Direction.SOUTH -> Rotation.CLOCKWISE_180;
            default -> Rotation.NONE;
        };
        BlockPos pos = this.targets.isEmpty() ? self.m_7494_() : this.targets.get(index % this.targets.size()).m_7954_(rot).m_121955_((Vec3i)self);
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = 0; y <= 2; ++y) {
                    e.m_9236_().m_7471_(pos.m_7918_(x, y, z), false);
                }
            }
        }
        Vec3 vec = Vec3.m_82512_((Vec3i)pos);
        if (this.targets.size() <= 1) {
            vec = vec.m_82520_(e.m_217043_().m_188583_(), 0.0, e.m_217043_().m_188583_());
        }
        e.m_146884_(vec);
    }

    @Override
    public void configureGolem(AbstractGolemEntity<?, ?> golem, int mobIndex) {
    }

    @Override
    public boolean isOnGoing() {
        return !this.trialPlayer.isEmpty();
    }

    private boolean isTriggeringPlayer(Player pl, TrialConfig config) {
        if (pl.m_7500_() || pl.m_5833_()) {
            return false;
        }
        if (pl instanceof FakePlayer) {
            return false;
        }
        if (!pl.m_6084_()) {
            return false;
        }
        return config.isInRange(pl, this.m_58899_());
    }

    private boolean isValidPlayer(Player pl) {
        if (pl.m_7500_() || pl.m_5833_()) {
            return false;
        }
        if (pl instanceof FakePlayer) {
            return false;
        }
        return pl.m_6084_() && pl.m_20238_(Vec3.m_82512_((Vec3i)this.m_58899_())) <= 576.0;
    }

    @Override
    public boolean isValidTracked(Entity e) {
        return e.m_6084_() && e.m_9236_() == this.f_58857_ && e.m_20238_(Vec3.m_82512_((Vec3i)this.m_58899_())) < 2304.0;
    }

    public void m_7651_() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            this.data.stop(sl, this);
        }
        if (this.bar != null) {
            this.bar.m_7706_();
        }
        super.m_7651_();
    }

    public List<Component> getText(Player player) {
        long time;
        long since;
        long remain;
        GolemTrialBlock.State state;
        ArrayList<Component> ans = new ArrayList<Component>();
        if (this.trial != null && player.m_150110_().f_35937_) {
            ans.add((Component)GDLang.fromTrial(this.trial));
        }
        if ((state = (GolemTrialBlock.State)((Object)this.m_58900_().m_61143_(GolemTrialBlock.STATE))) == GolemTrialBlock.State.CHARGING && (remain = this.lastCost - (since = (time = player.m_9236_().m_46467_()) - this.lastTime)) > 0L) {
            long sec = remain / 20L;
            String str = "%d:%02d".formatted(sec / 60L, sec % 60L);
            ans.add((Component)GDLang.CHARGE_TIME.get(str));
        }
        return ans;
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82400_(48.0);
    }
}

