/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.golemdungeons.content.item;

import com.tterrag.registrate.util.CreativeModeTabModifier;
import dev.xkmc.golemdungeons.content.config.SpawnConfig;
import dev.xkmc.golemdungeons.content.item.SummonWandSelector;
import dev.xkmc.golemdungeons.content.spawner.GolemTrialBlockEntity;
import dev.xkmc.golemdungeons.init.GolemDungeons;
import dev.xkmc.golemdungeons.init.data.GDLang;
import dev.xkmc.golemdungeons.init.reg.GDItems;
import dev.xkmc.golemdungeons.util.GolemUtils;
import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class HostileSummonWand
extends Item {
    private static final String KEY_FACTION = "SummonFaction";
    private static final String KEY_MOD = "FactionMod";

    public static ItemStack of(ResourceLocation rl) {
        ItemStack ans = GDItems.SUMMON.asStack();
        ans.m_41784_().m_128359_(KEY_FACTION, rl.toString());
        ans.m_41784_().m_128359_(KEY_MOD, rl.m_135827_());
        return ans;
    }

    public static ResourceLocation getId(ItemStack stack) {
        ResourceLocation ans;
        CompoundTag root = stack.m_41783_();
        if (root != null && root.m_128425_(KEY_FACTION, 8) && (ans = ResourceLocation.m_135820_((String)root.m_128461_(KEY_FACTION))) != null && GolemDungeons.SPAWN.getEntry(ans) != null) {
            return ans;
        }
        return SummonWandSelector.getAll(HostileSummonWand.getModid(stack)).get(0);
    }

    public HostileSummonWand(Item.Properties p) {
        super(p);
    }

    public static String getModid(ItemStack stack) {
        CompoundTag root = stack.m_41783_();
        if (root != null && root.m_128425_(KEY_MOD, 8)) {
            String ans = root.m_128461_(KEY_MOD);
            for (SpawnConfig e : GolemDungeons.SPAWN.getAll()) {
                if (!e.getID().m_135827_().equals(ans)) continue;
                return ans;
            }
        }
        return "golemdungeons";
    }

    public Component m_7626_(ItemStack stack) {
        CompoundTag root = stack.m_41783_();
        if (root == null || !root.m_128425_(KEY_FACTION, 8)) {
            return super.m_7626_(stack).m_6881_().m_130946_(": ").m_7220_((Component)Component.m_237115_((String)("trial_selector." + HostileSummonWand.getModid(stack))));
        }
        ResourceLocation id = HostileSummonWand.getId(stack);
        SpawnConfig config = (SpawnConfig)GolemDungeons.SPAWN.getEntry(id);
        ResourceLocation target = config.targetTrial;
        if (target != null) {
            return GDLang.fromTrial(target);
        }
        return super.m_7626_(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        list.add((Component)GDLang.WAND_USAGE.get(new Object[0]));
        list.add((Component)GDLang.WAND_MODID.get(Component.m_237115_((String)("trial_selector." + HostileSummonWand.getModid(stack))).m_130940_(ChatFormatting.GOLD)));
        list.add((Component)GDLang.WAND_FACTION.get(GDLang.fromTrial(HostileSummonWand.getId(stack)).m_130940_(ChatFormatting.LIGHT_PURPLE)));
        list.add((Component)GDLang.WAND_BLOCK.get(new Object[0]));
        list.add((Component)GDLang.WAND_TRIAL.get(new Object[0]));
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        Level level = ctx.m_43725_();
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            ResourceLocation id = HostileSummonWand.getId(ctx.m_43722_());
            SpawnConfig entry = (SpawnConfig)GolemDungeons.SPAWN.getEntry(id);
            BlockEntity blockEntity = ctx.m_43725_().m_7702_(ctx.m_8083_());
            if (blockEntity instanceof GolemTrialBlockEntity) {
                GolemTrialBlockEntity be = (GolemTrialBlockEntity)blockEntity;
                if (entry.targetTrial != null && GolemDungeons.TRIAL.getEntry(entry.targetTrial) != null) {
                    be.setTrial(entry.targetTrial);
                }
            } else {
                LivingEntity e = entry.summon(sl);
                if (e != null) {
                    e.m_146884_(ctx.m_43720_());
                    GolemUtils.recursiveAdd(sl, (Entity)e);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void fillItemCategory(CreativeModeTabModifier x) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.add("golemdungeons");
        for (SpawnConfig e : GolemDungeons.SPAWN.getAll()) {
            set.add(e.getID().m_135827_());
        }
        for (String id : set) {
            ItemStack stack = this.m_7968_();
            stack.m_41784_().m_128359_(KEY_MOD, id);
            x.m_246342_(stack);
        }
    }
}

