/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.golemdungeons.content.config;

import dev.xkmc.golemdungeons.content.config.EquipmentConfig;
import dev.xkmc.golemdungeons.init.GolemDungeons;
import dev.xkmc.l2library.serial.config.BaseConfig;
import dev.xkmc.l2library.serial.config.CollectType;
import dev.xkmc.l2library.serial.config.ConfigCollect;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.l2serial.util.Wrappers;
import dev.xkmc.modulargolems.content.config.GolemMaterial;
import dev.xkmc.modulargolems.content.core.GolemType;
import dev.xkmc.modulargolems.content.core.IGolemPart;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.hostile.HostileFaction;
import dev.xkmc.modulargolems.content.entity.hostile.HostileGolemRegistry;
import dev.xkmc.modulargolems.content.item.golem.GolemHolder;
import dev.xkmc.modulargolems.content.item.golem.GolemPart;
import dev.xkmc.modulargolems.content.item.upgrade.IUpgradeItem;
import dev.xkmc.modulargolems.content.item.upgrade.UpgradeItem;
import dev.xkmc.modulargolems.content.modifier.base.ModifierInstance;
import dev.xkmc.modulargolems.content.modifier.special.BaseRangedAttackGoal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

@SerialClass
public class SpawnConfig
extends BaseConfig {
    private static final double[] DEF_CHANCE = new double[]{1.0, 0.5, 0.5, 0.5};
    @SerialClass.SerialField
    public ResourceLocation faction;
    @ConfigCollect(value=CollectType.MAP_OVERWRITE)
    @SerialClass.SerialField
    public final Map<EntityType<?>, GolemTypeEntry> types;
    @ConfigCollect(value=CollectType.MAP_OVERWRITE)
    @SerialClass.SerialField
    public final Map<ResourceLocation, GolemMaterialEntry> materials;
    @ConfigCollect(value=CollectType.COLLECT)
    @SerialClass.SerialField
    public final List<EquipmentGroup> equipments;
    @ConfigCollect(value=CollectType.COLLECT)
    @SerialClass.SerialField
    public final List<UpgradeEntry> upgrades;
    @Nullable
    @SerialClass.SerialField
    public ResourceLocation targetTrial;
    @SerialClass.SerialField
    public double[] upgradeChance;
    private SimpleWeightedRandomList<GolemTypeInfo> typeTable;
    private final Map<GolemPart<?, ?>, SimpleWeightedRandomList<ResourceLocation>> matTable;
    private SimpleWeightedRandomList<UpgradeEntry> upTable;
    private List<EquipmentGroupInfo> equipmentTable;

    @SerialClass.OnInject
    public void onInject() {
        if (this.upgradeChance == null) {
            this.upgradeChance = DEF_CHANCE;
        }
        SimpleWeightedRandomList.Builder typeList = SimpleWeightedRandomList.m_146263_();
        for (Map.Entry<EntityType<?>, GolemTypeEntry> ent : this.types.entrySet()) {
            if (ent.getValue().weight() <= 0) continue;
            typeList.m_146271_((Object)new GolemTypeInfo(ent.getKey(), ent.getValue()), ent.getValue().weight());
        }
        this.typeTable = typeList.m_146270_();
        for (GolemHolder item : GolemType.GOLEM_TYPE_TO_ITEM.values()) {
            for (IGolemPart part : item.getEntityType().values()) {
                SimpleWeightedRandomList.Builder matList = SimpleWeightedRandomList.m_146263_();
                for (Map.Entry<ResourceLocation, GolemMaterialEntry> ent : this.materials.entrySet()) {
                    if (ent.getValue().weight() <= 0 || ent.getValue().forbid.contains(item)) continue;
                    matList.m_146271_((Object)ent.getKey(), ent.getValue().weight());
                }
                this.matTable.put(part.toItem(), (SimpleWeightedRandomList<ResourceLocation>)matList.m_146270_());
            }
        }
        SimpleWeightedRandomList.Builder upList = SimpleWeightedRandomList.m_146263_();
        for (UpgradeEntry upgradeEntry : this.upgrades) {
            if (upgradeEntry.weight() <= 0) continue;
            upList.m_146271_((Object)upgradeEntry, upgradeEntry.weight());
        }
        this.upTable = upList.m_146270_();
        this.equipmentTable = new ArrayList<EquipmentGroupInfo>();
        for (EquipmentGroup equipmentGroup : this.equipments) {
            this.equipmentTable.add(new EquipmentGroupInfo(equipmentGroup));
        }
    }

    public SpawnConfig() {
        this.faction = HostileGolemRegistry.DEFAULT.id;
        this.types = new LinkedHashMap();
        this.materials = new LinkedHashMap<ResourceLocation, GolemMaterialEntry>();
        this.equipments = new ArrayList<EquipmentGroup>();
        this.upgrades = new ArrayList<UpgradeEntry>();
        this.targetTrial = null;
        this.matTable = new LinkedHashMap();
    }

    public SpawnConfig(HostileFaction faction) {
        this.faction = HostileGolemRegistry.DEFAULT.id;
        this.types = new LinkedHashMap();
        this.materials = new LinkedHashMap<ResourceLocation, GolemMaterialEntry>();
        this.equipments = new ArrayList<EquipmentGroup>();
        this.upgrades = new ArrayList<UpgradeEntry>();
        this.targetTrial = null;
        this.matTable = new LinkedHashMap();
        this.faction = faction.id;
    }

    @Nullable
    public LivingEntity summon(ServerLevel sl) {
        Optional mount;
        RandomSource r = sl.m_213780_();
        Optional type = this.typeTable.m_216820_(r);
        if (type.isEmpty()) {
            return null;
        }
        GolemType golemType = GolemType.getGolemType((EntityType)((EntityType)Wrappers.cast(((GolemTypeInfo)type.get()).type)));
        if (golemType == null) {
            return null;
        }
        AbstractGolemEntity<?, ?> golem = this.createGolem(sl, golemType, r);
        if (golem == null) {
            return null;
        }
        this.attachEquipments((LivingEntity)golem, r);
        if (!((GolemTypeInfo)type.get()).entry.mounts.isEmpty() && (double)r.m_188501_() < ((GolemTypeInfo)type.get()).entry.mountChance && !(mount = ((GolemTypeInfo)type.get()).mountTable.m_216820_(r)).isEmpty()) {
            AbstractGolemEntity<?, ?> mountEntity;
            EntityType mountType = (EntityType)mount.get();
            GolemType mountGolem = GolemType.getGolemType((EntityType)((EntityType)Wrappers.cast((Object)mountType)));
            if (mountGolem != null) {
                mountEntity = this.createGolem(sl, mountGolem, r);
            } else {
                mountEntity = mountType.m_20615_((Level)sl);
                if (mountEntity instanceof Horse) {
                    Horse animal = (Horse)mountEntity;
                    animal.m_30651_(true);
                }
            }
            if (mountEntity instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)mountEntity;
                this.attachEquipments(le, r);
                if (golem.m_20329_((Entity)le)) {
                    return le;
                }
            }
        }
        return golem;
    }

    private boolean fitsOn(ArrayList<GolemMaterial> mats, ArrayList<IUpgradeItem> upgrades, GolemHolder<?, ?> holder, IUpgradeItem upgrade) {
        UpgradeItem item;
        if (upgrade instanceof UpgradeItem && !(item = (UpgradeItem)upgrade).fitsOn(holder.getEntityType())) {
            return false;
        }
        ArrayList<IUpgradeItem> copy = new ArrayList<IUpgradeItem>(upgrades);
        copy.add(upgrade);
        int remaining = holder.getRemaining(mats, copy);
        if (remaining < 0) {
            return false;
        }
        HashMap map = GolemMaterial.collectModifiers(mats, upgrades);
        for (ModifierInstance e : upgrade.get()) {
            if (map.getOrDefault(e.mod(), 0) < e.mod().maxLevel) continue;
            return false;
        }
        return true;
    }

    private ArrayList<IUpgradeItem> validate(ArrayList<GolemMaterial> mats, ArrayList<IUpgradeItem> upgrades, GolemHolder<?, ?> holder) {
        ArrayList<IUpgradeItem> ans = new ArrayList<IUpgradeItem>();
        for (IUpgradeItem e : upgrades) {
            if (!this.fitsOn(mats, ans, holder, e)) continue;
            ans.add(e);
        }
        return ans;
    }

    @Nullable
    private AbstractGolemEntity<?, ?> createGolem(ServerLevel sl, GolemType<?, ?> golem, RandomSource r) {
        HostileFaction fac;
        IUpgradeItem item;
        Item item2;
        ArrayList<IUpgradeItem> ups = new ArrayList<IUpgradeItem>();
        ArrayList<GolemMaterial> mats = new ArrayList<GolemMaterial>();
        int max = golem.values().length;
        for (IGolemPart p : golem.values()) {
            Optional mat = this.matTable.get(p.toItem()).m_216820_(r);
            if (mat.isEmpty()) {
                return null;
            }
            mats.add(p.toItem().parseMaterial((ResourceLocation)mat.get()));
            for (UpgradeBonus b : this.materials.get(mat.get()).bonus) {
                if (!((double)r.m_188501_() < b.chance) || ups.size() >= max || !((item2 = b.upgrade) instanceof IUpgradeItem)) continue;
                item = (IUpgradeItem)item2;
                ups.add(item);
            }
        }
        GolemHolder holder = GolemType.getGolemHolder(golem);
        ups = this.validate(mats, ups, holder);
        for (double prob : this.upgradeChance) {
            if ((double)r.m_188501_() > prob) break;
            Optional up = this.upTable.m_216820_(r);
            if (!up.isPresent() || !((item2 = ((UpgradeEntry)up.get()).upgrade) instanceof IUpgradeItem) || !this.fitsOn(mats, ups, holder, item = (IUpgradeItem)item2)) continue;
            ups.add(item);
        }
        AbstractGolemEntity e = golem.create((Level)sl);
        UUID uuid = ((fac = HostileGolemRegistry.getFaction((ResourceLocation)this.faction)) == null ? HostileGolemRegistry.DEFAULT : fac).uuid;
        e.onCreate(mats, ups, uuid);
        for (WrappedGoal goal : e.f_21345_.m_148105_()) {
            Goal goal2 = goal.m_26015_();
            if (!(goal2 instanceof BaseRangedAttackGoal)) continue;
            BaseRangedAttackGoal ranged = (BaseRangedAttackGoal)goal2;
            ranged.setInitialDelay(e.m_217043_().m_188503_(100));
        }
        return e;
    }

    private void attachEquipments(LivingEntity e, RandomSource r) {
        for (EquipmentGroupInfo ent : this.equipmentTable) {
            EquipmentConfig data;
            Optional set;
            if (ent.group.type != e.m_6095_() || (set = ent.setTable.m_216820_(r)).isEmpty() || (data = (EquipmentConfig)GolemDungeons.ITEMS.getEntry((ResourceLocation)set.get())) == null) continue;
            data.cache.apply(e, r);
        }
    }

    public SpawnConfig type(GolemType<?, ?> type, GolemTypeEntry entry) {
        this.types.put(type.type(), entry);
        return this;
    }

    public SpawnConfig mat(ResourceLocation mat, int weight) {
        this.materials.put(mat, new GolemMaterialEntry(weight));
        return this;
    }

    public SpawnConfig mat(ResourceLocation mat, GolemMaterialEntry entry) {
        this.materials.put(mat, entry);
        return this;
    }

    public SpawnConfig equipments(EquipmentGroup entry) {
        this.equipments.add(entry);
        return this;
    }

    public SpawnConfig upgrade(Item upgrade, int weight) {
        this.upgrades.add(new UpgradeEntry(weight, upgrade));
        return this;
    }

    public SpawnConfig asTrialKey(ResourceLocation trial) {
        this.targetTrial = trial;
        return this;
    }

    public SpawnConfig upgradeChance(double ... chance) {
        this.upgradeChance = chance;
        return this;
    }

    public record GolemTypeEntry(int weight, double mountChance, ArrayList<UpgradeBonus> bonus, ArrayList<MountEntry> mounts) {
        public GolemTypeEntry(int weight, double mountChance) {
            this(weight, mountChance, new ArrayList<UpgradeBonus>(), new ArrayList<MountEntry>());
        }

        public GolemTypeEntry add(UpgradeItem upgrade, double chance) {
            this.bonus.add(new UpgradeBonus((Item)upgrade, chance));
            return this;
        }

        public GolemTypeEntry addMount(EntityType<?> mount, int weight) {
            this.mounts.add(new MountEntry(weight, mount));
            return this;
        }
    }

    private static class GolemTypeInfo {
        private final EntityType<?> type;
        private final GolemTypeEntry entry;
        private final SimpleWeightedRandomList<EntityType<?>> mountTable;

        private GolemTypeInfo(EntityType<?> type, GolemTypeEntry entry) {
            this.type = type;
            this.entry = entry;
            SimpleWeightedRandomList.Builder mountList = SimpleWeightedRandomList.m_146263_();
            for (MountEntry e : entry.mounts) {
                if (e.weight <= 0) continue;
                mountList.m_146271_(e.mount(), e.weight);
            }
            this.mountTable = mountList.m_146270_();
        }
    }

    public record GolemMaterialEntry(int weight, ArrayList<Item> forbid, ArrayList<UpgradeBonus> bonus) {
        public GolemMaterialEntry(int weight) {
            this(weight, new ArrayList<Item>(), new ArrayList<UpgradeBonus>());
        }

        public GolemMaterialEntry ban(GolemPart<?, ?> part) {
            this.forbid.add((Item)part);
            return this;
        }

        public GolemMaterialEntry add(UpgradeItem upgrade, double chance) {
            this.bonus.add(new UpgradeBonus((Item)upgrade, chance));
            return this;
        }
    }

    public record UpgradeEntry(int weight, Item upgrade) {
    }

    public record EquipmentGroup(EntityType<?> type, ArrayList<EquipmentSet> sets) {
        public EquipmentGroup(EntityType<?> type) {
            this(type, new ArrayList<EquipmentSet>());
        }

        public EquipmentGroup add(int weight, ResourceLocation id) {
            this.sets.add(new EquipmentSet(weight, id));
            return this;
        }
    }

    private static class EquipmentGroupInfo {
        private final EquipmentGroup group;
        private final SimpleWeightedRandomList<ResourceLocation> setTable;

        private EquipmentGroupInfo(EquipmentGroup group) {
            this.group = group;
            SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.m_146263_();
            for (EquipmentSet e : group.sets()) {
                if (e.weight <= 0) continue;
                builder.m_146271_((Object)e.target(), e.weight());
            }
            this.setTable = builder.m_146270_();
        }
    }

    public record UpgradeBonus(Item upgrade, double chance) {
    }

    public record EquipmentSet(int weight, ResourceLocation target) {
    }

    public record MountEntry(int weight, EntityType<?> mount) {
    }
}

