/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.golemdungeons.content.config;

import dev.xkmc.l2library.serial.config.BaseConfig;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;

@SerialClass
public class EquipmentConfig
extends BaseConfig {
    @SerialClass.SerialField
    public final LinkedHashMap<EquipmentSlot, ArrayList<EquipmentEntry>> items = new LinkedHashMap();
    EquipmentSetInfo cache;

    @SerialClass.OnInject
    public void onInject() {
        this.cache = new EquipmentSetInfo(this.items);
    }

    public EquipmentConfig add(EquipmentSlot slot, EquipmentEntry entry) {
        this.items.computeIfAbsent(slot, k -> new ArrayList()).add(entry);
        return this;
    }

    public EquipmentConfig add(EquipmentSlot slot, int weight, ItemLike stack) {
        return this.add(slot, new EquipmentEntry(weight, stack.m_5456_()));
    }

    public EquipmentConfig add(EquipmentSlot slot, int weight, ItemStack stack) {
        return this.add(slot, new EquipmentEntry(weight, stack));
    }

    public EquipmentConfig add(EquipmentSlot slot, int weight, ItemLike stack, int enchantLevel) {
        return this.add(slot, new EquipmentEntry(weight, stack.m_5456_(), enchantLevel));
    }

    public EquipmentConfig add(EquipmentSlot slot, int weight, ItemLike stack, int enchantLevel, float dropChance) {
        return this.add(slot, new EquipmentEntry(weight, new ItemStack((ItemLike)stack.m_5456_()), enchantLevel, dropChance));
    }

    public EquipmentConfig add(EquipmentSlot slot, int weight, ItemStack stack, int enchantLevel) {
        return this.add(slot, new EquipmentEntry(weight, stack, enchantLevel));
    }

    public EquipmentConfig add(EquipmentSlot slot, int weight, ItemStack stack, int enchantLevel, float dropChance) {
        return this.add(slot, new EquipmentEntry(weight, stack, enchantLevel, dropChance));
    }

    public static class EquipmentSetInfo {
        private final Map<EquipmentSlot, SimpleWeightedRandomList<EquipmentEntry>> itemTable = new LinkedHashMap<EquipmentSlot, SimpleWeightedRandomList<EquipmentEntry>>();

        private EquipmentSetInfo(LinkedHashMap<EquipmentSlot, ArrayList<EquipmentEntry>> items) {
            for (Map.Entry<EquipmentSlot, ArrayList<EquipmentEntry>> ent : items.entrySet()) {
                SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.m_146263_();
                for (EquipmentEntry e : ent.getValue()) {
                    if (e.weight() <= 0) continue;
                    builder.m_146271_((Object)e, e.weight());
                }
                this.itemTable.put(ent.getKey(), (SimpleWeightedRandomList<EquipmentEntry>)builder.m_146270_());
            }
        }

        public void apply(LivingEntity e, RandomSource r) {
            for (Map.Entry<EquipmentSlot, SimpleWeightedRandomList<EquipmentEntry>> slot : this.itemTable.entrySet()) {
                Optional item = slot.getValue().m_216820_(r);
                if (item.isEmpty()) continue;
                ItemStack stack = ((EquipmentEntry)item.get()).get(r);
                e.m_8061_(slot.getKey(), stack);
                if (!(e instanceof Mob)) continue;
                Mob mob = (Mob)e;
                mob.m_21409_(slot.getKey(), ((EquipmentEntry)item.get()).dropChance());
            }
        }
    }

    public record EquipmentEntry(int weight, ItemStack stack, int enchantLevel, float dropChance) {
        public EquipmentEntry(int weight, Item stack) {
            this(weight, new ItemStack((ItemLike)stack));
        }

        public EquipmentEntry(int weight, ItemStack stack) {
            this(weight, stack, 0);
        }

        public EquipmentEntry(int weight, Item stack, int level) {
            this(weight, new ItemStack((ItemLike)stack), level);
        }

        public EquipmentEntry(int weight, ItemStack stack, int level) {
            this(weight, stack, level, 0.085f);
        }

        public ItemStack get(RandomSource r) {
            if (this.stack.m_150930_(Items.f_42688_)) {
                int n = this.enchantLevel <= 1 ? 1 : r.m_188503_(this.enchantLevel) + 1;
                return EquipmentEntry.getRocket(r, Mth.m_14045_((int)n, (int)1, (int)7));
            }
            ItemStack ans = this.stack.m_41777_();
            if (this.stack.m_41792_() && this.enchantLevel > 0) {
                EnchantmentHelper.m_220292_((RandomSource)r, (ItemStack)this.stack, (int)this.enchantLevel, (boolean)true);
            }
            return ans;
        }

        public static ItemStack getRocket(RandomSource r, int n) {
            ItemStack ans = new ItemStack((ItemLike)Items.f_42688_);
            CompoundTag tag = ans.m_41698_("Fireworks");
            ListTag list = new ListTag();
            for (int i = 0; i < n; ++i) {
                CompoundTag comp = new CompoundTag();
                comp.m_128408_("Colors", List.of(Integer.valueOf(DyeColor.values()[r.m_188503_(16)].m_41070_())));
                comp.m_128344_("Type", (byte)0);
                list.add((Object)comp);
            }
            tag.m_128344_("Flight", (byte)3);
            tag.m_128365_("Explosions", (Tag)list);
            return ans;
        }
    }
}

