/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.menu.registry;

import dev.xkmc.l2serial.network.SerialPacketBase;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.l2tabs.compat.CuriosEventHandler;
import dev.xkmc.modulargolems.compat.curio.CurioCompatRegistry;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.menu.equipment.EquipmentsMenuPvd;
import dev.xkmc.modulargolems.content.menu.registry.IMenuPvd;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class OpenEquipmentMenuToServer
extends SerialPacketBase {
    @SerialClass.SerialField
    public Type type;
    @SerialClass.SerialField
    public UUID uuid;

    @Deprecated
    public OpenEquipmentMenuToServer() {
    }

    public OpenEquipmentMenuToServer(UUID uuid, Type type) {
        this.uuid = uuid;
        this.type = type;
    }

    public void handle(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (player == null) {
            return;
        }
        Entity entry = player.m_284548_().m_8791_(this.uuid);
        if (!(entry instanceof AbstractGolemEntity)) {
            return;
        }
        AbstractGolemEntity golem = (AbstractGolemEntity)entry;
        if (!golem.canModify((Player)player)) {
            return;
        }
        IMenuPvd pvd = this.type.construct(golem);
        if (pvd != null) {
            CuriosEventHandler.openMenuWrapped((ServerPlayer)player, () -> NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)pvd, pvd::writeBuffer));
        }
    }

    public static enum Type {
        EQUIPMENT(EquipmentsMenuPvd::new),
        CURIOS(CurioCompatRegistry::create);

        private final Function<AbstractGolemEntity<?, ?>, IMenuPvd> func;

        private Type(Function<AbstractGolemEntity<?, ?>, IMenuPvd> func) {
            this.func = func;
        }

        @Nullable
        public IMenuPvd construct(AbstractGolemEntity<?, ?> entry) {
            return this.func.apply(entry);
        }
    }
}

