/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.item.card;

import com.mojang.datafixers.util.Either;
import dev.xkmc.l2library.util.nbt.ItemCompoundTag;
import dev.xkmc.modulargolems.content.item.card.TargetFilterCard;
import dev.xkmc.modulargolems.init.data.MGLangData;
import dev.xkmc.modulargolems.init.data.MGTagGen;
import dev.xkmc.modulargolems.init.registrate.GolemItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;
import org.jetbrains.annotations.Nullable;

public class NameFilterCard
extends TargetFilterCard {
    private static final String KEY = "filterList";

    private static List<String> getStrings(ItemStack stack) {
        ArrayList<String> ans = new ArrayList<String>();
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(KEY)) {
            return ans;
        }
        for (Tag e : tag.m_128437_(KEY, 8)) {
            ans.add(e.m_7916_());
        }
        return ans;
    }

    private static List<Either<EntityType<?>, TagKey<EntityType<?>>>> getList(List<String> strs) {
        ArrayList ans = new ArrayList();
        for (String s : strs) {
            EntityType type;
            ResourceLocation rl;
            String str = s.trim();
            if (str.startsWith("#")) {
                rl = NameFilterCard.getRL(str.substring(1));
                if (rl == null) continue;
                TagKey key = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)rl);
                ITagManager manager = ForgeRegistries.ENTITY_TYPES.tags();
                if (manager == null || !manager.isKnownTagName(key)) continue;
                ans.add(Either.right((Object)key));
                continue;
            }
            rl = NameFilterCard.getRL(str);
            if (rl == null || !ForgeRegistries.ENTITY_TYPES.containsKey(rl) || (type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(rl)) == null) continue;
            ans.add(Either.left((Object)type));
        }
        return ans;
    }

    @Nullable
    private static ResourceLocation getRL(String str) {
        try {
            return new ResourceLocation(str);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setList(ItemStack stack, List<Either<EntityType<?>, TagKey<EntityType<?>>>> list) {
        ListTag tag = ItemCompoundTag.of((ItemStack)stack).getSubList(KEY, 8).getOrCreate();
        tag.clear();
        for (Either<EntityType<?>, TagKey<EntityType<?>>> e : list) {
            ((Optional)e.map(l -> Optional.ofNullable(ForgeRegistries.ENTITY_TYPES.getKey(l)).map(ResourceLocation::toString), r -> Optional.of("#" + r.f_203868_()))).map(StringTag::m_129297_).ifPresent(arg_0 -> tag.add(arg_0));
        }
    }

    public NameFilterCard(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack getFriendly() {
        ItemStack friendly = GolemItems.CARD_NAME.asStack();
        NameFilterCard.setList(friendly, List.of(Either.right(MGTagGen.GOLEM_FRIENDLY)));
        return friendly;
    }

    @Override
    public Predicate<LivingEntity> mayTarget(ItemStack stack) {
        List<Either<EntityType<?>, TagKey<EntityType<?>>>> list = NameFilterCard.getList(NameFilterCard.getStrings(stack));
        return e -> {
            for (Either x : list) {
                if (!((Boolean)x.map(l -> e.m_6095_() == l, r -> e.m_6095_().m_204039_(r))).booleanValue()) continue;
                return true;
            }
            return false;
        };
    }

    @Override
    protected InteractionResultHolder<ItemStack> removeLast(Player player, ItemStack stack) {
        List<String> list = NameFilterCard.getStrings(stack);
        if (list.size() == 0) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (!player.m_9236_().m_5776_()) {
            String e = list.remove(list.size() - 1);
            NameFilterCard.setList(stack, NameFilterCard.getList(list));
            player.m_213846_((Component)MGLangData.TARGET_MSG_REMOVED.get(Component.m_237113_((String)e)));
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    @Override
    protected InteractionResultHolder<ItemStack> onUse(Player player, ItemStack stack) {
        String name;
        List<String> strs = NameFilterCard.getStrings(stack);
        if (strs.contains(name = stack.m_41786_().getString())) {
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        if (!player.m_9236_().m_5776_()) {
            strs.add(name);
            NameFilterCard.setList(stack, NameFilterCard.getList(strs));
            stack.m_41714_(null);
            player.m_213846_((Component)MGLangData.TARGET_MSG_ADDED.get(Component.m_237113_((String)name)));
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        List<String> strs = NameFilterCard.getStrings(stack);
        if (strs.size() > 0 && !Screen.m_96638_()) {
            for (String e : strs) {
                list.add((Component)Component.m_237113_((String)e));
            }
            list.add((Component)MGLangData.TARGET_SHIFT.get(new Object[0]));
        } else {
            list.add((Component)MGLangData.TARGET_NAME.get(new Object[0]));
            list.add((Component)MGLangData.TARGET_REMOVE.get(new Object[0]));
        }
    }
}

