/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.metalgolem;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.xkmc.modulargolems.content.client.armor.GolemEquipmentModels;
import dev.xkmc.modulargolems.content.client.armor.GolemModelPath;
import dev.xkmc.modulargolems.content.entity.metalgolem.MetalGolemEntity;
import dev.xkmc.modulargolems.content.entity.metalgolem.MetalGolemModel;
import dev.xkmc.modulargolems.content.item.equipments.GolemModelItem;
import dev.xkmc.modulargolems.events.event.GolemRenderItemInHandEvent;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

public class GolemEquipmentRenderer
extends RenderLayer<MetalGolemEntity, MetalGolemModel> {
    public HashMap<ModelLayerLocation, MetalGolemModel> map = new HashMap();
    private final ItemInHandRenderer itemInHandRenderer;

    public GolemEquipmentRenderer(RenderLayerParent<MetalGolemEntity, MetalGolemModel> r, EntityRendererProvider.Context e) {
        super(r);
        for (ModelLayerLocation l : GolemEquipmentModels.LIST) {
            this.map.put(l, new MetalGolemModel(e.m_174023_(l)));
        }
        this.itemInHandRenderer = e.m_234598_();
    }

    public void render(@NotNull PoseStack pose, MultiBufferSource source, int i, @NotNull MetalGolemEntity entity, float f1, float f2, float f3, float f4, float f5, float f6) {
        for (EquipmentSlot e : EquipmentSlot.values()) {
            ItemStack stack = entity.m_6844_(e);
            Item item = stack.m_41720_();
            if (item instanceof GolemModelItem) {
                GolemModelItem mgaitem = (GolemModelItem)item;
                VertexConsumer buffer = source.m_6299_(RenderType.m_110431_((ResourceLocation)mgaitem.getModelTexture()));
                this.renderArmor(mgaitem, pose, buffer, i);
                if (!mgaitem.emissive()) continue;
                buffer = source.m_6299_(RenderType.m_110431_((ResourceLocation)mgaitem.getEmissiveModelTexture()));
                this.renderArmor(mgaitem, pose, buffer, 0xF000F0);
                continue;
            }
            this.renderArmWithItem(entity, stack, e, pose, source, i);
        }
    }

    protected void renderArmor(GolemModelItem mgaitem, PoseStack pose, VertexConsumer buffer, int light) {
        GolemModelPath gmpath = GolemModelPath.get(mgaitem.getModelPath());
        for (List<String> ls : gmpath.paths()) {
            MetalGolemModel model = this.map.get(gmpath.models());
            model.copyFrom((MetalGolemModel)this.m_117386_());
            ModelPart gemr = model.m_142109_();
            pose.m_85836_();
            for (String s : ls) {
                gemr.m_104299_(pose);
                gemr = gemr.m_171324_(s);
            }
            gemr.m_104306_(pose, buffer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            pose.m_85849_();
        }
    }

    protected void renderArmWithItem(MetalGolemEntity entity, ItemStack stack, EquipmentSlot slot, PoseStack pose, MultiBufferSource source, int light) {
        if (stack.m_41619_()) {
            return;
        }
        ItemDisplayContext ctx = null;
        if (slot == EquipmentSlot.MAINHAND) {
            ctx = ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
        } else if (slot == EquipmentSlot.OFFHAND) {
            ctx = ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
        }
        if (ctx == null) {
            return;
        }
        HumanoidArm arm = slot == EquipmentSlot.MAINHAND ? entity.m_5737_() : entity.m_5737_().m_20828_();
        pose.m_85836_();
        ((MetalGolemModel)this.m_117386_()).transformToHand(slot, pose);
        boolean offhand = slot == EquipmentSlot.OFFHAND;
        pose.m_252880_((float)(offhand ? 1 : -1) * 0.7f, 0.8f, -0.25f);
        pose.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
        pose.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        ItemInHandRenderer r = this.itemInHandRenderer;
        if (!MinecraftForge.EVENT_BUS.post((Event)new GolemRenderItemInHandEvent((LivingEntity)entity, stack, ctx, arm, pose, source, light, r))) {
            r.m_269530_((LivingEntity)entity, stack, ctx, offhand, pose, source, light);
        }
        pose.m_85849_();
    }
}

