/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.materials.legendarymonsters;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.miauczel.legendary_monsters.effect.ModEffects;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Effect.CameraShakeEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile.ElectricityEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile.LightningBoltEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LMProxyImpl {
    public static void shake(LivingEntity user, Vec3 pos) {
        CameraShakeEntity.cameraShake((Level)user.m_9236_(), (Vec3)pos, (float)15.0f, (float)0.3f, (int)0, (int)15);
    }

    public static List<LivingEntity> stun(ServerLevel level, double x, double y, double z, LivingEntity golem, float reach, int lv) {
        ArrayList<LivingEntity> affected = new ArrayList<LivingEntity>();
        int n = 128;
        for (double i = 0.0; i < (double)n; i += 1.0) {
            double a = Math.PI * 2 / (double)n * i;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123777_, x + 0.5 + Math.cos(a) * (double)reach, y, z + 0.5 + Math.sin(a) * (double)reach, 0, 0.0, 0.05, 0.0, 1.0);
        }
        level.m_5594_(null, BlockPos.m_274561_((double)x, (double)y, (double)z), SoundEvents.f_12009_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        Vec3 cen = new Vec3(x, y, z);
        for (LivingEntity le : level.m_6443_(LivingEntity.class, new AABB(cen, cen).m_82400_((double)reach), e -> e != golem).stream().sorted(Comparator.comparingDouble(ec -> ec.m_20238_(cen))).toList()) {
            if (golem.m_7307_((Entity)le)) continue;
            le.m_7292_(new MobEffectInstance((MobEffect)ModEffects.STUN.get(), 20 * lv, 255, false, false));
            le.m_6469_(golem.m_269291_().m_269333_(golem), (float)golem.m_21133_(Attributes.f_22281_) * (float)lv * 0.4f);
            affected.add(le);
        }
        return affected;
    }

    public static void performThunderAttack(Mob e, LivingEntity target, int lv) {
        LMProxyImpl.spawnBoltStrip(e, target, 8 + 8 * lv, 4 + 3 * lv);
    }

    public static void spawnElectricShock(Entity attacker, LivingEntity entity, float damage, int n) {
        Vec3 dir = attacker.m_20182_().m_82546_(entity.m_20182_()).m_82541_();
        double val = dir.f_82479_ * dir.f_82479_ + dir.f_82481_ * dir.f_82481_;
        Vec3 ax0 = val < 1.0E-4 ? new Vec3(1.0, 0.0, 0.0) : new Vec3(-dir.f_82479_ * dir.f_82480_, val, -dir.f_82481_ * dir.f_82480_).m_82541_();
        Vec3 ax1 = dir.m_82537_(ax0).m_82541_();
        for (int i = 0; i < n; ++i) {
            double rad = Math.PI * 2 / (double)n * (double)i;
            Vec3 vec = ax1.m_82490_(Math.sin(rad)).m_82549_(dir.m_82490_(Math.cos(rad)));
            float angle = (float)(Math.atan2(vec.f_82481_, vec.f_82479_) * 57.2957763671875);
            Entity e = LMProxyImpl.createElectricity(entity, vec, angle, damage);
            Vec3 pos = entity.m_20182_().m_82549_(vec);
            e.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
            entity.m_9236_().m_7967_(e);
        }
    }

    private static void spawnBoltStrip(Mob e, LivingEntity target, int step, int dmg) {
        double d0 = Math.min(target.m_20186_(), e.m_20186_());
        double d1 = Math.max(target.m_20186_(), e.m_20186_()) + 2.0;
        float angle = (float)Mth.m_14136_((double)(target.m_20189_() - e.m_20189_()), (double)(target.m_20185_() - e.m_20185_()));
        for (int l = 0; l < step; ++l) {
            double len = 1.25 * (double)(l + 1);
            int delay = (int)(1.25f * (float)l);
            double x = e.m_20185_() + (double)Mth.m_14089_((float)angle) * len;
            double z = e.m_20189_() + (double)Mth.m_14031_((float)angle) * len;
            LMProxyImpl.spawnSingleBolt(e, x, z, d0, d1, angle, delay, dmg);
        }
    }

    private static void spawnSingleBolt(Mob e, double x, double z, double minY, double maxY, float rotation, int delay, int dmg) {
        BlockPos pos = new BlockPos((int)x, (int)maxY, (int)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState topState;
            VoxelShape topShape;
            BlockPos low = pos.m_7495_();
            BlockState state = e.m_9236_().m_8055_(low);
            if (!state.m_60783_((BlockGetter)e.m_9236_(), low, Direction.UP)) continue;
            if (!e.m_9236_().m_46859_(pos) && !(topShape = (topState = e.m_9236_().m_8055_(pos)).m_60812_((BlockGetter)e.m_9236_(), pos)).m_83281_()) {
                d0 = topShape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((pos = pos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) - 1);
        if (flag) {
            e.m_9236_().m_7967_((Entity)new LightningBoltEntity(e.m_9236_(), x, (double)pos.m_123342_() + d0, z, rotation, delay, (LivingEntity)e, 20, (float)dmg));
        }
    }

    private static Entity createElectricity(LivingEntity entity, Vec3 vec, float angle, float damage) {
        return new ElectricityEntity(entity, vec.f_82479_, vec.f_82480_, vec.f_82481_, entity.m_9236_(), damage, angle, 20.0f);
    }
}

