/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.terrain;

import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorEvents;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.config.SystemMode;
import folk.sisby.surveyor.packet.S2CUpdateRegionPacket;
import folk.sisby.surveyor.terrain.ChunkSummary;
import folk.sisby.surveyor.terrain.RegionSummary;
import folk.sisby.surveyor.util.ChunkUtil;
import folk.sisby.surveyor.util.RegionPos;
import folk.sisby.surveyor.util.RegistryPalette;
import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;

public class WorldTerrainSummary {
    protected final ResourceKey<Level> worldKey;
    protected final RegistryAccess registryManager;
    protected final Map<RegionPos, RegionSummary> regions = new ConcurrentHashMap<RegionPos, RegionSummary>();
    protected final File folder;
    protected final Map<RegionPos, Map<UUID, BitSet>> queuedUpdates = new LinkedHashMap<RegionPos, Map<UUID, BitSet>>();

    public WorldTerrainSummary(ResourceKey<Level> worldKey, RegistryAccess registryManager, Map<RegionPos, RegionSummary> regions, File folder) {
        this.worldKey = worldKey;
        this.registryManager = registryManager;
        this.regions.putAll(regions);
        this.folder = folder;
    }

    public static Set<ChunkPos> toKeys(Map<RegionPos, BitSet> bitSets) {
        return WorldTerrainSummary.toKeys(bitSets, Comparator.comparingInt(pos -> pos.x() + pos.z()));
    }

    public static Set<ChunkPos> toKeys(Map<RegionPos, BitSet> bitSets, ChunkPos originChunk) {
        ChunkPos oPos = new ChunkPos(RegionPos.chunkToRegion(originChunk.f_45578_), RegionPos.chunkToRegion(originChunk.f_45579_));
        return WorldTerrainSummary.toKeys(bitSets, Comparator.comparingDouble(pos -> (oPos.f_45578_ - pos.x()) * (oPos.f_45578_ - pos.x()) + (oPos.f_45579_ - pos.z()) * (oPos.f_45579_ - pos.z())));
    }

    public static Set<ChunkPos> toKeys(Map<RegionPos, BitSet> bitSets, Comparator<RegionPos> regionComparator) {
        LinkedHashSet<ChunkPos> set = new LinkedHashSet<ChunkPos>();
        bitSets.entrySet().stream().sorted(Map.Entry.comparingByKey(regionComparator)).forEach(e -> ((BitSet)e.getValue()).stream().forEach(i -> set.add(((RegionPos)e.getKey()).toChunk(i))));
        return set;
    }

    public static WorldTerrainSummary load(Level world, File folder) {
        HashMap<RegionPos, RegionSummary> regions = new HashMap<RegionPos, RegionSummary>();
        ChunkUtil.getRegionFiles(folder, "c").forEach((pos, file) -> regions.put((RegionPos)pos, RegionSummary.fromFile(file, world.m_9598_(), pos)));
        return new WorldTerrainSummary((ResourceKey<Level>)world.m_46472_(), world.m_9598_(), regions, folder);
    }

    public static void onChunkLoad(Level world, LevelChunk chunk) {
        ChunkSummary chunkSummary;
        WorldSummary summary = WorldSummary.of(world);
        if (!(summary.terrain() == null || (chunkSummary = summary.terrain().get(chunk.m_7697_())) != null && Surveyor.CONFIG.lazyClientUpdating && ChunkUtil.airCount((ChunkAccess)chunk).equals(chunkSummary.getAirCount()))) {
            summary.terrain().put(world, chunk);
        }
    }

    public static void onChunkUnload(Level world, LevelChunk chunk) {
        WorldSummary summary = WorldSummary.of(world);
        if (summary.terrain() != null && chunk.m_6344_()) {
            summary.terrain().put(world, chunk);
        }
    }

    public boolean contains(ChunkPos pos) {
        RegionPos regionPos = RegionPos.of(pos);
        return this.regions.containsKey(regionPos) && this.regions.get(regionPos).contains(pos);
    }

    public ChunkSummary get(ChunkPos pos) {
        RegionPos regionPos = RegionPos.of(pos);
        return this.regions.containsKey(regionPos) ? this.regions.get(regionPos).get(pos) : null;
    }

    public RegionSummary getRegion(RegionPos regionPos) {
        return this.regions.computeIfAbsent(regionPos, k -> RegionSummary.fromEmpty(this.folder, regionPos, this.registryManager));
    }

    public RegistryPalette.ValueView getBiomePalette(ChunkPos pos) {
        RegionPos regionPos = RegionPos.of(pos);
        return this.regions.get(regionPos).getBiomePalette();
    }

    public RegistryPalette.ValueView getBlockPalette(ChunkPos pos) {
        RegionPos regionPos = RegionPos.of(pos);
        return this.regions.get(regionPos).getBlockPalette();
    }

    public Map<RegionPos, BitSet> bitSet(SurveyorExploration exploration) {
        HashMap<RegionPos, BitSet> map = new HashMap<RegionPos, BitSet>();
        this.regions.forEach((p, r) -> map.put((RegionPos)p, r.bitSet()));
        return exploration == null ? map : exploration.limitTerrainBitset(this.worldKey, map);
    }

    public void put(Level world, LevelChunk chunk) {
        if (Surveyor.CONFIG.terrain == SystemMode.FROZEN) {
            return;
        }
        this.regions.computeIfAbsent(RegionPos.of(chunk.m_7697_()), k -> RegionSummary.fromEmpty(this.folder, RegionPos.of(chunk.m_7697_()), this.registryManager)).putChunk(world, chunk);
        SurveyorEvents.Invoke.terrainUpdated(world, chunk.m_7697_());
    }

    public static void onTick(ServerLevel world) {
        WorldTerrainSummary summary = WorldSummary.of((Level)world).terrain();
        if (summary != null) {
            summary.serverTick(world);
        }
    }

    public void sendUpdateForRegion(Level world, RegionPos rPos, ServerPlayer player, BitSet set) {
        RegionSummary region = this.getRegion(rPos);
        SurveyorExploration personalExploration = SurveyorExploration.of(player);
        BitSet personalSet = personalExploration.limitTerrainBitset((ResourceKey<Level>)world.m_46472_(), rPos, (BitSet)set.clone());
        if (!personalSet.isEmpty()) {
            S2CUpdateRegionPacket.of(false, rPos, region, personalSet).send(player);
        }
        set.andNot(personalSet);
        if (!set.isEmpty()) {
            S2CUpdateRegionPacket.of(true, rPos, region, set).send(player);
        }
    }

    public void serverTick(ServerLevel world) {
        if (world.m_7654_().m_129921_() % Surveyor.CONFIG.networking.terrainTicks != 0) {
            return;
        }
        this.queuedUpdates.keySet().stream().findFirst().ifPresent(rPos -> {
            RegionSummary region = this.getRegion((RegionPos)rPos);
            this.queuedUpdates.get(rPos).forEach((uuid, set) -> {
                ServerPlayer player = world.m_7654_().m_6846_().m_11259_(uuid);
                if (player != null) {
                    this.sendUpdateForRegion((Level)world, (RegionPos)rPos, player, (BitSet)set);
                }
            });
            this.queuedUpdates.remove(rPos);
            if (region.isLoaded() && region.isUnloaded((Level)world)) {
                region.save(true);
            }
        });
    }

    public void queueUpdate(ServerLevel world, RegionPos rPos, BitSet set, ServerPlayer player) {
        if (this.getRegion(rPos).isLoaded()) {
            this.sendUpdateForRegion((Level)world, rPos, player, set);
        } else {
            this.queuedUpdates.computeIfAbsent(rPos, k -> new LinkedHashMap()).put(player.m_20148_(), set);
        }
    }

    public int save(Level world) {
        ArrayList savedRegions = new ArrayList();
        this.regions.forEach((pos, summary) -> {
            if (summary.isLoaded()) {
                if (summary.isDirty()) {
                    savedRegions.add(pos);
                }
                summary.save(summary.isUnloaded(world));
            }
        });
        return savedRegions.size();
    }

    public boolean isDirty() {
        return this.regions.values().stream().anyMatch(RegionSummary::isDirty);
    }
}

