/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.structure;

import com.google.common.collect.Multimap;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.config.SystemMode;
import folk.sisby.surveyor.structure.JigsawPieceSummary;
import folk.sisby.surveyor.structure.StructurePieceSummary;
import folk.sisby.surveyor.structure.StructureStartSummary;
import folk.sisby.surveyor.util.MapUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public class RegionStructureSummary {
    public static final String KEY_STRUCTURES = "structures";
    public static final String KEY_STARTS = "starts";
    public static final String KEY_PIECES = "pieces";
    protected final Map<ResourceKey<Structure>, Map<ChunkPos, StructureStartSummary>> structures = new ConcurrentHashMap<ResourceKey<Structure>, Map<ChunkPos, StructureStartSummary>>();
    protected boolean dirty = false;

    RegionStructureSummary() {
    }

    RegionStructureSummary(Map<ResourceKey<Structure>, Map<ChunkPos, StructureStartSummary>> structures) {
        this.structures.putAll(structures);
    }

    protected static StructureStartSummary summarisePieces(StructurePieceSerializationContext context, StructureStart start) {
        ArrayList<StructurePieceSummary> pieces = new ArrayList<StructurePieceSummary>();
        for (StructurePiece piece : start.m_73602_()) {
            if (piece.m_210000_().equals((Object)StructurePieceType.f_210125_)) {
                pieces.addAll(JigsawPieceSummary.tryFromPiece(piece));
                continue;
            }
            pieces.add(StructurePieceSummary.fromPiece(context, piece, start.m_73602_().size() <= 10));
        }
        return new StructureStartSummary(pieces);
    }

    public static StructurePieceSummary readStructurePieceNbt(CompoundTag nbt) {
        if (nbt.m_128461_("id").equals(BuiltInRegistries.f_257014_.m_7981_((Object)StructurePieceType.f_210125_).toString())) {
            return new JigsawPieceSummary(nbt);
        }
        return new StructurePieceSummary(nbt);
    }

    protected static RegionStructureSummary readNbt(CompoundTag nbt) {
        ConcurrentHashMap<ResourceKey<Structure>, Map<ChunkPos, StructureStartSummary>> structures = new ConcurrentHashMap<ResourceKey<Structure>, Map<ChunkPos, StructureStartSummary>>();
        CompoundTag structuresCompound = nbt.m_128469_(KEY_STRUCTURES);
        for (String structureId : structuresCompound.m_128431_()) {
            ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation(structureId));
            CompoundTag structureCompound = structuresCompound.m_128469_(structureId);
            CompoundTag startsCompound = structureCompound.m_128469_(KEY_STARTS);
            for (String posKey : startsCompound.m_128431_()) {
                int x = Integer.parseInt(posKey.split(",")[0]);
                int z = Integer.parseInt(posKey.split(",")[1]);
                CompoundTag startCompound = startsCompound.m_128469_(posKey);
                ArrayList<StructurePieceSummary> pieces = new ArrayList<StructurePieceSummary>();
                for (Tag pieceElement : startCompound.m_128437_(KEY_PIECES, 10)) {
                    pieces.add(RegionStructureSummary.readStructurePieceNbt((CompoundTag)pieceElement));
                }
                structures.computeIfAbsent((ResourceKey<Structure>)key, p -> new ConcurrentHashMap()).put(new ChunkPos(x, z), new StructureStartSummary(pieces));
            }
        }
        return new RegionStructureSummary(structures);
    }

    public boolean contains(Level world, StructureStart start) {
        ResourceKey key = world.m_9598_().m_175515_(Registries.f_256944_).m_7854_((Object)start.m_226861_()).orElse(null);
        if (key == null) {
            Surveyor.LOGGER.error("Encountered an unregistered structure! {} | {}", (Object)start, (Object)start.m_226861_());
            return true;
        }
        return this.structures.containsKey(key) && this.structures.get(key).containsKey(start.m_163625_());
    }

    public boolean contains(ResourceKey<Structure> key, ChunkPos pos) {
        return this.structures.containsKey(key) && this.structures.get(key).containsKey(pos);
    }

    public StructureStartSummary get(ResourceKey<Structure> key, ChunkPos pos) {
        return this.structures.get(key).get(pos);
    }

    public Multimap<ResourceKey<Structure>, ChunkPos> keySet() {
        return MapUtil.keyMultiMap(this.structures);
    }

    public void put(ServerLevel world, StructureStart start) {
        ResourceKey key = (ResourceKey)world.m_9598_().m_175515_(Registries.f_256944_).m_7854_((Object)start.m_226861_()).orElseThrow();
        this.structures.computeIfAbsent((ResourceKey<Structure>)key, k -> new ConcurrentHashMap());
        ChunkPos pos = start.m_163625_();
        StructureStartSummary summary = RegionStructureSummary.summarisePieces(StructurePieceSerializationContext.m_192770_((ServerLevel)world), start);
        this.structures.get(key).put(pos, summary);
        this.dirty();
    }

    public void put(ResourceKey<Structure> key, ChunkPos pos, StructureStartSummary summary) {
        this.structures.computeIfAbsent(key, k -> new ConcurrentHashMap()).put(pos, summary);
        this.dirty();
    }

    protected CompoundTag writeNbt(CompoundTag nbt) {
        CompoundTag structuresCompound = new CompoundTag();
        this.structures.forEach((key, starts) -> {
            CompoundTag structureCompound = new CompoundTag();
            CompoundTag startsCompound = new CompoundTag();
            starts.forEach((pos, summary) -> {
                ListTag pieceList = new ListTag(summary.getChildren().stream().map(p -> p.toNbt()).toList(), 10);
                CompoundTag startCompound = new CompoundTag();
                startCompound.m_128365_(KEY_PIECES, (Tag)pieceList);
                startsCompound.m_128365_("%s,%s".formatted(pos.f_45578_, pos.f_45579_), (Tag)startCompound);
            });
            structureCompound.m_128365_(KEY_STARTS, (Tag)startsCompound);
            structuresCompound.m_128365_(key.m_135782_().toString(), (Tag)structureCompound);
        });
        nbt.m_128365_(KEY_STRUCTURES, (Tag)structuresCompound);
        return nbt;
    }

    public boolean isDirty() {
        return this.dirty && Surveyor.CONFIG.structures != SystemMode.FROZEN;
    }

    private void dirty() {
        this.dirty = true;
    }
}

