/*
 * Decompiled with CFR 0.152.
 */
package terrablender.api;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;

public class ModifiedVanillaOverworldBuilder {
    private Map<ResourceKey<Biome>, ResourceKey<Biome>> originalBiomeMappings = Maps.newHashMap();
    private Map<Climate.ParameterPoint, ResourceKey<Biome>> parameterBiomeMappings = Maps.newHashMap();
    private Map<Climate.ParameterPoint, Climate.ParameterPoint> parameterMappings = Maps.newHashMap();
    private List<Climate.ParameterPoint> parametersToRemove = Lists.newArrayList();
    private final OverworldBiomeBuilder biomeBuilder = new OverworldBiomeBuilder();

    public void replaceBiome(ResourceKey<Biome> original, ResourceKey<Biome> replacement) {
        this.originalBiomeMappings.put(original, replacement);
    }

    public void replaceBiome(Climate.ParameterPoint point, ResourceKey<Biome> biome) {
        this.parameterBiomeMappings.put(point, biome);
    }

    public void replaceParameter(Climate.ParameterPoint original, Climate.ParameterPoint replacement) {
        this.parameterMappings.put(original, replacement);
    }

    public void removeParameter(Climate.ParameterPoint parameter) {
        this.parametersToRemove.add(parameter);
    }

    public List<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> build() {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        Consumer<Pair> mapper = pair -> {
            Climate.ParameterPoint parameters = (Climate.ParameterPoint)pair.getFirst();
            ResourceKey<Biome> biome = (ResourceKey<Biome>)pair.getSecond();
            if (!this.parametersToRemove.contains(parameters)) {
                if (this.originalBiomeMappings.containsKey(biome)) {
                    biome = this.originalBiomeMappings.get(biome);
                } else if (this.parameterBiomeMappings.containsKey(parameters)) {
                    biome = this.parameterBiomeMappings.get(parameters);
                }
                if (this.parameterMappings.containsKey(parameters)) {
                    parameters = this.parameterMappings.get(parameters);
                }
                builder.add((Object)Pair.of((Object)parameters, biome));
            }
        };
        this.biomeBuilder.m_187175_(mapper);
        return builder.build();
    }
}

