/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.mixin;

import com.minelittlepony.common.event.SkinFilterCallback;
import com.mojang.blaze3d.platform.NativeImage;
import net.minecraft.client.renderer.texture.HttpTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={HttpTexture.class})
public abstract class MixinPlayerSkinTexture
extends SimpleTexture {
    private static final String FILTER_IMAGE = "remapTexture(Lnet/minecraft/client/texture/NativeImage;)Lnet/minecraft/client/texture/NativeImage;";
    private static final String STRIP_COLOR = "stripColor(Lnet/minecraft/client/texture/NativeImage;IIII)V";
    private static final String STRIP_ALPHA = "stripAlpha(Lnet/minecraft/client/texture/NativeImage;IIII)V";
    private static boolean isLegacy;

    private MixinPlayerSkinTexture() {
        super(null);
    }

    @Inject(method={"remapTexture(Lnet/minecraft/client/texture/NativeImage;)Lnet/minecraft/client/texture/NativeImage;"}, at={@At(value="HEAD")})
    private void beforeUpdate(NativeImage image, CallbackInfoReturnable<NativeImage> info) {
        isLegacy = image.m_85084_() == 32;
    }

    @Inject(method={"remapTexture(Lnet/minecraft/client/texture/NativeImage;)Lnet/minecraft/client/texture/NativeImage;"}, at={@At(value="RETURN")})
    private void update(NativeImage image, CallbackInfoReturnable<NativeImage> ci) {
        ((SkinFilterCallback)SkinFilterCallback.EVENT.invoker()).processImage((NativeImage)ci.getReturnValue(), isLegacy);
    }

    @Inject(method={"stripAlpha(Lnet/minecraft/client/texture/NativeImage;IIII)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void cancelAlphaStrip(NativeImage image, int beginX, int beginY, int endX, int endY, CallbackInfo info) {
        if (((SkinFilterCallback)SkinFilterCallback.EVENT.invoker()).shouldAllowTransparency(image, isLegacy)) {
            info.cancel();
        }
    }

    @Inject(method={"stripColor(Lnet/minecraft/client/texture/NativeImage;IIII)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void cancelColorStrip(NativeImage image, int beginX, int beginY, int endX, int endY, CallbackInfo info) {
        if (((SkinFilterCallback)SkinFilterCallback.EVENT.invoker()).shouldAllowTransparency(image, isLegacy)) {
            info.cancel();
        }
    }
}

