/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.client.gui.element;

import com.minelittlepony.common.client.gui.GameGui;
import com.minelittlepony.common.client.gui.IViewRoot;
import com.minelittlepony.common.client.gui.dimension.Bounds;
import com.minelittlepony.common.client.gui.dimension.IBounded;
import com.minelittlepony.common.client.gui.scrollable.ScrollOrientation;
import com.minelittlepony.common.client.gui.scrollable.ScrollbarScrubber;
import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class Scrollbar
implements GuiEventListener,
Renderable,
IBounded {
    public static final int SCROLLBAR_THICKNESS = 6;
    private boolean dragging;
    private boolean touching;
    private boolean focused;
    private final ScrollbarScrubber scrubber;
    private final ScrollOrientation orientation;
    private final IViewRoot rootView;
    private final Bounds bounds;
    private Bounds containerBounds;
    private Bounds contentBounds;
    private double prevMousePosition;
    public boolean layoutToEnd;

    @Deprecated
    public Scrollbar(IViewRoot rootView) {
        this(rootView, ScrollOrientation.VERTICAL);
    }

    public Scrollbar(IViewRoot rootView, ScrollOrientation orientation) {
        this.rootView = rootView;
        this.orientation = orientation;
        this.contentBounds = this.bounds = new Bounds(0, 0, orientation.pick(0, 6), orientation.pick(6, 0));
        this.containerBounds = rootView.getBounds();
        this.scrubber = new ScrollbarScrubber(orientation);
    }

    public void reposition() {
        this.contentBounds = this.rootView.getContentBounds().offset(this.rootView.getContentPadding());
        this.containerBounds = this.rootView.getBounds();
        int end = this.layoutToEnd ? this.orientation.getWidth(this.rootView.getBounds()) - 6 : this.orientation.pick(this.contentBounds.bottom(), this.contentBounds.right());
        this.bounds.left = this.orientation.pick(0, end);
        this.bounds.top = this.orientation.pick(end, 0);
        this.bounds.height = this.orientation.pick(6, this.rootView.getBounds().height);
        this.bounds.width = this.orientation.pick(this.rootView.getBounds().width, 6);
        this.scrubber.reposition(this.containerBounds, this.contentBounds);
    }

    @Deprecated
    public int getVerticalScrollAmount() {
        return this.orientation == ScrollOrientation.VERTICAL ? this.scrubber.getPosition() : 0;
    }

    public ScrollbarScrubber getScrubber() {
        return this.scrubber;
    }

    @Deprecated
    public int getHorizontalScrollAmount() {
        return this.orientation == ScrollOrientation.HORIZONTAL ? this.scrubber.getPosition() : 0;
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float partialTicks) {
        if (this.scrubber.getMaximum() <= 0) {
            return;
        }
        this.scrubber.update(this.rootView.getBounds(), this.contentBounds, mouseX, mouseY, partialTicks, this.touching || this.dragging);
        this.renderScrubber(this.scrubber, this.orientation, context);
    }

    private void renderScrubber(ScrollbarScrubber scrubber, ScrollOrientation orientation, GuiGraphics context) {
        int scrubberStart = scrubber.getStart();
        int scrubberEnd = scrubberStart + scrubber.getLength();
        this.renderBackground(context, this.bounds.top, this.bounds.left, this.bounds.bottom(), this.bounds.right());
        this.renderBar(context, orientation.pick(scrubberStart, this.bounds.left), orientation.pick(scrubberEnd, this.bounds.right()), orientation.pick(this.bounds.top, scrubberStart), orientation.pick(this.bounds.bottom(), scrubberEnd));
    }

    private void renderBackground(GuiGraphics context, int top, int left, int bottom, int right) {
        context.m_280509_(left, top, right, bottom, -1778384896);
    }

    private void renderBar(GuiGraphics context, int left, int right, int top, int bottom) {
        context.m_280509_(left, top, right, bottom, this.dragging ? -8355702 : -8355712);
        context.m_280509_(left, top, right - 1, bottom - 1, this.dragging ? -4144900 : -4144960);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        mouseY = this.calculateInternalYPosition(mouseY);
        mouseX = this.calculateInternalXPosition(mouseX);
        double mousePosition = this.orientation.pick(mouseX, mouseY);
        this.dragging = false;
        this.touching = false;
        if (!this.m_5953_(mouseX, mouseY)) {
            this.touching = true;
            return this.m_5953_(mouseX, mouseY);
        }
        float grabPosition = this.scrubber.getGrabPosition(mousePosition);
        if (grabPosition < 0.0f || grabPosition > 1.0f) {
            this.scrubber.scrollBy((int)Math.signum(grabPosition) * 50, true);
        } else {
            GameGui.playSound((Holder.Reference<SoundEvent>)SoundEvents.f_12490_);
            this.dragging = true;
        }
        this.prevMousePosition = mousePosition;
        return this.m_5953_(mouseX, mouseY);
    }

    private double calculateInternalYPosition(double mouseY) {
        double yOffset = -this.rootView.getScrollY() - this.rootView.getContentPadding().top;
        return mouseY - yOffset;
    }

    private double calculateInternalXPosition(double mouseX) {
        double xOffset = -this.rootView.getScrollX() - this.rootView.getContentPadding().left;
        return mouseX - xOffset;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double differX, double differY) {
        mouseY = this.calculateInternalYPosition(mouseY);
        mouseX = this.calculateInternalXPosition(mouseX);
        double mousePosition = this.orientation.pick(mouseX, mouseY);
        Window window = Minecraft.m_91087_().m_91268_();
        double motionRatio = (double)this.orientation.pick(window.m_85443_(), window.m_85444_()) / (double)this.orientation.pick(this.bounds.width, this.bounds.height);
        double change = motionRatio * (this.prevMousePosition - mousePosition);
        if (this.dragging) {
            this.scrubber.scrollBy(-((int)change), false);
        } else if (this.touching) {
            this.scrubber.scrollBy(-((int)change) * 16, true);
            this.scrubber.setMomentum(-((int)change));
        }
        this.prevMousePosition = mousePosition;
        return this.m_5953_(mouseX, mouseY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.touching = false;
        this.dragging = false;
        return this.m_5953_(this.calculateInternalXPosition(mouseX), this.calculateInternalYPosition(mouseY));
    }

    public void scrollBy(double amount) {
        this.scrubber.scrollBy(-amount, true);
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.scrubber.getMaximum() > 0 && this.getBounds().contains(mouseX, mouseY);
    }

    @Override
    public Bounds getBounds() {
        return this.bounds;
    }

    @Override
    public void setBounds(Bounds bounds) {
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.m_93696_()) {
            if (keyCode == this.orientation.pick(263, 265)) {
                this.scrubber.scrollBy(-10.0, true);
                return true;
            }
            if (keyCode == this.orientation.pick(262, 264)) {
                this.scrubber.scrollBy(10.0, true);
                return true;
            }
            if (keyCode == 269) {
                this.scrubber.scrollToEnd(true);
                return true;
            }
            if (keyCode == 268) {
                this.scrubber.scrollToBeginning(true);
                return true;
            }
        }
        return false;
    }

    public void m_93692_(boolean focused) {
        this.focused = focused;
    }

    public boolean m_93696_() {
        return this.focused || this.dragging;
    }
}

