/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.client.gui;

import com.minelittlepony.common.client.gui.GameGui;
import com.minelittlepony.common.client.gui.dimension.Bounds;
import com.minelittlepony.common.client.gui.dimension.Padding;
import com.minelittlepony.common.client.gui.element.Scrollbar;
import com.minelittlepony.common.client.gui.scrollable.ScrollOrientation;
import com.minelittlepony.common.util.render.ClippingSpace;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.CommonComponents;

public class ScrollContainer
extends GameGui {
    public final Scrollbar verticalScrollbar;
    @Deprecated
    public final Scrollbar scrollbar;
    public final Scrollbar horizontalScrollbar;
    public final Padding margin;
    public int backgroundColor;
    public int decorationColor;
    private final Deque<Runnable> delayedCalls;

    public ScrollContainer() {
        super(CommonComponents.f_237098_);
        this.scrollbar = this.verticalScrollbar = new Scrollbar(this, ScrollOrientation.VERTICAL);
        this.horizontalScrollbar = new Scrollbar(this, ScrollOrientation.HORIZONTAL);
        this.margin = new Padding(0, 0, 0, 0);
        this.backgroundColor = 0x66000000;
        this.decorationColor = -301989888;
        this.delayedCalls = new ArrayDeque<Runnable>();
        this.horizontalScrollbar.layoutToEnd = true;
        this.m_6575_(Minecraft.m_91087_(), 0, 0);
    }

    public void m_7856_() {
        this.init(() -> {});
    }

    public void init(Runnable contentInitializer) {
        this.m_169413_();
        this.f_96543_ = this.getBounds().width = this.f_96541_.m_91268_().m_85445_() - this.margin.left - this.margin.right;
        this.f_96544_ = this.getBounds().height = this.f_96541_.m_91268_().m_85446_() - this.margin.top - this.margin.bottom;
        this.getBounds().top = this.margin.top;
        this.getBounds().left = this.margin.left;
        contentInitializer.run();
        this.verticalScrollbar.reposition();
        this.horizontalScrollbar.reposition();
        this.getChildElements().add(this.verticalScrollbar);
        this.getChildElements().add(this.horizontalScrollbar);
    }

    @Override
    public final void m_88315_(GuiGraphics context, int mouseX, int mouseY, float partialTicks) {
        ClippingSpace.renderClipped(this.margin.left, this.margin.top, this.getBounds().width, this.getBounds().height, () -> {
            PoseStack matrices = context.m_280168_();
            matrices.m_85836_();
            this.getBounds().translate(matrices);
            this.drawBackground(context, mouseX, mouseY, partialTicks);
            Padding padding = this.getContentPadding();
            matrices.m_85836_();
            matrices.m_252880_((float)(this.getScrollX() + padding.left), (float)(this.getScrollY() + padding.top), 0.0f);
            this.renderContents(context, mouseX < this.margin.left || mouseX > this.margin.left + this.getBounds().width ? -1000 : mouseX + this.getMouseXOffset(), mouseY < this.margin.top || mouseY > this.margin.top + this.getBounds().height ? -1000 : mouseY + this.getMouseYOffset(), partialTicks);
            matrices.m_85849_();
            this.verticalScrollbar.m_88315_(context, mouseX - this.margin.left, mouseY - this.margin.top, partialTicks);
            this.horizontalScrollbar.m_88315_(context, mouseX - this.margin.left, mouseY - this.margin.top, partialTicks);
            this.drawDecorations(context, mouseX, mouseY, partialTicks);
            matrices.m_85849_();
        });
        this.drawOverlays(context, mouseX, mouseY, partialTicks);
    }

    protected void renderContents(GuiGraphics context, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(context, mouseX, mouseY, partialTicks);
    }

    protected void drawBackground(GuiGraphics context, int mouseX, int mouseY, float partialTicks) {
        context.m_280509_(0, 0, this.f_96543_, this.f_96544_, this.backgroundColor);
    }

    protected void drawDecorations(GuiGraphics context, int mouseX, int mouseY, float partialTicks) {
        context.m_280024_(0, -3, this.f_96543_, 5, this.decorationColor, 0);
        context.m_280024_(0, this.f_96544_ - 6, this.f_96543_, this.f_96544_ + 3, 0, this.decorationColor);
    }

    protected void drawOverlays(GuiGraphics context, int mouseX, int mouseY, float partialTicks) {
        Runnable task;
        while ((task = this.delayedCalls.poll()) != null) {
            task.run();
        }
    }

    public void m_94757_(double mouseX, double mouseY) {
        if (this.m_5953_(mouseX, mouseY)) {
            super.m_7979_(mouseX + (double)this.getMouseXOffset(), mouseY + (double)this.getMouseYOffset(), 0, 0.0, 0.0);
        }
    }

    public int getMouseYOffset() {
        return -this.getBounds().top - this.getScrollY() - this.getContentPadding().top;
    }

    public int getMouseXOffset() {
        return -this.getBounds().left - this.getScrollX() - this.getContentPadding().left;
    }

    @Override
    public int getScrollX() {
        return -this.horizontalScrollbar.getScrubber().getPosition();
    }

    @Override
    public int getScrollY() {
        return -this.verticalScrollbar.getScrubber().getPosition();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return this.m_5953_(mouseX, mouseY) && super.m_6375_(mouseX + (double)this.getMouseXOffset(), mouseY + (double)this.getMouseYOffset(), button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return this.m_5953_(mouseX, mouseY) && super.m_6348_(mouseX + (double)this.getMouseXOffset(), mouseY + (double)this.getMouseYOffset(), button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double differX, double differY) {
        return super.m_7979_(mouseX + (double)this.getMouseXOffset(), mouseY + (double)this.getMouseYOffset(), button, differX, differY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        this.verticalScrollbar.scrollBy((float)Math.signum(amount) * 12.0f);
        return this.m_5953_(mouseX, mouseY) && super.m_6050_(mouseX + (double)this.getMouseXOffset(), mouseY + (double)this.getMouseYOffset(), amount);
    }

    protected void renderOutside(GuiGraphics context, int mouseX, int mouseY, BiConsumer<Integer, Integer> renderCall) {
        this.delayedCalls.add(() -> ClippingSpace.renderUnclipped(() -> {
            context.m_280168_().m_85836_();
            renderCall.accept(mouseX - this.getMouseXOffset(), mouseY - this.getMouseYOffset());
            context.m_280168_().m_85849_();
        }));
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.getBounds().contains(mouseX, mouseY);
    }

    @Override
    public void setBounds(Bounds bounds) {
        this.margin.top = bounds.top;
        this.margin.left = bounds.left;
    }

    @Override
    protected boolean isUnFixedPosition(Bounds bound) {
        return bound != this.verticalScrollbar.getBounds() && bound != this.horizontalScrollbar.getBounds();
    }
}

