/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.common.entity.entities;

import dev.xylonity.knightlib.registry.KnightLibParticles;
import dev.xylonity.knightquest.common.entity.entities.EldBombEntity;
import dev.xylonity.knightquest.config.values.KQConfigValues;
import dev.xylonity.knightquest.registry.KnightQuestEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EldKnightEntity
extends Monster
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Level serverWorld;
    private boolean summoned = false;
    private int counter;

    public EldKnightEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
        this.serverWorld = world;
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 90.0).m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22283_, (double)0.4f).m_22268_(Attributes.f_22279_, (double)0.55f).m_22268_(Attributes.f_22278_, (double)0.8f).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.45, false));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        AttributeInstance maxHealth = this.m_21051_(Attributes.f_22276_);
        if (maxHealth != null) {
            maxHealth.m_22100_(KQConfigValues.ELDKNIGHT_MAX_HEALTH);
            this.m_21153_((float)KQConfigValues.ELDKNIGHT_MAX_HEALTH);
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackcontroller", 0, this::attackPredicate)});
    }

    private PlayState attackPredicate(AnimationState<?> event) {
        if (this.f_20911_ && event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            event.getController().forceAnimationReset();
            event.getController().setAnimation(RawAnimation.begin().then("attack", Animation.LoopType.PLAY_ONCE));
            this.f_20911_ = false;
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
        } else {
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @NotNull
    protected SoundEvent m_5501_() {
        return SoundEvents.f_144067_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12059_;
    }

    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return SoundEvents.f_12008_;
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        this.m_5496_(SoundEvents.f_12010_, 0.15f, 1.0f);
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.counter;
        if (!this.summoned && (double)this.m_21223_() < (double)this.m_21233_() * 0.5) {
            this.summoned = true;
            this.summonMinions();
        }
        if (this.summoned && this.counter > 80) {
            if (KQConfigValues.POISON_ELDKNIGHT) {
                this.summonParticle();
                this.poisonNearbyPlayers();
            }
            if ((double)this.m_21223_() < (double)this.m_21233_() * 0.75) {
                this.m_5634_(KQConfigValues.HEAL_ELDKNIGHT);
            }
            this.counter = 0;
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource.m_276093_(DamageTypes.f_268448_) || pSource.m_276093_(DamageTypes.f_268565_)) {
            return super.m_6469_(pSource, pAmount * 0.15f);
        }
        if (pSource.m_276093_(DamageTypes.f_268739_)) {
            return super.m_6469_(pSource, pAmount * 0.1f);
        }
        return super.m_6469_(pSource, pAmount);
    }

    private void summonMinions() {
        double distance = 3.0;
        double angle = KQConfigValues.HEAL_ELDKNIGHT != 0.0f ? Math.toRadians(360.0 / (double)KQConfigValues.NUM_ELDBOMB_ELDKNIGHT) : Math.toRadians(120.0);
        boolean punch = false;
        for (int i = 0; i < KQConfigValues.NUM_ELDBOMB_ELDKNIGHT; ++i) {
            double xOffset = distance * Math.cos(angle * (double)i);
            double zOffset = distance * Math.sin(angle * (double)i);
            EldBombEntity entity = (EldBombEntity)((EntityType)KnightQuestEntities.ELDBOMB.get()).m_20615_(this.serverWorld);
            if (entity == null) continue;
            BlockPos spawnPos = this.m_20183_().m_7918_((int)xOffset, 0, (int)zOffset);
            if (!this.serverWorld.m_8055_(spawnPos).m_60795_()) {
                int d = 1;
                while ((double)d <= distance) {
                    BlockPos adjustedPos = this.m_20183_().m_7918_((int)(xOffset / (double)d), 0, (int)(zOffset / (double)d));
                    if (this.serverWorld.m_8055_(adjustedPos).m_60795_()) {
                        spawnPos = adjustedPos;
                        break;
                    }
                    ++d;
                }
            }
            entity.m_20035_(spawnPos, 0.0f, 0.0f);
            this.serverWorld.m_7967_((Entity)entity);
            for (int j = 0; j < 20; ++j) {
                this.serverWorld.m_7106_((ParticleOptions)ParticleTypes.f_123806_, (double)spawnPos.m_123341_() + 0.5 + this.serverWorld.f_46441_.m_188500_() - 0.5, (double)spawnPos.m_123342_() + 0.5 + this.serverWorld.f_46441_.m_188500_() - 0.5, (double)spawnPos.m_123343_() + 0.5 + this.serverWorld.f_46441_.m_188500_() - 0.5, 0.0, 0.0, 0.0);
            }
            if (punch) continue;
            this.serverWorld.m_45976_(Player.class, entity.m_20191_().m_82400_(5.0)).forEach(player -> {
                Vec3 direction = player.m_20182_().m_82546_(this.m_20182_()).m_82541_().m_82490_(1.5);
                player.m_5997_(direction.f_82479_, direction.f_82480_ + 0.5, direction.f_82481_);
            });
            punch = true;
        }
        int particleCount = 120;
        double particleRadius = 4.0;
        for (int i = 0; i < particleCount; ++i) {
            double angleOffset = Math.PI * 2 / (double)particleCount * (double)i;
            double xParticleOffset = particleRadius * Math.cos(angleOffset);
            double zParticleOffset = particleRadius * Math.sin(angleOffset);
            this.serverWorld.m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_() + xParticleOffset, this.m_20186_() - 0.1, this.m_20189_() + zParticleOffset, 0.0, 0.05, 0.0);
        }
        this.serverWorld.m_5594_(null, this.m_20183_(), SoundEvents.f_11868_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private void poisonNearbyPlayers() {
        this.serverWorld.m_45976_(Player.class, this.m_20191_().m_82400_(3.5)).forEach(player -> player.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 0)));
    }

    private void summonParticle() {
        this.serverWorld.m_7106_((ParticleOptions)KnightLibParticles.STARSET.get(), this.m_20185_(), this.m_20186_() - 0.48, this.m_20189_(), 4.0, 0.0, 0.0);
    }
}

