/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials.client;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.blay09.mods.inventoryessentials.InventoryUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ClientInventorySorting {
    private static final Comparator<ItemStack> defaultComparator = Comparator.comparing(itemStack -> itemStack.m_41786_().getString(), String.CASE_INSENSITIVE_ORDER).thenComparing(Comparator.comparingInt(ItemStack::m_41613_).reversed()).thenComparing(itemStack -> itemStack.m_41793_() ? 0 : 1).thenComparingInt(ItemStack::m_41773_).thenComparing(itemStack -> Objects.toString(itemStack.m_41783_(), ""));

    public static boolean sort(AbstractContainerMenu menu, Slot baseSlot, SlotClicker clicker) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        ArrayList<Slot> slotsToSort = new ArrayList<Slot>();
        for (Slot slot : menu.f_38839_) {
            if (!ClientInventorySorting.isSortableSlot(slot) || !InventoryUtils.isSameInventory(baseSlot, slot, true)) continue;
            slotsToSort.add(slot);
        }
        if (slotsToSort.isEmpty()) {
            return false;
        }
        ClientInventorySorting.consolidateStacks(menu, slotsToSort, clicker);
        List<ItemStack> goalSorting = slotsToSort.stream().map(Slot::m_7993_).map(ItemStack::m_41777_).filter(stack -> !stack.m_41619_()).sorted(defaultComparator).toList();
        for (int i = 0; i < goalSorting.size(); ++i) {
            ItemStack currentStack;
            ItemStack goalStack = goalSorting.get(i);
            if (ItemStack.m_150942_((ItemStack)goalStack, (ItemStack)(currentStack = slotsToSort.get(i).m_7993_())) && goalStack.m_41613_() == currentStack.m_41613_()) continue;
            int foundSwapIndex = -1;
            for (int j = i + 1; j < slotsToSort.size(); ++j) {
                ItemStack candidateStack = slotsToSort.get(j).m_7993_();
                if (!ItemStack.m_150942_((ItemStack)goalStack, (ItemStack)candidateStack) || goalStack.m_41613_() != candidateStack.m_41613_()) continue;
                foundSwapIndex = j;
                break;
            }
            if (foundSwapIndex == -1) continue;
            ClientInventorySorting.swapSlots(menu, slotsToSort, i, foundSwapIndex, clicker);
        }
        return true;
    }

    private static void swapSlots(AbstractContainerMenu menu, List<Slot> slots, int firstIndex, int secondIndex, SlotClicker clicker) {
        if (firstIndex != secondIndex) {
            Slot firstSlot = slots.get(firstIndex);
            Slot secondSlot = slots.get(secondIndex);
            if (!firstSlot.m_6657_() || !secondSlot.m_6657_()) {
                Slot fromSlot = firstSlot.m_6657_() ? firstSlot : secondSlot;
                Slot toSlot = firstSlot.m_6657_() ? secondSlot : firstSlot;
                clicker.click(menu, fromSlot, 0, ClickType.PICKUP);
                clicker.click(menu, toSlot, 0, ClickType.PICKUP);
                return;
            }
            clicker.click(menu, firstSlot, 0, ClickType.PICKUP);
            clicker.click(menu, secondSlot, 0, ClickType.PICKUP);
            clicker.click(menu, firstSlot, 0, ClickType.PICKUP);
        }
    }

    private static void consolidateStacks(AbstractContainerMenu menu, List<Slot> slots, SlotClicker clicker) {
        block0: for (int i = 0; i < slots.size(); ++i) {
            Slot thisSlot = slots.get(i);
            if (!thisSlot.m_6657_()) continue;
            ItemStack thisStack = thisSlot.m_7993_();
            for (int j = i + 1; j < slots.size(); ++j) {
                Slot otherSlot = slots.get(j);
                ItemStack otherStack = otherSlot.m_7993_();
                if (otherStack.m_41619_() || !ItemStack.m_150942_((ItemStack)thisStack, (ItemStack)otherStack)) continue;
                clicker.click(menu, otherSlot, 0, ClickType.PICKUP);
                clicker.click(menu, thisSlot, 0, ClickType.PICKUP);
                if (!menu.m_142621_().m_41619_()) {
                    clicker.click(menu, otherSlot, 0, ClickType.PICKUP);
                }
                ItemStack newThisStack = thisSlot.m_7993_();
                int newThisStackFull = newThisStack.m_41741_();
                if (newThisStack.m_41613_() >= newThisStackFull) continue block0;
            }
        }
    }

    private static boolean isSortableSlot(Slot slot) {
        int containerSlot;
        if (slot.f_40218_ instanceof Inventory && ((containerSlot = slot.m_150661_()) < 9 || containerSlot >= 36)) {
            return false;
        }
        return slot.getClass() == Slot.class;
    }

    @FunctionalInterface
    public static interface SlotClicker {
        public void click(AbstractContainerMenu var1, Slot var2, int var3, ClickType var4);
    }
}

