/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.world;

import eu.ha3.presencefootsteps.PFConfig;
import eu.ha3.presencefootsteps.PresenceFootsteps;
import eu.ha3.presencefootsteps.sound.generator.Locomotion;
import eu.ha3.presencefootsteps.util.JsonObjectWriter;
import eu.ha3.presencefootsteps.world.Index;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.io.IOException;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;

public class LocomotionLookup
implements Index<Entity, Locomotion> {
    private final Map<ResourceLocation, Locomotion> values = new Object2ObjectLinkedOpenHashMap();
    private final PFConfig config;

    public LocomotionLookup(PFConfig config) {
        this.config = config;
    }

    @Override
    public Locomotion lookup(Entity key) {
        if (key instanceof Player) {
            Player player = (Player)key;
            return Locomotion.forPlayer(player, this.config.getLocomotion());
        }
        return Locomotion.forLiving(key, this.values.getOrDefault(EntityType.m_20613_((EntityType)key.m_6095_()), Locomotion.BIPED));
    }

    @Override
    public void add(String key, String value) {
        ResourceLocation id = new ResourceLocation(key);
        if (!BuiltInRegistries.f_256780_.m_7804_(id)) {
            PresenceFootsteps.logger.warn("Locomotion registered for unknown entity type " + id);
        }
        this.values.put(id, Locomotion.byName(value.toUpperCase()));
    }

    @Override
    public boolean contains(ResourceLocation key) {
        return this.values.containsKey(key);
    }

    @Override
    public void writeToReport(boolean full, JsonObjectWriter writer, Map<String, SoundType> groups) throws IOException {
        writer.each(BuiltInRegistries.f_256780_, type -> {
            ResourceLocation id = EntityType.m_20613_((EntityType)type);
            if ((full || !this.contains(id)) && type.m_20615_((Level)Minecraft.m_91087_().f_91073_) instanceof LivingEntity) {
                writer.field(id.toString(), this.values.getOrDefault(id, Locomotion.NONE).name());
            }
        });
    }
}

