/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.world;

import eu.ha3.presencefootsteps.api.DerivedBlock;
import eu.ha3.presencefootsteps.sound.SoundEngine;
import eu.ha3.presencefootsteps.world.Association;
import eu.ha3.presencefootsteps.world.PrimitiveLookup;
import eu.ha3.presencefootsteps.world.Solver;
import eu.ha3.presencefootsteps.world.SoundsKey;
import eu.ha3.presencefootsteps.world.Substrates;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public final class AssociationPool {
    private final LivingEntity entity;
    private final SoundEngine engine;
    private final Solver solver;
    private boolean wasGolem;
    private SoundsKey association;

    public AssociationPool(LivingEntity entity, SoundEngine engine) {
        this.entity = entity;
        this.engine = engine;
        this.solver = engine.getSolver();
    }

    public void reset() {
        this.wasGolem = false;
    }

    public boolean wasLastMatchGolem() {
        return this.wasGolem;
    }

    public Association findAssociation(double verticalOffsetAsMinus, boolean isRightFoot) {
        return this.solver.findAssociation(this, this.entity, verticalOffsetAsMinus, isRightFoot);
    }

    public Association findAssociation(BlockPos pos, String strategy) {
        return this.solver.findAssociation(this, this.entity, pos, strategy);
    }

    public SoundsKey get(BlockPos pos, BlockState state, String substrate) {
        for (Entity golem : this.entity.m_9236_().m_6249_((Entity)this.entity, new AABB(pos).m_82377_(0.5, 0.0, 0.5), e -> !e.m_5829_() || e.m_20191_().f_82292_ < this.entity.m_20186_() + (double)0.2f)) {
            this.association = this.engine.getIsolator().golems().getAssociation(golem.m_6095_(), substrate);
            if (!this.association.isEmitter()) continue;
            return this.association;
        }
        BlockState baseState = DerivedBlock.getBaseOf(state);
        if (state.m_60795_()) {
            return SoundsKey.UNASSIGNED;
        }
        if (this.getForState(state, substrate) || !baseState.m_60795_() && (this.getForState(baseState, substrate) || !Substrates.isDefault(substrate) && this.getForState(baseState, "") || this.getForPrimitive(baseState, substrate)) || this.getForPrimitive(state, substrate)) {
            return this.association;
        }
        return SoundsKey.UNASSIGNED;
    }

    private boolean getForState(BlockState state, String substrate) {
        this.association = this.engine.getIsolator().blocks().getAssociation(state, substrate);
        return this.association.isResult();
    }

    private boolean getForPrimitive(BlockState state, String substrate) {
        if (Substrates.isSupplimentary(substrate)) {
            return false;
        }
        SoundType sounds = state.m_60827_();
        this.association = this.engine.getIsolator().primitives().getAssociation(sounds.m_56776_(), PrimitiveLookup.getSubstrate(sounds));
        return this.association.isResult();
    }
}

