/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.kleeslabs.network;

import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.kleeslabs.registry.SlabRegistry;
import net.blay09.mods.kleeslabs.registry.SlabRegistryData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;

public class KleeSlabsRegistryMessage {
    private final boolean isFirst;
    private final List<SlabRegistryData> data;

    public KleeSlabsRegistryMessage(boolean isFirst, List<SlabRegistryData> data) {
        this.isFirst = isFirst;
        this.data = data;
    }

    public static void encode(KleeSlabsRegistryMessage message, FriendlyByteBuf buf) {
        buf.writeBoolean(message.isFirst);
        buf.writeShort(message.data.size());
        for (SlabRegistryData data : message.data) {
            buf.m_130070_(data.getConverterClass().getName());
            buf.m_130085_(Balm.getRegistries().getKey(data.getSingleSlab()));
            buf.m_130085_(Balm.getRegistries().getKey(data.getDoubleSlab()));
        }
    }

    public static KleeSlabsRegistryMessage decode(FriendlyByteBuf buf) {
        boolean isFirst = buf.readBoolean();
        int size = buf.readShort();
        ArrayList<SlabRegistryData> data = new ArrayList<SlabRegistryData>();
        for (int i = 0; i < size; ++i) {
            try {
                String converterClassName = buf.m_130136_(Short.MAX_VALUE);
                ResourceLocation singleBlockId = buf.m_130281_();
                ResourceLocation doubleBlockId = buf.m_130281_();
                Class<?> converterClass = Class.forName(converterClassName);
                Block singleSlab = Balm.getRegistries().getBlock(singleBlockId);
                Block doubleSlab = Balm.getRegistries().getBlock(doubleBlockId);
                if (singleSlab == null || doubleSlab == null) continue;
                data.add(new SlabRegistryData(converterClass, singleSlab, doubleSlab));
                continue;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return new KleeSlabsRegistryMessage(isFirst, data);
    }

    public static void handle(Player player, KleeSlabsRegistryMessage message) {
        if (message.isFirst) {
            SlabRegistry.clearRegistry();
        }
        for (SlabRegistryData data : message.data) {
            SlabRegistry.registerSlab(data);
        }
    }
}

