/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.serial.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import dev.xkmc.l2library.init.L2Library;
import dev.xkmc.l2library.serial.config.BaseConfig;
import dev.xkmc.l2library.serial.config.BaseConfigType;
import dev.xkmc.l2library.serial.config.MergedConfigType;
import dev.xkmc.l2library.serial.config.PacketHandler;
import dev.xkmc.l2library.serial.config.SyncPacket;
import dev.xkmc.l2serial.network.BasePacketHandler;
import dev.xkmc.l2serial.network.SimplePacketBase;
import dev.xkmc.l2serial.serialization.codec.JsonCodec;
import dev.xkmc.l2serial.util.Wrappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.fml.ModList;

public class PacketHandlerWithConfig
extends PacketHandler {
    static final Map<ResourceLocation, PacketHandlerWithConfig> INTERNAL = new ConcurrentHashMap<ResourceLocation, PacketHandlerWithConfig>();
    public ArrayList<ConfigInstance> configs = new ArrayList();
    public final String config_path;
    final ConfigReloadListener listener;
    final List<Runnable> listener_before = new ArrayList<Runnable>();
    final List<Runnable> listener_after = new ArrayList<Runnable>();
    final Map<String, BaseConfigType<?>> types = new HashMap();

    public static void onDatapackSync(OnDatapackSyncEvent event) {
        for (PacketHandlerWithConfig handler : INTERNAL.values()) {
            SyncPacket packet = new SyncPacket(handler, handler.configs);
            if (event.getPlayer() == null) {
                L2Library.PACKET_HANDLER.toAllClient((SimplePacketBase)packet);
                continue;
            }
            L2Library.PACKET_HANDLER.toClientPlayer((SimplePacketBase)packet, event.getPlayer());
        }
    }

    public static void addReloadListeners(AddReloadListenerEvent event) {
        for (PacketHandlerWithConfig handler : INTERNAL.values()) {
            if (handler.listener == null) continue;
            event.addListener((PreparableReloadListener)handler.listener);
        }
    }

    @SafeVarargs
    public PacketHandlerWithConfig(ResourceLocation id, int version, Function<BasePacketHandler, BasePacketHandler.LoadedPacket<?>> ... values) {
        super(id, version, values);
        INTERNAL.put(id, this);
        this.config_path = id.m_135827_() + "_config";
        this.listener = new ConfigReloadListener(this.config_path);
        this.listener_before.add(this.configs::clear);
    }

    public void addBeforeReloadListener(Runnable runnable) {
        this.listener_before.add(runnable);
    }

    public void addAfterReloadListener(Runnable runnable) {
        this.listener_after.add(runnable);
    }

    public <T extends BaseConfig> void addConfig(String id, Class<T> loader) {
        BaseConfigType<T> c = new BaseConfigType<T>(this, id, loader);
        this.types.put(id, c);
        this.addBeforeReloadListener(c::beforeReload);
        this.addAfterReloadListener(c::afterReload);
    }

    public <T extends BaseConfig> void addCachedConfig(String id, Class<T> loader) {
        MergedConfigType<T> c = new MergedConfigType<T>(this, id, loader);
        this.types.put(id, c);
        this.addBeforeReloadListener(c::beforeReload);
        this.addAfterReloadListener(c::afterReload);
    }

    <T extends BaseConfig> T getCachedConfig(String id) {
        MergedConfigType type = (MergedConfigType)Wrappers.cast(this.types.get(id));
        return type.load();
    }

    class ConfigReloadListener
    extends SimpleJsonResourceReloadListener {
        public ConfigReloadListener(String path) {
            super(new Gson(), path);
        }

        protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager manager, ProfilerFiller filler) {
            PacketHandlerWithConfig.this.listener_before.forEach(Runnable::run);
            map.forEach((k, v) -> {
                if (!k.m_135827_().startsWith("_") && !ModList.get().isLoaded(k.m_135827_())) {
                    return;
                }
                String id = k.m_135815_().split("/")[0];
                if (PacketHandlerWithConfig.this.types.containsKey(id)) {
                    String name = k.m_135815_().substring(id.length() + 1);
                    ResourceLocation nk = new ResourceLocation(k.m_135827_(), name);
                    this.addJson(PacketHandlerWithConfig.this.types.get(id), nk, (JsonElement)v);
                }
            });
            PacketHandlerWithConfig.this.listener_after.forEach(Runnable::run);
        }

        private <T extends BaseConfig> void addJson(BaseConfigType<T> type, ResourceLocation k, JsonElement v) {
            BaseConfig config = (BaseConfig)JsonCodec.from((JsonElement)v, type.cls, null);
            if (config != null) {
                this.addConfig(type, k, config);
            }
        }

        private <T extends BaseConfig> void addConfig(BaseConfigType<T> type, ResourceLocation k, T config) {
            config.id = k;
            type.configs.put(k, config);
            PacketHandlerWithConfig.this.configs.add(new ConfigInstance(type.id, k, config));
        }

        public void apply(ArrayList<ConfigInstance> list) {
            PacketHandlerWithConfig.this.listener_before.forEach(Runnable::run);
            for (ConfigInstance e : list) {
                this.addConfig(PacketHandlerWithConfig.this.types.get(e.name), e.id(), (BaseConfig)Wrappers.cast((Object)e.config));
            }
            PacketHandlerWithConfig.this.listener_after.forEach(Runnable::run);
        }
    }

    public record ConfigInstance(String name, ResourceLocation id, BaseConfig config) {
    }
}

