/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.raided.config;

import com.mrbysco.raided.Raided;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

public class RaidedConfig {
    protected static final Integer[] inquisitorSpawns = new Integer[]{0, 0, 0, 3, 0, 0, 0, 0};
    protected static final Integer[] incineratorSpawns = new Integer[]{0, 0, 0, 0, 1, 0, 0, 1};
    protected static final Integer[] savagerSpawns = new Integer[]{0, 0, 0, 2, 0, 0, 1, 0};
    protected static final Integer[] necromancerSpawns = new Integer[]{0, 0, 1, 0, 0, 1, 0, 0};
    protected static final Integer[] electromancerSpawns = new Integer[]{0, 1, 0, 2, 0, 1, 0, 0};
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        Raided.LOGGER.debug("Loaded Raided's config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        Raided.LOGGER.debug("Raided's config just got changed on the file system!");
        if (configEvent.getConfig().getModId().equals("raided") && (RaidedConfig.validateValue(RaidedConfig.COMMON.inquisitorSpawnsPerWave, inquisitorSpawns) || RaidedConfig.validateValue(RaidedConfig.COMMON.incineratorSpawnsPerWave, incineratorSpawns) || RaidedConfig.validateValue(RaidedConfig.COMMON.savagerSpawnsPerWave, savagerSpawns) || RaidedConfig.validateValue(RaidedConfig.COMMON.necromancerSpawnsPerWave, necromancerSpawns) || RaidedConfig.validateValue(RaidedConfig.COMMON.electromancerSpawnsPerWave, electromancerSpawns))) {
            configEvent.getConfig().save();
        }
    }

    public static boolean validateValue(ForgeConfigSpec.ConfigValue<List<? extends Integer>> configValue, Integer[] defaults) {
        if (((List)configValue.get()).size() != defaults.length) {
            Raided.LOGGER.error("'{}' is not the correct length, resetting to default. There must always be {} values in the list while it had {}", configValue.getPath().get(0), (Object)defaults.length, (Object)((List)configValue.get()).size());
            configValue.set(List.of(incineratorSpawns));
            return true;
        }
        return false;
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue spawnInquisitor;
        public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> inquisitorSpawnsPerWave;
        public final ForgeConfigSpec.BooleanValue spawnIncinerator;
        public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> incineratorSpawnsPerWave;
        public final ForgeConfigSpec.BooleanValue spawnSavager;
        public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> savagerSpawnsPerWave;
        public final ForgeConfigSpec.BooleanValue spawnNecromancer;
        public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> necromancerSpawnsPerWave;
        public final ForgeConfigSpec.BooleanValue spawnElectromancer;
        public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> electromancerSpawnsPerWave;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("General settings").push("General");
            this.spawnInquisitor = builder.comment("Enable Inquisitor spawning during raids based on the 'inquisitorSpawnsPerWave' setup").define("spawnInquisitor", true);
            this.inquisitorSpawnsPerWave = builder.comment("The spawns per wave for the Inquisitor before bonus spawns are applied (Must always have 8 values!)").defineList(List.of("inquisitorSpawnsPerWave"), () -> List.of(inquisitorSpawns), o -> {
                Integer amount;
                return o instanceof Integer && (amount = (Integer)o) >= 0;
            });
            this.spawnIncinerator = builder.comment("Enable Incinerator spawning during raids based on the 'incineratorSpawnsPerWave' setup").define("spawnIncinerator", true);
            this.incineratorSpawnsPerWave = builder.comment("The spawns per wave for the Incinerator before bonus spawns are applied (Must always have 8 values!)").defineList(List.of("incineratorSpawnsPerWave"), () -> List.of(incineratorSpawns), o -> {
                Integer amount;
                return o instanceof Integer && (amount = (Integer)o) >= 0;
            });
            this.spawnSavager = builder.comment("Enable Savager spawning during raids based on the 'savagerSpawnsPerWave' setup").define("spawnSavager", true);
            this.savagerSpawnsPerWave = builder.comment("The spawns per wave for the Savager before bonus spawns are applied (Must always have 8 values!)").defineList(List.of("savagerSpawnsPerWave"), () -> List.of(savagerSpawns), o -> {
                Integer amount;
                return o instanceof Integer && (amount = (Integer)o) >= 0;
            });
            this.spawnNecromancer = builder.comment("Enable Necromancer spawning during raids based on the 'necromancerSpawnsPerWave' setup").define("spawnNecromancer", true);
            this.necromancerSpawnsPerWave = builder.comment("The spawns per wave for the Necromancer before bonus spawns are applied (Must always have 8 values!)").defineList(List.of("necromancerSpawnsPerWave"), () -> List.of(necromancerSpawns), o -> {
                Integer amount;
                return o instanceof Integer && (amount = (Integer)o) >= 0;
            });
            this.spawnElectromancer = builder.comment("Enable Electromancer spawning during raids based on the 'electromancerSpawnsPerWave' setup").define("spawnElectromancer", true);
            this.electromancerSpawnsPerWave = builder.comment("The spawns per wave for the Electromancer before bonus spawns are applied (Must always have 8 values!)").defineList(List.of("electromancerSpawnsPerWave"), () -> List.of(electromancerSpawns), o -> {
                Integer amount;
                return o instanceof Integer && (amount = (Integer)o) >= 0;
            });
            builder.pop();
        }
    }
}

