/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.modifier.base;

import dev.xkmc.modulargolems.content.core.GolemStatType;
import dev.xkmc.modulargolems.content.core.StatFilterType;
import dev.xkmc.modulargolems.content.item.upgrade.IUpgradeItem;
import dev.xkmc.modulargolems.content.item.upgrade.UpgradeItem;
import dev.xkmc.modulargolems.content.modifier.base.GolemModifier;
import dev.xkmc.modulargolems.content.modifier.base.ModifierInstance;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.DoubleSupplier;
import java.util.function.Supplier;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

public class AttributeGolemModifier
extends GolemModifier {
    public final AttrEntry[] entries;
    @Nullable
    private Set<GolemStatType> checking = null;

    public AttributeGolemModifier(int max, AttrEntry ... entries) {
        super(StatFilterType.MASS, max);
        this.entries = entries;
    }

    @Override
    public List<MutableComponent> getDetail(int v) {
        ArrayList<MutableComponent> ans = new ArrayList<MutableComponent>();
        for (AttrEntry ent : this.entries) {
            ans.add(ent.type.get().getAdderTooltip(ent.getValue(v)));
        }
        return ans;
    }

    private Set<GolemStatType> checking() {
        if (this.checking == null) {
            this.checking = new LinkedHashSet<GolemStatType>();
            for (AttrEntry e : this.entries) {
                this.checking.addAll(e.type.get().hasConflict());
            }
        }
        return this.checking;
    }

    @Override
    public int addSlot(List<IUpgradeItem> upgrades, int lv) {
        if (this.checking().isEmpty()) {
            return 0;
        }
        for (IUpgradeItem item : upgrades) {
            if (!(item instanceof UpgradeItem)) continue;
            UpgradeItem up = (UpgradeItem)item;
            for (ModifierInstance mod : up.get()) {
                AttrEntry[] attrEntryArray = mod.mod();
                if (!(attrEntryArray instanceof AttributeGolemModifier)) continue;
                AttributeGolemModifier attr = (AttributeGolemModifier)attrEntryArray;
                for (AttrEntry ent : attr.entries) {
                    GolemStatType stat = ent.type().get();
                    if (!this.checking().contains((Object)stat)) continue;
                    return -1000000;
                }
            }
        }
        return 0;
    }

    public record AttrEntry(Supplier<GolemStatType> type, DoubleSupplier value) {
        public double getValue(int level) {
            return this.value.getAsDouble() * (double)level;
        }
    }
}

