/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.menu.ghost;

import dev.xkmc.l2library.base.menu.base.MenuLayoutConfig;
import dev.xkmc.l2library.base.menu.base.PredSlot;
import dev.xkmc.l2library.base.menu.base.SpriteManager;
import dev.xkmc.modulargolems.content.menu.ghost.IGhostContainer;
import java.util.function.Predicate;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public abstract class GhostItemMenu
extends AbstractContainerMenu {
    protected final Inventory inventory;
    public final MenuLayoutConfig sprite;
    protected final Container container;
    private int added = 0;

    protected GhostItemMenu(MenuType<?> type, int wid, Inventory plInv, SpriteManager manager, Container container) {
        super(type, wid);
        this.inventory = plInv;
        this.sprite = manager.get();
        this.container = container;
        int x = this.sprite.getPlInvX();
        int y = this.sprite.getPlInvY();
        this.bindPlayerInventory(plInv, x, y);
    }

    protected void bindPlayerInventory(Inventory plInv, int x, int y) {
        int k;
        for (k = 0; k < 3; ++k) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)plInv, j + k * 9 + 9, x + j * 18, y + k * 18));
            }
        }
        for (k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)plInv, k, x + k * 18, y + 58));
        }
    }

    protected void addSlot(String name, Predicate<ItemStack> pred) {
        this.sprite.getSlot(name, (x, y) -> new PredSlot(this.container, this.added++, x, y, pred), (n, i, j, s) -> this.m_38897_(s));
    }

    protected abstract IGhostContainer getContainer(int var1);

    protected ItemStack getSlotContent(int slot) {
        return this.getContainer(slot).m_8020_(slot);
    }

    public void setSlotContent(int slot, ItemStack stack) {
        if (stack.m_41619_()) {
            this.removeContent(slot);
        } else if (this.getContainer(slot).m_8020_(slot).m_41619_()) {
            this.tryAddContent(slot, stack);
        } else {
            stack = stack.m_41777_();
            stack.m_41764_(1);
            if (this.getContainer(slot).internalMatch(stack)) {
                return;
            }
            this.getContainer(slot).set(slot, stack);
        }
    }

    protected void tryAddContent(int slot, ItemStack stack) {
        IGhostContainer cont = this.getContainer(slot);
        if (cont.listSize() < cont.m_6643_()) {
            stack = stack.m_41777_();
            stack.m_41764_(1);
            if (cont.internalMatch(stack)) {
                return;
            }
            cont.set(-1, stack);
        }
    }

    protected void removeContent(int slot) {
        if (slot < 0 || this.getContainer(slot).m_8020_(slot).m_41619_()) {
            return;
        }
        this.getContainer(slot).set(slot, ItemStack.f_41583_);
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId < 36) {
            super.m_150399_(slotId, dragType, clickTypeIn, player);
        } else if (clickTypeIn != ClickType.THROW) {
            ItemStack held = this.m_142621_();
            int slot = slotId - 36;
            if (clickTypeIn == ClickType.CLONE) {
                if (player.m_7500_() && held.m_41619_()) {
                    ItemStack insert = this.getSlotContent(slot).m_41777_();
                    insert.m_41764_(insert.m_41741_());
                    this.m_142503_(insert);
                }
            } else {
                ItemStack insert;
                if (held.m_41619_()) {
                    insert = ItemStack.f_41583_;
                } else {
                    insert = held.m_41777_();
                    insert.m_41764_(1);
                }
                this.setSlotContent(slot, insert);
            }
        }
    }

    public boolean m_6875_(Player player) {
        return player.m_6084_();
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        if (index < 36) {
            ItemStack stackToInsert = this.m_38853_(index).m_7993_();
            this.tryAddContent(0, stackToInsert);
        } else {
            this.removeContent(index - 36);
        }
        return ItemStack.f_41583_;
    }
}

