/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.menu.attribute;

import dev.xkmc.l2tabs.init.data.L2TabsLangData;
import dev.xkmc.l2tabs.tabs.contents.AttributeEntry;
import dev.xkmc.l2tabs.tabs.contents.BaseTextScreen;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.menu.registry.EquipmentGroup;
import dev.xkmc.modulargolems.content.menu.registry.GolemTabRegistry;
import dev.xkmc.modulargolems.content.menu.tabs.GolemTabManager;
import dev.xkmc.modulargolems.content.menu.tabs.ITabScreen;
import dev.xkmc.modulargolems.init.registrate.GolemTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.Lazy;

public class AttributeScreen
extends BaseTextScreen
implements ITabScreen {
    public static final Lazy<List<AttributeEntry>> ATTRIBUTES = Lazy.of(() -> List.of(new AttributeEntry(Attributes.f_22276_, false, 0, 0.0), new AttributeEntry(Attributes.f_22281_, false, 1, 0.0), new AttributeEntry(Attributes.f_22284_, false, 2, 0.0), new AttributeEntry(Attributes.f_22285_, false, 3, 0.0), new AttributeEntry(Attributes.f_22278_, false, 4, 0.0), new AttributeEntry(Attributes.f_22279_, false, 5, 0.0), new AttributeEntry((Attribute)ForgeMod.ENTITY_REACH.get(), false, 6, 0.0), new AttributeEntry((Attribute)GolemTypes.GOLEM_REGEN.get(), false, 7, 0.0), new AttributeEntry((Attribute)GolemTypes.GOLEM_SWEEP.get(), false, 8, 0.0), new AttributeEntry((Attribute)GolemTypes.GOLEM_SIZE.get(), false, 9, 0.0), new AttributeEntry((Attribute)GolemTypes.GOLEM_JUMP.get(), false, 10, 0.0)));
    private final AbstractGolemEntity<?, ?> golem;

    public AttributeScreen(AbstractGolemEntity<?, ?> golem, Component title) {
        super(title, new ResourceLocation("l2tabs:textures/gui/empty.png"));
        this.golem = golem;
    }

    public void m_7856_() {
        super.m_7856_();
        new GolemTabManager<EquipmentGroup>(this, new EquipmentGroup(this.golem)).init(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        }, GolemTabRegistry.ATTRIBUTE);
    }

    public void m_88315_(GuiGraphics g, int mx, int my, float ptick) {
        super.m_88315_(g, mx, my, ptick);
        int x = this.leftPos + 8;
        int y = this.topPos + 6;
        Attribute focus = null;
        for (AttributeEntry entry : (List)ATTRIBUTES.get()) {
            if (this.golem.m_21051_(entry.attr()) == null) continue;
            double val = this.golem.m_21133_(entry.attr());
            MutableComponent comp = Component.m_237110_((String)("attribute.modifier.equals." + (entry.usePercent() ? 1 : 0)), (Object[])new Object[]{ItemStack.f_41584_.format(entry.usePercent() ? val * 100.0 : val), Component.m_237115_((String)entry.attr().m_22087_())});
            g.m_280614_(this.f_96547_, (Component)comp, x, y, 0, false);
            if (mx > x && mx < this.leftPos + this.imageWidth && my > y && my < y + 10) {
                focus = entry.attr();
            }
            y += 10;
        }
        if (focus != null) {
            g.m_280666_(this.f_96547_, this.getAttributeDetail(focus), mx, my);
        }
    }

    public List<Component> getAttributeDetail(Attribute attr) {
        AttributeInstance ins = this.golem.m_21051_(attr);
        if (ins == null) {
            return List.of();
        }
        Set adds = ins.m_22104_(AttributeModifier.Operation.ADDITION);
        Set m0s = ins.m_22104_(AttributeModifier.Operation.MULTIPLY_BASE);
        Set m1s = ins.m_22104_(AttributeModifier.Operation.MULTIPLY_TOTAL);
        double base = ins.m_22115_();
        double addv = 0.0;
        double m0v = 0.0;
        double m1v = 1.0;
        for (AttributeModifier e : adds) {
            addv += e.m_22218_();
        }
        for (AttributeModifier e : m0s) {
            m0v += e.m_22218_();
        }
        for (AttributeModifier e : m1s) {
            m1v *= 1.0 + e.m_22218_();
        }
        double total = (base + addv) * (1.0 + m0v) * m1v;
        ArrayList<Component> ans = new ArrayList<Component>();
        ans.add((Component)Component.m_237115_((String)attr.m_22087_()).m_130940_(ChatFormatting.GOLD));
        boolean shift = Screen.m_96638_();
        ans.add((Component)L2TabsLangData.BASE.get(new Object[]{AttributeScreen.number("%s", base)}).m_130940_(ChatFormatting.BLUE));
        ans.add((Component)L2TabsLangData.ADD.get(new Object[]{AttributeScreen.numberSigned("%s", addv)}).m_130940_(ChatFormatting.BLUE));
        if (shift) {
            for (AttributeModifier e : adds) {
                ans.add((Component)AttributeScreen.numberSigned("%s", e.m_22218_()).m_7220_((Component)AttributeScreen.name(e)));
            }
        }
        ans.add((Component)L2TabsLangData.MULT_BASE.get(new Object[]{AttributeScreen.numberSigned("%s%%", m0v * 100.0)}).m_130940_(ChatFormatting.BLUE));
        if (shift) {
            for (AttributeModifier e : m0s) {
                ans.add((Component)AttributeScreen.numberSigned("%s%%", e.m_22218_() * 100.0).m_7220_((Component)AttributeScreen.name(e)));
            }
        }
        ans.add((Component)L2TabsLangData.MULT_TOTAL.get(new Object[]{AttributeScreen.number("x%s", m1v)}).m_130940_(ChatFormatting.BLUE));
        if (shift) {
            for (AttributeModifier e : m1s) {
                ans.add((Component)AttributeScreen.number("x%s", 1.0 + e.m_22218_()).m_7220_((Component)AttributeScreen.name(e)));
            }
        }
        ans.add((Component)L2TabsLangData.FORMAT.get(new Object[]{AttributeScreen.number("%s", base), AttributeScreen.numberSigned("%s", addv), AttributeScreen.numberSigned("%s", m0v), AttributeScreen.number("%s", m1v), AttributeScreen.number("%s", total)}));
        if (!shift) {
            ans.add((Component)L2TabsLangData.DETAIL.get(new Object[0]).m_130940_(ChatFormatting.GRAY));
        }
        return ans;
    }

    private static MutableComponent number(String base, double value) {
        return Component.m_237113_((String)String.format(base, ItemStack.f_41584_.format(value))).m_130940_(ChatFormatting.GREEN);
    }

    private static MutableComponent numberSigned(String base, double value) {
        return value >= 0.0 ? Component.m_237113_((String)String.format("+" + base, ItemStack.f_41584_.format(value))).m_130940_(ChatFormatting.GREEN) : Component.m_237113_((String)String.format("-" + base, ItemStack.f_41584_.format(-value))).m_130940_(ChatFormatting.RED);
    }

    private static MutableComponent name(AttributeModifier e) {
        return Component.m_237113_((String)("  (" + e.m_22214_() + ")")).m_130940_(ChatFormatting.DARK_GRAY);
    }

    @Override
    public int getGuiLeft() {
        return this.leftPos;
    }

    @Override
    public int getGuiTop() {
        return this.topPos;
    }

    @Override
    public int screenWidth() {
        return this.f_96543_;
    }

    @Override
    public int screenHeight() {
        return this.f_96544_;
    }

    @Override
    public int getXSize() {
        return this.imageWidth;
    }

    @Override
    public int getYSize() {
        return this.imageHeight;
    }
}

