/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.item.golem;

import dev.xkmc.modulargolems.content.core.IGolemPart;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.item.card.ConfigCard;
import dev.xkmc.modulargolems.content.item.equipments.GolemEquipmentItem;
import dev.xkmc.modulargolems.content.item.golem.GolemHolder;
import dev.xkmc.modulargolems.content.item.upgrade.UpgradeItem;
import dev.xkmc.modulargolems.events.CraftEventListeners;
import dev.xkmc.modulargolems.init.data.MGTagGen;
import dev.xkmc.modulargolems.init.registrate.GolemTypes;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public record GolemEquipUtil(boolean isClient, @Nullable Level level) {
    public static boolean isGolemCurio(GolemHolder<?, ?> holder, ItemStack stack) {
        if (!ModList.get().isLoaded("curios")) {
            return false;
        }
        Set set = CuriosApi.getEntitySlots(holder.getEntityType().type(), (boolean)false).keySet();
        return ForgeRegistries.ITEMS.tags().getReverseTag((Object)stack.m_41720_()).map(e -> e.getTagKeys().anyMatch(t -> t.f_203868_().m_135827_().equals("curios") && set.contains(t.f_203868_().m_135815_()))).orElse(false);
    }

    public ItemStack applyItemOnHolder(GolemHolder<?, ?> holder, ItemStack first, ItemStack second) {
        EquipmentSlot slot;
        Object id;
        Item item = second.m_41720_();
        if (item instanceof ConfigCard) {
            ConfigCard card = (ConfigCard)item;
            id = ConfigCard.getUUID(second);
            if (id == null) {
                return ItemStack.f_41583_;
            }
            GolemHolder.setGolemConfig(first, (UUID)id, card.getColor());
            return first;
        }
        id = second.m_41720_();
        if (id instanceof UpgradeItem) {
            UpgradeItem upgrade = (UpgradeItem)id;
            return CraftEventListeners.appendUpgrade(first, holder, upgrade);
        }
        if (GolemEquipUtil.isGolemCurio(holder, second)) {
            return this.equipCurioOnHolder(holder, first, second);
        }
        if (holder.getEntityType() == GolemTypes.TYPE_GOLEM.get()) {
            slot = LivingEntity.m_147233_((ItemStack)second);
            if (!second.m_204117_(MGTagGen.LARGE_GOLEM_WEAPONS)) {
                Item item2 = second.m_41720_();
                if (!(item2 instanceof GolemEquipmentItem)) {
                    return ItemStack.f_41583_;
                }
                GolemEquipmentItem equipment = (GolemEquipmentItem)item2;
                if (!equipment.isFor((EntityType)GolemTypes.ENTITY_GOLEM.get())) {
                    return ItemStack.f_41583_;
                }
                slot = equipment.getSlot();
            }
            return this.equipOnHolder(holder, first, second, slot);
        }
        if (holder.getEntityType() == GolemTypes.TYPE_HUMANOID.get()) {
            slot = LivingEntity.m_147233_((ItemStack)second);
            return this.equipOnHolder(holder, first, second, slot);
        }
        return ItemStack.f_41583_;
    }

    public <T extends AbstractGolemEntity<T, P>, P extends IGolemPart<P>> ItemStack equipCurioOnHolder(GolemHolder<T, P> holder, ItemStack golem, ItemStack equip) {
        T entity;
        if (this.level == null) {
            return ItemStack.f_41583_;
        }
        if (!ModList.get().isLoaded("curios")) {
            return ItemStack.f_41583_;
        }
        CompoundTag tag = golem.m_41783_();
        if (tag != null && !tag.m_128441_("golem_entity")) {
            CompoundTag eq = tag.m_128469_("golem_equipments");
            Set golemSlots = CuriosApi.getEntitySlots(holder.getEntityType().type(), (boolean)this.isClient).keySet();
            LinkedHashSet itemSlots = new LinkedHashSet(CuriosApi.getItemStackSlots((ItemStack)equip, (boolean)this.isClient).keySet());
            itemSlots.retainAll(golemSlots);
            for (String slot : itemSlots) {
                if (eq.m_128441_(slot)) continue;
                eq.m_128365_(slot, (Tag)equip.m_41739_(new CompoundTag()));
                tag.m_128365_("golem_equipments", (Tag)eq);
                return golem;
            }
        }
        if ((entity = holder.createDummy(golem, this.level)) == null) {
            return ItemStack.f_41583_;
        }
        Optional opt = CuriosApi.getCuriosInventory(entity).resolve();
        if (opt.isEmpty()) {
            return ItemStack.f_41583_;
        }
        equip = equip.m_41777_();
        equip.m_41764_(1);
        for (String slot : CuriosApi.getItemStackSlots((ItemStack)equip, entity).keySet()) {
            Optional handler = ((ICuriosItemHandler)opt.get()).getStacksHandler(slot);
            if (handler.isEmpty()) continue;
            IDynamicStackHandler stacks = ((ICurioStacksHandler)handler.get()).getStacks();
            for (int i = 0; i < stacks.getSlots(); ++i) {
                if (!stacks.getStackInSlot(i).m_41619_()) continue;
                stacks.setStackInSlot(i, equip);
                return GolemHolder.setEntity(entity);
            }
        }
        return ItemStack.f_41583_;
    }

    public <T extends AbstractGolemEntity<T, P>, P extends IGolemPart<P>> ItemStack equipOnHolder(GolemHolder<T, P> holder, ItemStack golem, ItemStack equip, EquipmentSlot slot) {
        CompoundTag eq;
        CompoundTag tag = golem.m_41783_();
        if (tag != null && !tag.m_128441_("golem_entity") && !(eq = tag.m_128469_("golem_equipments")).m_128441_(slot.name())) {
            eq.m_128365_(slot.name(), (Tag)equip.m_41739_(new CompoundTag()));
            tag.m_128365_("golem_equipments", (Tag)eq);
            return golem;
        }
        if (this.level == null) {
            return ItemStack.f_41583_;
        }
        T entity = holder.createDummy(golem, this.level);
        if (entity == null) {
            return ItemStack.f_41583_;
        }
        if (!entity.m_6844_(slot).m_41619_()) {
            return ItemStack.f_41583_;
        }
        equip = equip.m_41777_();
        equip.m_41764_(1);
        entity.m_8061_(slot, equip);
        return GolemHolder.setEntity(entity);
    }

    public static boolean giveItemToGolem(AbstractGolemEntity<?, ?> golem, ItemStack item, String ent) {
        try {
            EquipmentSlot slot = Enum.valueOf(EquipmentSlot.class, ent);
            golem.m_8061_(slot, item);
            return true;
        }
        catch (Exception exception) {
            if (!ModList.get().isLoaded("curios")) {
                return false;
            }
            return GolemEquipUtil.giveCurioToGolem(golem, item, ent);
        }
    }

    public static boolean giveCurioToGolem(AbstractGolemEntity<?, ?> golem, ItemStack item, String ent) {
        Optional opt = CuriosApi.getCuriosInventory(golem).resolve();
        if (opt.isEmpty()) {
            return false;
        }
        Optional handler = ((ICuriosItemHandler)opt.get()).getStacksHandler(ent);
        if (handler.isEmpty()) {
            return false;
        }
        IDynamicStackHandler stacks = ((ICurioStacksHandler)handler.get()).getStacks();
        for (int i = 0; i < stacks.getSlots(); ++i) {
            if (!stacks.getStackInSlot(i).m_41619_()) continue;
            stacks.setStackInSlot(i, item);
            return true;
        }
        return false;
    }

    public static void addItemsToGolem(AbstractGolemEntity<?, ?> golem, CompoundTag root, boolean dropExtra) {
        if (root.m_128425_("golem_equipments", 10)) {
            CompoundTag equipMap = root.m_128469_("golem_equipments");
            for (String ent : equipMap.m_128431_()) {
                ItemStack item;
                if (!equipMap.m_128425_(ent, 10) || GolemEquipUtil.giveItemToGolem(golem, item = ItemStack.m_41712_((CompoundTag)equipMap.m_128469_(ent)), ent) || !dropExtra) continue;
                golem.m_19983_(item);
            }
        }
    }
}

