/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.metalgolem;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.xkmc.modulargolems.content.client.armor.GolemEquipmentModels;
import dev.xkmc.modulargolems.content.client.pose.MetalGolemPose;
import dev.xkmc.modulargolems.content.client.pose.WeaponPose;
import dev.xkmc.modulargolems.content.entity.common.IGolemModel;
import dev.xkmc.modulargolems.content.entity.common.IHeadedModel;
import dev.xkmc.modulargolems.content.entity.metalgolem.MetalGolemEntity;
import dev.xkmc.modulargolems.content.entity.metalgolem.MetalGolemPartType;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MetalGolemModel
extends HierarchicalModel<MetalGolemEntity>
implements IGolemModel<MetalGolemEntity, MetalGolemPartType, MetalGolemModel>,
IHeadedModel {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final ModelPart body;
    public final ModelPart rightArm;
    public final ModelPart leftArm;
    public final ModelPart leftForeArm;
    public final ModelPart rightForeArm;

    public MetalGolemModel(EntityModelSet set) {
        this(set.m_171103_(GolemEquipmentModels.METALGOLEM));
    }

    public MetalGolemModel(ModelPart part) {
        this.root = part;
        this.body = part.m_171324_("body");
        this.head = part.m_171324_("head");
        this.rightArm = part.m_171324_("right_arm");
        this.leftArm = part.m_171324_("left_arm");
        this.rightLeg = part.m_171324_("right_leg");
        this.leftLeg = part.m_171324_("left_leg");
        this.leftForeArm = this.leftArm.m_171324_("left_forearm");
        this.rightForeArm = this.rightArm.m_171324_("right_forearm");
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void copyFrom(MetalGolemModel other) {
        this.head.m_104315_(other.head);
        this.body.m_104315_(other.body);
        this.rightArm.m_104315_(other.rightArm);
        this.leftArm.m_104315_(other.leftArm);
        this.rightLeg.m_104315_(other.rightLeg);
        this.leftLeg.m_104315_(other.leftLeg);
        this.leftForeArm.m_104315_(other.leftForeArm);
        this.rightForeArm.m_104315_(other.rightForeArm);
    }

    public void setupAnim(MetalGolemEntity entity, float f1, float f2, float f3, float f4, float f5) {
        this.root.m_233569_();
        this.head.f_104204_ = f4 * ((float)Math.PI / 180);
        this.head.f_104203_ = f5 * ((float)Math.PI / 180);
        this.rightLeg.f_104203_ = -1.5f * Mth.m_14156_((float)f1, (float)13.0f) * f2;
        this.leftLeg.f_104203_ = 1.5f * Mth.m_14156_((float)f1, (float)13.0f) * f2;
        this.rightLeg.f_104204_ = 0.0f;
        this.leftLeg.f_104204_ = 0.0f;
        if (this.f_102609_) {
            this.rightLeg.f_104203_ = -1.4137167f;
            this.rightLeg.f_104204_ = 0.31415927f;
            this.rightLeg.f_104205_ = 0.07853982f;
            this.leftLeg.f_104203_ = -1.4137167f;
            this.leftLeg.f_104204_ = -0.31415927f;
            this.leftLeg.f_104205_ = -0.07853982f;
        }
    }

    public void prepareMobModel(MetalGolemEntity entity, float bob, float speed, float pTick) {
        int atkTick;
        MetalGolemPose pose = MetalGolemPose.DEFAULT;
        if (!entity.m_21205_().m_41619_()) {
            pose = WeaponPose.WEAPON;
        }
        if ((atkTick = entity.getAttackAnimationTick()) > 0) {
            pose.attackModel(entity, this, (float)atkTick - pTick);
        } else if (entity.m_5912_()) {
            pose.aggressive(entity, this, bob, speed, pTick);
        } else {
            pose.walking(entity, this, bob, speed, pTick);
        }
    }

    @Override
    public void renderToBufferInternal(MetalGolemPartType type, PoseStack stack, VertexConsumer consumer, int i, int j, float f1, float f2, float f3, float f4) {
        if (type == MetalGolemPartType.BODY) {
            this.body.m_104306_(stack, consumer, i, j, f1, f2, f3, f4);
            this.head.m_104306_(stack, consumer, i, j, f1, f2, f3, f4);
        } else if (type == MetalGolemPartType.LEFT) {
            this.leftArm.m_104306_(stack, consumer, i, j, f1, f2, f3, f4);
        } else if (type == MetalGolemPartType.RIGHT) {
            this.rightArm.m_104306_(stack, consumer, i, j, f1, f2, f3, f4);
        } else if (type == MetalGolemPartType.LEG) {
            this.leftLeg.m_104306_(stack, consumer, i, j, f1, f2, f3, f4);
            this.rightLeg.m_104306_(stack, consumer, i, j, f1, f2, f3, f4);
        }
    }

    @Override
    public ResourceLocation getTextureLocationInternal(ResourceLocation rl) {
        String id = rl.m_135827_();
        String mat = rl.m_135815_();
        return new ResourceLocation(id, "textures/entity/metal_golem/" + mat + ".png");
    }

    public void transformToHand(EquipmentSlot slot, PoseStack pose) {
        if (slot == EquipmentSlot.MAINHAND) {
            this.rightArm.m_104299_(pose);
            this.rightForeArm.m_104299_(pose);
        }
        if (slot == EquipmentSlot.OFFHAND) {
            this.leftArm.m_104299_(pose);
            this.leftForeArm.m_104299_(pose);
        }
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    @Override
    public void translateToHead(PoseStack pose) {
        pose.m_252880_(0.0f, -0.45f, -0.08f);
        pose.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        pose.m_85841_(0.625f, -0.625f, -0.625f);
    }
}

