/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.humanoid.weapon;

import dev.xkmc.mob_weapon_api.api.goals.IMeleeGoal;
import dev.xkmc.mob_weapon_api.api.goals.IRangedWeaponGoal;
import dev.xkmc.modulargolems.content.entity.humanoid.HumanoidGolemEntity;
import dev.xkmc.modulargolems.content.entity.humanoid.weapon.GolemShooterHelper;
import dev.xkmc.modulargolems.events.event.GolemThrowableEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;

public class GolemTridentAttackGoal
extends RangedAttackGoal
implements IRangedWeaponGoal<HumanoidGolemEntity> {
    private final HumanoidGolemEntity golem;
    private final IMeleeGoal melee;
    private final float radius;

    public GolemTridentAttackGoal(HumanoidGolemEntity pRangedAttackMob, double pSpeedModifier, int pAttackInterval, float pAttackRadius, IMeleeGoal melee) {
        super((RangedAttackMob)pRangedAttackMob, pSpeedModifier, pAttackInterval, pAttackRadius);
        this.golem = pRangedAttackMob;
        this.melee = melee;
        this.radius = pAttackRadius;
    }

    public double range(ItemStack stack) {
        return this.radius;
    }

    public boolean m_8036_() {
        LivingEntity target = this.golem.m_5448_();
        if (target == null || !super.m_8036_()) {
            return false;
        }
        if (this.melee.canReachTarget(target)) {
            return false;
        }
        InteractionHand hand = this.golem.getWeaponHand();
        return GolemShooterHelper.isValidThrowableWeapon((LivingEntity)this.golem, this.golem.m_21120_(hand), hand);
    }

    public void m_8056_() {
        super.m_8056_();
        this.golem.m_21561_(true);
        this.golem.setInRangeAttack(true);
        this.golem.m_6672_(this.golem.getWeaponHand());
    }

    public void m_8041_() {
        super.m_8041_();
        this.golem.m_5810_();
        this.golem.m_21561_(false);
        this.golem.setInRangeAttack(false);
    }

    public void performRangedAttack(LivingEntity target, float power, ItemStack stack, InteractionHand hand) {
        GolemThrowableEvent throwable = GolemShooterHelper.throwWeapon((LivingEntity)this.golem, stack, hand);
        if (throwable != null && throwable.isThrowable()) {
            Projectile projectile = throwable.createProjectile(this.golem.m_9236_());
            GolemShooterHelper.shootAimHelper(target, projectile);
            this.golem.m_5496_(SoundEvents.f_12520_, 1.0f, 1.0f / (this.golem.m_217043_().m_188501_() * 0.4f + 0.8f));
            projectile.getPersistentData().m_128405_("DespawnFactor", 20);
            this.golem.m_9236_().m_7967_((Entity)projectile);
            stack.m_41622_(1, (LivingEntity)this.golem, e -> e.m_21190_(InteractionHand.MAIN_HAND));
        }
    }
}

