/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.client.tracker;

import com.mojang.datafixers.util.Pair;
import dev.xkmc.l2serial.network.SimplePacketBase;
import dev.xkmc.l2tabs.tabs.contents.BaseTextScreen;
import dev.xkmc.l2tabs.tabs.core.TabManager;
import dev.xkmc.modulargolems.content.capability.GolemConfigStorage;
import dev.xkmc.modulargolems.content.capability.GolemTracker;
import dev.xkmc.modulargolems.content.capability.TrackerDeleteToServer;
import dev.xkmc.modulargolems.content.capability.TrackerHeartBeatToServer;
import dev.xkmc.modulargolems.content.client.tracker.TrackerInfo;
import dev.xkmc.modulargolems.content.menu.tabs.ITabScreen;
import dev.xkmc.modulargolems.init.GolemClient;
import dev.xkmc.modulargolems.init.ModularGolems;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public abstract class GolemInfoScreen
extends BaseTextScreen
implements ITabScreen {
    private int page = 0;
    private int size = 0;
    private Button left;
    private Button right;
    private boolean leftAdded;
    private boolean rightAdded;
    private UUID delId = null;

    private static int linePerPage() {
        return 14;
    }

    protected GolemInfoScreen(Component title) {
        super(title, new ResourceLocation("l2tabs:textures/gui/empty.png"));
    }

    public List<Pair<UUID, GolemTracker.TrackedData>> getData(Predicate<GolemTracker.TrackedData> status) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return List.of();
        }
        GolemTracker tracker = GolemConfigStorage.get(player.m_9236_()).getTracker(player.m_20148_());
        ArrayList<Pair<UUID, GolemTracker.TrackedData>> ans = new ArrayList<Pair<UUID, GolemTracker.TrackedData>>();
        for (Map.Entry<UUID, GolemTracker.TrackedData> e2 : tracker.data.entrySet()) {
            if (!status.test(e2.getValue())) continue;
            ans.add((Pair<UUID, GolemTracker.TrackedData>)Pair.of((Object)e2.getKey(), (Object)e2.getValue()));
        }
        ans.sort(Comparator.comparingLong(e -> -((GolemTracker.TrackedData)e.getSecond()).timestamp));
        return ans;
    }

    public abstract List<Pair<UUID, GolemTracker.TrackedData>> getData();

    public void m_7856_() {
        super.m_7856_();
        int x = (this.f_96543_ + this.imageWidth) / 2 - 16;
        int y = (this.f_96544_ - this.imageHeight) / 2 + 4;
        int w = 10;
        int h = 11;
        this.left = Button.m_253074_((Component)Component.m_237113_((String)"<"), e -> this.click(-1)).m_252794_(x - w - 1, y).m_253046_(w, h).m_253136_();
        this.right = Button.m_253074_((Component)Component.m_237113_((String)">"), e -> this.click(1)).m_252794_(x, y).m_253046_(w, h).m_253136_();
        new TabManager((Screen)this).init(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        }, GolemClient.TAB);
    }

    private void click(int offset) {
        this.page += offset;
        if (this.page < 0) {
            this.page = 0;
        }
        if (this.page >= (this.size - 1) / GolemInfoScreen.linePerPage() + 1) {
            --this.page;
        }
    }

    public void m_88315_(GuiGraphics g, int mx, int my, float ptick) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        long time = player.m_9236_().m_46467_();
        List<Pair<UUID, GolemTracker.TrackedData>> data = this.getData();
        this.size = data.size();
        this.updateButtons();
        super.m_88315_(g, mx, my, ptick);
        int start = this.page * GolemInfoScreen.linePerPage();
        int max = Math.min((this.page + 1) * GolemInfoScreen.linePerPage(), this.size);
        int x = this.leftPos + 8;
        int y = this.topPos + 6;
        g.m_280614_(this.f_96547_, this.f_96539_, x, y, 0, false);
        y += 15;
        GolemTracker.TrackedData focus = null;
        int delLine = -1;
        this.delId = null;
        for (int i = 0; i < max - start; ++i) {
            Pair<UUID, GolemTracker.TrackedData> ent = data.get(i + start);
            Component comp = TrackerInfo.getDesc((GolemTracker.TrackedData)ent.getSecond());
            g.m_280614_(this.f_96547_, comp, x, y, 0, false);
            int w = Math.min(this.f_96547_.m_92852_((FormattedText)comp), this.imageWidth - 30);
            if (my > y && my < y + 10) {
                if (mx > x && mx < x + w) {
                    focus = (GolemTracker.TrackedData)ent.getSecond();
                } else if (mx > x + this.imageWidth - 20 && mx < x + this.imageWidth - 8) {
                    delLine = start + i;
                    this.delId = (UUID)ent.getFirst();
                }
            }
            MutableComponent del = Component.m_237113_((String)"X").m_130940_(delLine == start + i ? ChatFormatting.RED : ChatFormatting.BLACK);
            g.m_280614_(this.f_96547_, (Component)del, x + this.imageWidth - 20, y, 0, false);
            y += 10;
        }
        if (focus != null) {
            g.m_280666_(this.f_96547_, TrackerInfo.getDetail(focus, (Player)player, time), mx, my);
        }
    }

    public void m_86600_() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (player.m_9236_().m_46467_() % 10L == 0L) {
            ModularGolems.HANDLER.toServer((SimplePacketBase)new TrackerHeartBeatToServer(player.m_20148_()));
        }
    }

    public boolean m_6375_(double x, double y, int btn) {
        if (super.m_6375_(x, y, btn)) {
            return true;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        if (this.delId != null && btn == 0) {
            ModularGolems.HANDLER.toServer((SimplePacketBase)new TrackerDeleteToServer(player.m_20148_(), this.delId));
            return true;
        }
        return false;
    }

    private void updateButtons() {
        int pageNum = (this.size - 1) / GolemInfoScreen.linePerPage() + 1;
        if (this.page > 0 && !this.leftAdded) {
            this.leftAdded = true;
            this.m_142416_((GuiEventListener)this.left);
        }
        if (this.page <= 0 && this.leftAdded) {
            this.leftAdded = false;
            this.m_169411_((GuiEventListener)this.left);
        }
        if (this.page < pageNum - 1 && !this.rightAdded) {
            this.rightAdded = true;
            this.m_142416_((GuiEventListener)this.right);
        }
        if (this.page >= pageNum - 1 && this.rightAdded) {
            this.rightAdded = false;
            this.m_169411_((GuiEventListener)this.right);
        }
    }

    @Override
    public int getGuiLeft() {
        return this.leftPos;
    }

    @Override
    public int getGuiTop() {
        return this.topPos;
    }

    @Override
    public int screenWidth() {
        return this.f_96543_;
    }

    @Override
    public int screenHeight() {
        return this.f_96544_;
    }

    @Override
    public int getXSize() {
        return this.imageWidth;
    }

    @Override
    public int getYSize() {
        return this.imageHeight;
    }
}

