/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.capability;

import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.modulargolems.content.config.GolemMaterial;
import dev.xkmc.modulargolems.content.core.GolemType;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class GolemTracker {
    @SerialClass.SerialField
    public final LinkedHashMap<UUID, TrackedData> data = new LinkedHashMap();

    public void track(AbstractGolemEntity<?, ?> e) {
        if (!e.isAddedToWorld()) {
            return;
        }
        if (e.m_21224_()) {
            return;
        }
        this.data.computeIfAbsent(e.m_20148_(), k -> new TrackedData()).update(e);
    }

    public void trackPos(UUID id, double x, double y, double z) {
        TrackedData rec = this.data.get(id);
        if (rec != null) {
            rec.updatePos(x, y, z);
        }
    }

    public boolean isUntracked(AbstractGolemEntity<?, ?> e) {
        TrackedData rec = this.data.get(e.m_20148_());
        if (rec == null) {
            return true;
        }
        return rec.status != Status.ALIVE;
    }

    public void untrack(AbstractGolemEntity<?, ?> e, Status type, @Nullable Entity cause) {
        this.data.computeIfAbsent(e.m_20148_(), k -> new TrackedData()).untrack(e, type, cause);
    }

    @SerialClass
    public static class TrackedData {
        @SerialClass.SerialField
        public Status status = Status.ALIVE;
        @SerialClass.SerialField
        public ResourceLocation lastDim;
        @SerialClass.SerialField
        public BlockPos lastPos;
        @SerialClass.SerialField
        public long timestamp;
        @SerialClass.SerialField
        public String name;
        @SerialClass.SerialField
        public String cause;
        @SerialClass.SerialField
        public float mhp;
        @SerialClass.SerialField
        public float hp;
        @SerialClass.SerialField
        public GolemType<?, ?> golemType;
        @SerialClass.SerialField
        public List<ResourceLocation> materials = new ArrayList<ResourceLocation>();

        public void update(AbstractGolemEntity<?, ?> e) {
            this.status = Status.ALIVE;
            this.lastDim = e.m_9236_().m_46472_().m_135782_();
            this.lastPos = e.m_20183_();
            this.timestamp = e.m_9236_().m_46467_();
            this.cause = null;
            this.mhp = e.m_21233_();
            this.hp = e.m_21223_();
            if (this.name == null || e.f_19797_ % 20 == 10) {
                this.name = Component.Serializer.m_130703_((Component)e.m_7755_());
                this.golemType = GolemType.getGolemType(e.m_6095_());
                this.materials.clear();
                for (GolemMaterial m : e.getMaterials()) {
                    this.materials.add(m.id());
                }
            }
        }

        public void updatePos(double x, double y, double z) {
            this.lastPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        }

        public void untrack(AbstractGolemEntity<?, ?> e, Status type, @Nullable Entity cause) {
            if (this.lastDim == null) {
                this.update(e);
            }
            if (!type.isDeath() || !this.status.isDeath()) {
                this.status = type;
            }
            this.hp = e.m_21223_();
            if (cause != null) {
                this.cause = Component.Serializer.m_130703_((Component)cause.m_7755_());
            }
        }
    }

    public static enum Status {
        ALIVE,
        RETRIEVED,
        OTHER_RETRIEVED,
        DEATH,
        DEATH_RECYCLE;


        public boolean isDeath() {
            return this == DEATH || this == DEATH_RECYCLE;
        }
    }
}

