/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.materials.l2hostility;

import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.modulargolems.compat.materials.l2hostility.AdaptiveModifier;
import dev.xkmc.modulargolems.compat.materials.l2hostility.DispellModifier;
import dev.xkmc.modulargolems.compat.materials.l2hostility.HostilityCoreModifier;
import dev.xkmc.modulargolems.compat.materials.l2hostility.HostilityPotionModifier;
import dev.xkmc.modulargolems.compat.materials.l2hostility.ReflectiveModifier;
import dev.xkmc.modulargolems.compat.materials.l2hostility.RegenModifier;
import dev.xkmc.modulargolems.content.core.GolemStatType;
import dev.xkmc.modulargolems.content.core.StatFilterType;
import dev.xkmc.modulargolems.content.item.upgrade.SimpleUpgradeItem;
import dev.xkmc.modulargolems.content.modifier.base.AttributeGolemModifier;
import dev.xkmc.modulargolems.content.modifier.base.PotionDefenseModifier;
import dev.xkmc.modulargolems.init.data.MGTagGen;
import dev.xkmc.modulargolems.init.registrate.GolemItems;
import dev.xkmc.modulargolems.init.registrate.GolemModifiers;
import dev.xkmc.modulargolems.init.registrate.GolemTypes;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;

public class LHCompatRegistry {
    public static final RegistryEntry<HostilityCoreModifier> LH_CORE;
    public static final RegistryEntry<HostilityPotionModifier> LH_POTION;
    public static final RegistryEntry<AttributeGolemModifier> LH_TANK;
    public static final RegistryEntry<AttributeGolemModifier> LH_SPEED;
    public static final RegistryEntry<PotionDefenseModifier> LH_PROTECTION;
    public static final RegistryEntry<RegenModifier> LH_REGEN;
    public static final RegistryEntry<ReflectiveModifier> LH_REFLECTIVE;
    public static final RegistryEntry<AdaptiveModifier> LH_ADAPTIVE;
    public static final RegistryEntry<DispellModifier> LH_DISPELL;
    public static final ItemEntry<SimpleUpgradeItem> CORE;
    public static final ItemEntry<SimpleUpgradeItem> POTION;
    public static final ItemEntry<SimpleUpgradeItem> TANK;
    public static final ItemEntry<SimpleUpgradeItem> SPEED;
    public static final ItemEntry<SimpleUpgradeItem> PROTECTION;
    public static final ItemEntry<SimpleUpgradeItem> REGEN;
    public static final ItemEntry<SimpleUpgradeItem> REFLECTIVE;
    public static final TagKey<Item> HOSTILITY_UPGRADE;

    public static void register() {
        MGTagGen.OPTIONAL_ITEM.add(pvd -> pvd.addTag(HOSTILITY_UPGRADE).m_176839_(POTION.getId()).m_176839_(TANK.getId()).m_176839_(SPEED.getId()).m_176839_(PROTECTION.getId()).m_176839_(REGEN.getId()).m_176839_(REFLECTIVE.getId()));
    }

    static {
        HOSTILITY_UPGRADE = ItemTags.create((ResourceLocation)new ResourceLocation("modulargolems", "hostility_upgrades"));
        LH_CORE = GolemModifiers.reg("hostility_core", () -> new HostilityCoreModifier(StatFilterType.HEALTH, 1), "Hostility Core", "All other hostility upgrades don't consume upgrade slots");
        LH_POTION = GolemModifiers.reg("hostility_potion", () -> new HostilityPotionModifier(StatFilterType.HEALTH, 1), "Hostility Upgrade: Potions", "First level of each kind of potion upgrades don't consume upgrade slot");
        LH_TANK = GolemModifiers.reg("hostility_tank", () -> {
            AttributeGolemModifier.AttrEntry[] attrEntryArray = new AttributeGolemModifier.AttrEntry[3];
            attrEntryArray[0] = new AttributeGolemModifier.AttrEntry((Supplier<GolemStatType>)GolemTypes.STAT_HEALTH_P, () -> ((ForgeConfigSpec.DoubleValue)LHConfig.COMMON.tankHealth).get());
            attrEntryArray[1] = new AttributeGolemModifier.AttrEntry((Supplier<GolemStatType>)GolemTypes.STAT_ARMOR, () -> ((ForgeConfigSpec.DoubleValue)LHConfig.COMMON.tankArmor).get());
            attrEntryArray[2] = new AttributeGolemModifier.AttrEntry((Supplier<GolemStatType>)GolemTypes.STAT_TOUGH, () -> ((ForgeConfigSpec.DoubleValue)LHConfig.COMMON.tankTough).get());
            return new AttributeGolemModifier(5, attrEntryArray);
        }, "Hostility Modifier: Tanky", null);
        LH_SPEED = GolemModifiers.reg("hostility_speed", () -> {
            AttributeGolemModifier.AttrEntry[] attrEntryArray = new AttributeGolemModifier.AttrEntry[1];
            attrEntryArray[0] = new AttributeGolemModifier.AttrEntry((Supplier<GolemStatType>)GolemTypes.STAT_SPEED, () -> ((ForgeConfigSpec.DoubleValue)LHConfig.COMMON.speedy).get());
            return new AttributeGolemModifier(5, attrEntryArray);
        }, "Hostility Modifier: Speedy", null);
        LH_PROTECTION = GolemModifiers.reg("hostility_protection", () -> new PotionDefenseModifier(4, () -> MobEffects.f_19606_), "Hostility Modifier: Protection", null);
        LH_REGEN = GolemModifiers.reg("hostility_regen", () -> new RegenModifier(StatFilterType.HEALTH, 5), "Hostility Modifier: Regeneration", null);
        LH_REFLECTIVE = GolemModifiers.reg("hostility_reflect", () -> new ReflectiveModifier(StatFilterType.HEALTH, 5), "Hostility Modifier: Reflective", null);
        LH_ADAPTIVE = GolemModifiers.reg("hostility_adaptive", AdaptiveModifier::new, "Hostility Modifier: Adaptive", null);
        LH_DISPELL = GolemModifiers.reg("hostility_dispell", DispellModifier::new, "Hostility Modifier: Dispell", null);
        CORE = GolemItems.regModUpgrade("hostility_core", () -> LH_CORE, "l2hostility").lang("Hostility Core").register();
        POTION = GolemItems.regModUpgrade("hostility_potion", () -> LH_POTION, "l2hostility").lang("Hostility Upgrade: Potion").register();
        TANK = GolemItems.regModUpgrade("hostility_tank", () -> LH_TANK, "l2hostility").lang("Hostility Upgrade: Tanky").register();
        SPEED = GolemItems.regModUpgrade("hostility_speed", () -> LH_SPEED, "l2hostility").lang("Hostility Upgrade: Speedy").register();
        PROTECTION = GolemItems.regModUpgrade("hostility_protection", () -> LH_PROTECTION, "l2hostility").lang("Hostility Upgrade: Protection").register();
        REGEN = GolemItems.regModUpgrade("hostility_regen", () -> LH_REGEN, "l2hostility").lang("Hostility Upgrade: Regeneration").register();
        REFLECTIVE = GolemItems.regModUpgrade("hostility_reflect", () -> LH_REFLECTIVE, "l2hostility").lang("Hostility Upgrade: Reflective").register();
    }
}

