/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.materials.alexscaves.modifier;

import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import dev.xkmc.modulargolems.content.core.StatFilterType;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.modifier.base.GolemModifier;
import dev.xkmc.modulargolems.init.data.MGConfig;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public class PolarizeModifier
extends GolemModifier {
    public static double range(int lv) {
        return (double)(4 + lv) * 0.2 * (Double)MGConfig.COMMON.polarizeRange.get();
    }

    public static double damage(int lv) {
        return (double)((float)(1 + lv) / 2.0f) * (Double)MGConfig.COMMON.polarizeDamage.get();
    }

    public static double force() {
        return (Double)MGConfig.COMMON.polarizeForce.get();
    }

    public PolarizeModifier() {
        super(StatFilterType.MASS, 4);
    }

    @Override
    public void onClientTick(AbstractGolemEntity<?, ?> golem, int level) {
        if (golem.f_19797_ % 5 != 0) {
            return;
        }
        if (!golem.m_5912_()) {
            return;
        }
        double r = PolarizeModifier.range(level);
        boolean ranged = golem.isInRangedMode();
        Vec3 src = golem.m_20182_().m_82520_(0.0, 0.2, 0.0);
        float particleMax = 5 + golem.m_217043_().m_188503_(5);
        int particles = 0;
        while ((float)particles < particleMax) {
            Vec3 dst = new Vec3(((double)golem.m_217043_().m_188501_() - 0.5) * 0.3, ((double)golem.m_217043_().m_188501_() - 0.5) * 0.3, r * 0.5 + r * 0.5 * (double)golem.m_217043_().m_188501_()).m_82524_((float)((double)((float)particles / particleMax) * Math.PI * 2.0)).m_82549_(src);
            if (!ranged) {
                golem.m_9236_().m_7106_((ParticleOptions)ACParticleRegistry.SCARLET_SHIELD_LIGHTNING.get(), dst.f_82479_, dst.f_82480_, dst.f_82481_, src.f_82479_, src.f_82480_, src.f_82481_);
            } else {
                golem.m_9236_().m_7106_((ParticleOptions)ACParticleRegistry.AZURE_SHIELD_LIGHTNING.get(), src.f_82479_, src.f_82480_, src.f_82481_, dst.f_82479_, dst.f_82480_, dst.f_82481_);
            }
            ++particles;
        }
    }

    @Override
    public void onAiStep(AbstractGolemEntity<?, ?> golem, int level) {
        LivingEntity target = golem.m_5448_();
        if (target == null) {
            return;
        }
        boolean dmg = golem.f_19797_ % 10 == 0;
        float damage = (float)PolarizeModifier.damage(level);
        double r = PolarizeModifier.range(level);
        boolean ranged = golem.isInRangedMode();
        AABB aabb = golem.m_20191_().m_82400_(r);
        List list = golem.m_9236_().m_142425_(EntityTypeTest.m_156916_(LivingEntity.class), aabb, e -> e != golem && golem.m_6779_((LivingEntity)e));
        Vec3 pos = golem.m_20182_().m_82520_(0.0, (double)(golem.m_20206_() / 2.0f), 0.0);
        Vec3 forward = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0).m_82546_(pos);
        forward = forward.m_82553_() < 1.0 ? golem.m_20156_().m_82541_() : forward.m_82541_();
        double val = golem.m_21133_((Attribute)ForgeMod.ENTITY_REACH.get()) * 0.8;
        if (val < 1.0) {
            val = 1.0;
        }
        forward = forward.m_82490_(val);
        for (LivingEntity e2 : list) {
            Vec3 dir;
            Vec3 tar = e2.m_20182_().m_82520_(0.0, (double)(e2.m_20206_() / 2.0f), 0.0);
            if (tar.m_82554_(pos) > r) continue;
            if (ranged) {
                dir = tar.m_82546_(pos);
                if (dir.m_82553_() > 1.0) {
                    dir = dir.m_82541_();
                }
            } else {
                dir = pos.m_82549_(forward).m_82546_(tar);
            }
            if (dir.m_82553_() > 1.0) {
                dir = dir.m_82541_();
            }
            dir = dir.m_82490_(PolarizeModifier.force());
            e2.m_5997_(dir.f_82479_, dir.f_82480_, dir.f_82481_);
            if (!dmg) continue;
            e2.m_6469_(golem.m_269291_().m_269333_(golem), damage);
        }
    }

    @Override
    public List<MutableComponent> getDetail(int v) {
        int num = (int)Math.round(PolarizeModifier.damage(v));
        MutableComponent val = Component.m_237113_((String)("" + num)).m_130940_(ChatFormatting.AQUA);
        return List.of(Component.m_237110_((String)(this.getDescriptionId() + ".desc"), (Object[])new Object[]{val}).m_130940_(ChatFormatting.GREEN));
    }
}

