/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.terrain;

import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorEvents;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.config.SystemMode;
import folk.sisby.surveyor.terrain.ChunkSummary;
import folk.sisby.surveyor.terrain.RegionSummary;
import folk.sisby.surveyor.util.ChunkUtil;
import folk.sisby.surveyor.util.RegistryPalette;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;

public class WorldTerrainSummary {
    protected final ResourceKey<Level> worldKey;
    protected final RegistryAccess registryManager;
    protected final Map<ChunkPos, RegionSummary> regions = new ConcurrentHashMap<ChunkPos, RegionSummary>();

    public WorldTerrainSummary(ResourceKey<Level> worldKey, RegistryAccess registryManager, Map<ChunkPos, RegionSummary> regions) {
        this.worldKey = worldKey;
        this.registryManager = registryManager;
        this.regions.putAll(regions);
    }

    protected static ChunkPos regionPosOf(ChunkPos pos) {
        return new ChunkPos(pos.f_45578_ >> 5, pos.f_45579_ >> 5);
    }

    public static Set<ChunkPos> toKeys(Map<ChunkPos, BitSet> bitSets) {
        return WorldTerrainSummary.toKeys(bitSets, Comparator.comparingInt(pos -> pos.f_45578_ + pos.f_45579_));
    }

    public static Set<ChunkPos> toKeys(Map<ChunkPos, BitSet> bitSets, ChunkPos originChunk) {
        ChunkPos oPos = new ChunkPos(RegionSummary.chunkToRegion(originChunk.f_45578_), RegionSummary.chunkToRegion(originChunk.f_45579_));
        return WorldTerrainSummary.toKeys(bitSets, Comparator.comparingDouble(pos -> (oPos.f_45578_ - pos.f_45578_) * (oPos.f_45578_ - pos.f_45578_) + (oPos.f_45579_ - pos.f_45579_) * (oPos.f_45579_ - pos.f_45579_)));
    }

    public static Set<ChunkPos> toKeys(Map<ChunkPos, BitSet> bitSets, Comparator<ChunkPos> regionComparator) {
        LinkedHashSet<ChunkPos> set = new LinkedHashSet<ChunkPos>();
        bitSets.entrySet().stream().sorted(Map.Entry.comparingByKey(regionComparator)).forEach(e -> ((BitSet)e.getValue()).stream().forEach(i -> set.add(RegionSummary.chunkForBit((ChunkPos)e.getKey(), i))));
        return set;
    }

    public static WorldTerrainSummary load(Level world, File folder) {
        HashMap<ChunkPos, RegionSummary> regions = new HashMap<ChunkPos, RegionSummary>();
        ChunkUtil.getRegionNbt(folder, "c").forEach((pos, nbt) -> regions.put((ChunkPos)pos, RegionSummary.readNbt(nbt, world.m_9598_(), pos)));
        return new WorldTerrainSummary((ResourceKey<Level>)world.m_46472_(), world.m_9598_(), regions);
    }

    public static void onChunkLoad(Level world, LevelChunk chunk) {
        WorldSummary summary = WorldSummary.of(world);
        if (!(summary.terrain() == null || summary.terrain().contains(chunk.m_7697_()) && ChunkUtil.airCount((ChunkAccess)chunk).equals(summary.terrain().get(chunk.m_7697_()).getAirCount()))) {
            summary.terrain().put(world, chunk);
        }
    }

    public static void onChunkUnload(Level world, LevelChunk chunk) {
        WorldSummary summary = WorldSummary.of(world);
        if (summary.terrain() != null && chunk.m_6344_()) {
            summary.terrain().put(world, chunk);
        }
    }

    public boolean contains(ChunkPos pos) {
        ChunkPos regionPos = WorldTerrainSummary.regionPosOf(pos);
        return this.regions.containsKey(regionPos) && this.regions.get(regionPos).contains(pos);
    }

    public ChunkSummary get(ChunkPos pos) {
        ChunkPos regionPos = WorldTerrainSummary.regionPosOf(pos);
        return this.regions.containsKey(regionPos) ? this.regions.get(regionPos).get(pos) : null;
    }

    public RegionSummary getRegion(ChunkPos regionPos) {
        return this.regions.computeIfAbsent(regionPos, k -> new RegionSummary(this.registryManager));
    }

    public RegistryPalette.ValueView getBiomePalette(ChunkPos pos) {
        ChunkPos regionPos = WorldTerrainSummary.regionPosOf(pos);
        return this.regions.get(regionPos).getBiomePalette();
    }

    public RegistryPalette.ValueView getBlockPalette(ChunkPos pos) {
        ChunkPos regionPos = WorldTerrainSummary.regionPosOf(pos);
        return this.regions.get(regionPos).getBlockPalette();
    }

    public Map<ChunkPos, BitSet> bitSet(SurveyorExploration exploration) {
        HashMap<ChunkPos, BitSet> map = new HashMap<ChunkPos, BitSet>();
        this.regions.forEach((p, r) -> map.put((ChunkPos)p, r.bitSet()));
        return exploration == null ? map : exploration.limitTerrainBitset(this.worldKey, map);
    }

    public void put(Level world, LevelChunk chunk) {
        if (Surveyor.CONFIG.terrain == SystemMode.FROZEN) {
            return;
        }
        this.regions.computeIfAbsent(WorldTerrainSummary.regionPosOf(chunk.m_7697_()), k -> new RegionSummary(this.registryManager)).putChunk(world, chunk);
        SurveyorEvents.Invoke.terrainUpdated(world, chunk.m_7697_());
    }

    public int save(Level world, File folder) {
        ArrayList savedRegions = new ArrayList();
        this.regions.forEach((pos, summary) -> {
            if (!summary.isDirty()) {
                return;
            }
            savedRegions.add(pos);
            CompoundTag regionCompound = summary.writeNbt(world.m_9598_(), new CompoundTag(), (ChunkPos)pos);
            File regionFile = new File(folder, "c.%d.%d.dat".formatted(pos.f_45578_, pos.f_45579_));
            try {
                NbtIo.m_128944_((CompoundTag)regionCompound, (File)regionFile);
                summary.dirty = false;
            }
            catch (IOException e) {
                Surveyor.LOGGER.error("[Surveyor] Error writing region summary file {}.", (Object)regionFile.getName(), (Object)e);
            }
        });
        return savedRegions.size();
    }

    public boolean isDirty() {
        return this.regions.values().stream().anyMatch(RegionSummary::isDirty);
    }
}

