/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.structure;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorEvents;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.config.SystemMode;
import folk.sisby.surveyor.packet.S2CStructuresAddedPacket;
import folk.sisby.surveyor.structure.JigsawPieceSummary;
import folk.sisby.surveyor.structure.RegionStructureSummary;
import folk.sisby.surveyor.structure.StructurePieceSummary;
import folk.sisby.surveyor.structure.StructureStartSummary;
import folk.sisby.surveyor.util.ChunkUtil;
import folk.sisby.surveyor.util.MapUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public class WorldStructureSummary {
    public static final String KEY_STRUCTURES = "structures";
    public static final String KEY_TYPE = "type";
    public static final String KEY_TAGS = "tags";
    protected final ResourceKey<Level> worldKey;
    protected final Map<ChunkPos, RegionStructureSummary> regions = new ConcurrentHashMap<ChunkPos, RegionStructureSummary>();
    protected final Map<ResourceKey<Structure>, ResourceKey<StructureType<?>>> structureTypes = new ConcurrentHashMap();
    protected final Multimap<ResourceKey<Structure>, TagKey<Structure>> structureTags = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    protected boolean dirty = false;

    public WorldStructureSummary(ResourceKey<Level> worldKey, Map<ChunkPos, RegionStructureSummary> regions, Map<ResourceKey<Structure>, ResourceKey<StructureType<?>>> structureTypes, Multimap<ResourceKey<Structure>, TagKey<Structure>> structureTags) {
        this.worldKey = worldKey;
        this.regions.putAll(regions);
        this.structureTypes.putAll(structureTypes);
        this.structureTags.putAll(structureTags);
    }

    protected static ChunkPos regionPosOf(ChunkPos pos) {
        return new ChunkPos(pos.f_45578_ >> 5, pos.f_45579_ >> 5);
    }

    public static StructurePieceSummary readStructurePieceNbt(CompoundTag nbt) {
        if (nbt.m_128461_("id").equals(BuiltInRegistries.f_257014_.m_7981_((Object)StructurePieceType.f_210125_).toString())) {
            return new JigsawPieceSummary(nbt);
        }
        return new StructurePieceSummary(nbt);
    }

    protected static WorldStructureSummary readNbt(ResourceKey<Level> worldKey, CompoundTag nbt, Map<ChunkPos, RegionStructureSummary> regions) {
        ConcurrentHashMap structureTypes = new ConcurrentHashMap();
        HashMultimap structureTags = HashMultimap.create();
        CompoundTag structuresCompound = nbt.m_128469_(KEY_STRUCTURES);
        for (String structureId : structuresCompound.m_128431_()) {
            ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation(structureId));
            CompoundTag structureCompound = structuresCompound.m_128469_(structureId);
            ResourceKey type = ResourceKey.m_135785_((ResourceKey)Registries.f_256938_, (ResourceLocation)new ResourceLocation(structureCompound.m_128461_(KEY_TYPE)));
            structureTypes.put((ResourceKey<Structure>)key, type);
            List<TagKey> tags = structureCompound.m_128437_(KEY_TAGS, 8).stream().map(e -> TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation(e.m_7916_()))).toList();
            structureTags.putAll((Object)key, tags);
        }
        for (RegionStructureSummary region : regions.values()) {
            region.structures.keySet().removeIf(k -> !structureTypes.containsKey(k));
        }
        return new WorldStructureSummary(worldKey, regions, structureTypes, (Multimap<ResourceKey<Structure>, TagKey<Structure>>)structureTags);
    }

    public static WorldStructureSummary load(Level world, File folder) {
        File structuresFile = new File(folder, "structures.dat");
        CompoundTag worldNbt = new CompoundTag();
        if (structuresFile.exists()) {
            try {
                worldNbt = NbtIo.m_128937_((File)structuresFile);
            }
            catch (IOException e) {
                Surveyor.LOGGER.error("[Surveyor] Error loading structure summary file for {}.", (Object)world.m_46472_().m_135782_(), (Object)e);
            }
        }
        HashMap<ChunkPos, RegionStructureSummary> regions = new HashMap<ChunkPos, RegionStructureSummary>();
        ChunkUtil.getRegionNbt(folder, "s").forEach((pos, nbt) -> regions.put((ChunkPos)pos, RegionStructureSummary.readNbt(nbt)));
        if (regions.isEmpty()) {
            RegionStructureSummary worldSummary = RegionStructureSummary.readNbt(worldNbt);
            worldSummary.structures.forEach((key, map) -> map.forEach((pos, start) -> {
                ChunkPos rPos = WorldStructureSummary.regionPosOf(pos);
                regions.computeIfAbsent(rPos, k -> new RegionStructureSummary()).put((ResourceKey<Structure>)key, (ChunkPos)pos, (StructureStartSummary)start);
            }));
        }
        return WorldStructureSummary.readNbt((ResourceKey<Level>)world.m_46472_(), worldNbt, regions);
    }

    public static void onChunkLoad(ServerLevel world, LevelChunk chunk) {
        WorldStructureSummary structures = WorldSummary.of((Level)world).structures();
        chunk.m_6633_().forEach((structure, start) -> {
            if (structures != null && !structures.contains((Level)world, (StructureStart)start)) {
                structures.put(world, (StructureStart)start);
            }
        });
    }

    public static void onStructurePlace(ServerLevel world, StructureStart start) {
        WorldStructureSummary structures = WorldSummary.of((Level)world).structures();
        if (structures != null && !structures.contains((Level)world, start)) {
            structures.put(world, start);
        }
    }

    public ResourceKey<StructureType<?>> getType(ResourceKey<Structure> key) {
        return this.structureTypes.get(key);
    }

    public Collection<TagKey<Structure>> getTags(ResourceKey<Structure> key) {
        return this.structureTags.get(key);
    }

    public boolean contains(Level world, StructureStart start) {
        ChunkPos rPos = WorldStructureSummary.regionPosOf(start.m_163625_());
        return this.regions.containsKey(rPos) && this.regions.get(rPos).contains(world, start);
    }

    public boolean contains(ResourceKey<Structure> key, ChunkPos pos) {
        ChunkPos rPos = WorldStructureSummary.regionPosOf(pos);
        return this.regions.containsKey(rPos) && this.regions.get(rPos).contains(key, pos);
    }

    public StructureStartSummary get(ResourceKey<Structure> key, ChunkPos pos) {
        ChunkPos rPos = WorldStructureSummary.regionPosOf(pos);
        return this.regions.containsKey(rPos) ? this.regions.get(rPos).get(key, pos) : null;
    }

    public Map<ResourceKey<Structure>, Map<ChunkPos, StructureStartSummary>> asMap(SurveyorExploration exploration) {
        Multimap<ResourceKey<Structure>, ChunkPos> keySet = this.keySet(exploration);
        HashMap<ResourceKey<Structure>, Map<ChunkPos, StructureStartSummary>> map = new HashMap<ResourceKey<Structure>, Map<ChunkPos, StructureStartSummary>>();
        keySet.forEach((key, pos) -> map.computeIfAbsent((ResourceKey<Structure>)key, k -> new HashMap()).put(pos, this.get((ResourceKey<Structure>)key, (ChunkPos)pos)));
        return map;
    }

    public Multimap<ResourceKey<Structure>, ChunkPos> keySet(SurveyorExploration exploration) {
        HashMultimap map = HashMultimap.create();
        this.regions.values().forEach(arg_0 -> WorldStructureSummary.lambda$keySet$9((Multimap)map, arg_0));
        if (exploration != null) {
            exploration.limitStructureKeySet(this.worldKey, (Multimap<ResourceKey<Structure>, ChunkPos>)map);
        }
        return map;
    }

    public void put(ServerLevel world, StructureStart start) {
        if (Surveyor.CONFIG.structures == SystemMode.FROZEN) {
            return;
        }
        ChunkPos rPos = WorldStructureSummary.regionPosOf(start.m_163625_());
        ResourceKey key = (ResourceKey)world.m_9598_().m_175515_(Registries.f_256944_).m_7854_((Object)start.m_226861_()).orElseThrow();
        Optional type = world.m_9598_().m_175515_(Registries.f_256938_).m_7854_((Object)start.m_226861_().m_213658_());
        if (!start.m_73603_()) {
            Surveyor.LOGGER.error("Cowardly refusing to save structure {} as it has no pieces! Report this to the structure mod author!", (Object)key.m_135782_());
            return;
        }
        if (type.isEmpty()) {
            Surveyor.LOGGER.error("Cowardly refusing to save structure {} as it has no structure type! Report this to the structure mod author!", (Object)key.m_135782_());
            return;
        }
        this.regions.computeIfAbsent(rPos, k -> new RegionStructureSummary()).put(world, start);
        List tags = world.m_9598_().m_175515_(Registries.f_256944_).m_263177_((Object)start.m_226861_()).m_203616_().toList();
        this.structureTypes.put((ResourceKey<Structure>)key, (ResourceKey)type.orElseThrow());
        this.structureTags.putAll((Object)key, tags);
        this.dirty();
        SurveyorEvents.Invoke.structuresAdded((Level)world, (ResourceKey<Structure>)key, start.m_163625_());
    }

    public void put(Level world, ResourceKey<Structure> key, ChunkPos pos, StructureStartSummary summary, ResourceKey<StructureType<?>> type, Collection<TagKey<Structure>> tagKeys) {
        if (Surveyor.CONFIG.structures == SystemMode.FROZEN) {
            return;
        }
        ChunkPos rPos = WorldStructureSummary.regionPosOf(pos);
        this.regions.computeIfAbsent(rPos, k -> new RegionStructureSummary()).put(key, pos, summary);
        this.structureTypes.put(key, type);
        this.structureTags.putAll(key, tagKeys);
        this.dirty();
        SurveyorEvents.Invoke.structuresAdded(world, key, pos);
    }

    protected CompoundTag writeNbt(CompoundTag nbt) {
        CompoundTag structuresCompound = new CompoundTag();
        this.structureTypes.forEach((key, starts) -> {
            CompoundTag structureCompound = new CompoundTag();
            structureCompound.m_128359_(KEY_TYPE, this.structureTypes.get(key).m_135782_().toString());
            structureCompound.m_128365_(KEY_TAGS, (Tag)new ListTag(this.structureTags.get(key).stream().map(t -> StringTag.m_129297_((String)t.f_203868_().toString())).toList(), 8));
            structuresCompound.m_128365_(key.m_135782_().toString(), (Tag)structureCompound);
        });
        nbt.m_128365_(KEY_STRUCTURES, (Tag)structuresCompound);
        return nbt;
    }

    public int save(Level world, File folder) {
        ArrayList savedRegions = new ArrayList();
        if (this.isDirty()) {
            File structureFile = new File(folder, "structures.dat");
            try {
                NbtIo.m_128944_((CompoundTag)this.writeNbt(new CompoundTag()), (File)structureFile);
                this.dirty = false;
            }
            catch (IOException e) {
                Surveyor.LOGGER.error("[Surveyor] Error writing world structure summary file for {}.", (Object)world.m_46472_().m_135782_(), (Object)e);
            }
            this.regions.forEach((pos, summary) -> {
                if (!summary.isDirty()) {
                    return;
                }
                savedRegions.add(pos);
                CompoundTag regionCompound = summary.writeNbt(new CompoundTag());
                File regionFile = new File(folder, "s.%d.%d.dat".formatted(pos.f_45578_, pos.f_45579_));
                try {
                    NbtIo.m_128944_((CompoundTag)regionCompound, (File)regionFile);
                    summary.dirty = false;
                }
                catch (IOException e) {
                    Surveyor.LOGGER.error("[Surveyor] Error writing region structure summary file {}.", (Object)regionFile.getName(), (Object)e);
                }
            });
        }
        return savedRegions.size();
    }

    public Multimap<ResourceKey<Structure>, ChunkPos> readUpdatePacket(Level world, S2CStructuresAddedPacket packet) {
        if (Surveyor.CONFIG.structures == SystemMode.FROZEN) {
            return HashMultimap.create();
        }
        packet.structures().forEach((key, map) -> map.forEach((pos, start) -> this.put(world, (ResourceKey<Structure>)key, (ChunkPos)pos, (StructureStartSummary)start, packet.types().get(key), packet.tags().get(key))));
        return MapUtil.keyMultiMap(packet.structures());
    }

    public S2CStructuresAddedPacket createUpdatePacket(boolean shared, Multimap<ResourceKey<Structure>, ChunkPos> keySet) {
        HashMap<ResourceKey<Structure>, Map<ChunkPos, StructureStartSummary>> packetStructures = new HashMap<ResourceKey<Structure>, Map<ChunkPos, StructureStartSummary>>();
        HashMap packetTypes = new HashMap();
        HashMultimap packetTags = HashMultimap.create();
        keySet.forEach((key, pos) -> packetStructures.computeIfAbsent((ResourceKey<Structure>)key, k -> new HashMap()).put(pos, this.get((ResourceKey<Structure>)key, (ChunkPos)pos)));
        for (ResourceKey key2 : keySet.keySet()) {
            packetTypes.put((ResourceKey<Structure>)key2, this.getType((ResourceKey<Structure>)key2));
            packetTags.putAll((Object)key2, this.getTags((ResourceKey<Structure>)key2));
        }
        return new S2CStructuresAddedPacket(shared, packetStructures, packetTypes, (Multimap<ResourceKey<Structure>, TagKey<Structure>>)packetTags);
    }

    public boolean isDirty() {
        return (this.dirty || this.regions.values().stream().anyMatch(RegionStructureSummary::isDirty)) && Surveyor.CONFIG.structures != SystemMode.FROZEN;
    }

    private void dirty() {
        this.dirty = true;
    }

    private static /* synthetic */ void lambda$keySet$9(Multimap map, RegionStructureSummary r) {
        map.putAll(r.keySet());
    }
}

