/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.structure;

import folk.sisby.surveyor.util.ArrayUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public class StructurePieceSummary
extends StructurePiece {
    protected final CompoundTag pieceNbt;
    protected final ResourceKey<StructurePieceType> typeKey;

    public StructurePieceSummary(StructurePieceType type, int chainLength, BoundingBox boundingBox, CompoundTag pieceNbt) {
        super(type, chainLength, boundingBox);
        this.typeKey = (ResourceKey)BuiltInRegistries.f_257014_.m_7854_((Object)type).orElseThrow();
        this.pieceNbt = pieceNbt;
    }

    public StructurePieceSummary(CompoundTag nbt) {
        super((StructurePieceType)BuiltInRegistries.f_257014_.m_7745_(new ResourceLocation(nbt.m_128461_("id"))), nbt);
        this.typeKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256786_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("id")));
        this.pieceNbt = nbt.m_128469_("nbt");
    }

    public static StructurePieceSummary fromPiece(StructurePieceSerializationContext context, StructurePiece piece, boolean withNbt) {
        StructurePieceSummary summary = new StructurePieceSummary(piece.m_210000_(), piece.m_73548_(), piece.m_73547_(), new CompoundTag());
        if (withNbt) {
            CompoundTag summaryNbt = summary.toNbt();
            CompoundTag pieceNbt = piece.m_192644_(context);
            for (String key : summaryNbt.m_128431_()) {
                pieceNbt.m_128473_(key);
            }
            for (String key : pieceNbt.m_128431_()) {
                summary.pieceNbt.m_128365_(key, pieceNbt.m_128423_(key));
            }
        }
        return summary;
    }

    public final CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("id", this.typeKey.m_135782_().toString());
        nbt.m_128385_("BB", ArrayUtil.ofBlockBox(this.f_73383_));
        Direction direction = this.m_73549_();
        nbt.m_128405_("O", direction == null ? -1 : direction.m_122416_());
        nbt.m_128405_("GD", this.f_73384_);
        this.m_183620_(null, nbt);
        return nbt;
    }

    protected void m_183620_(StructurePieceSerializationContext context, CompoundTag nbt) {
        if (!this.pieceNbt.m_128456_()) {
            nbt.m_128365_("nbt", (Tag)this.pieceNbt);
        }
    }

    public void m_213694_(WorldGenLevel world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox chunkBox, ChunkPos chunkPos, BlockPos pivot) {
    }

    public CompoundTag getPieceNbt() {
        return this.pieceNbt;
    }
}

