/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.packet;

import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.packet.S2CPacket;
import folk.sisby.surveyor.terrain.ChunkSummary;
import folk.sisby.surveyor.terrain.RegionSummary;
import folk.sisby.surveyor.util.BitSetUtil;
import folk.sisby.surveyor.util.ListUtil;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;

public record S2CUpdateRegionPacket(boolean shared, ChunkPos regionPos, List<Integer> biomePalette, List<Integer> blockPalette, BitSet set, List<ChunkSummary> chunks) implements S2CPacket
{
    public static final ResourceLocation ID = new ResourceLocation("surveyor", "s2c_update_region");

    public static S2CUpdateRegionPacket of(boolean shared, ChunkPos regionPos, RegionSummary summary, BitSet keys) {
        return summary.createUpdatePacket(shared, regionPos, keys);
    }

    public static S2CUpdateRegionPacket read(FriendlyByteBuf buf) {
        return new S2CUpdateRegionPacket(buf.readBoolean(), buf.m_178383_(), buf.m_236845_(FriendlyByteBuf::m_130242_), buf.m_236845_(FriendlyByteBuf::m_130242_), buf.m_178384_(), (List)buf.m_236838_(ArrayList::new, ChunkSummary::new));
    }

    @Override
    public void writeBuf(FriendlyByteBuf buf) {
        buf.writeBoolean(this.shared);
        buf.m_178341_(this.regionPos);
        buf.m_236828_(this.biomePalette, FriendlyByteBuf::m_130130_);
        buf.m_236828_(this.blockPalette, FriendlyByteBuf::m_130130_);
        buf.m_178350_(this.set);
        buf.m_236828_(this.chunks, (b, summary) -> summary.writeBuf((FriendlyByteBuf)b));
    }

    @Override
    public Collection<FriendlyByteBuf> toBufs() {
        ArrayList<FriendlyByteBuf> bufs = new ArrayList<FriendlyByteBuf>();
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        this.writeBuf(buf);
        if (buf.readableBytes() < 0x100000) {
            bufs.add(buf);
        } else {
            if (this.set.cardinality() == 1) {
                int bit = this.set.stream().findFirst().orElseThrow();
                Surveyor.LOGGER.error("Couldn't create a terrain update packet at {} - an individual chunk would be too large to send!", (Object)"[%d,%d]".formatted(this.regionPos.f_45578_ + RegionSummary.xForBit(bit), this.regionPos.f_45579_ + RegionSummary.zForBit(bit)));
                return List.of();
            }
            for (BitSet splitChunks : BitSetUtil.half(this.set)) {
                bufs.addAll(new S2CUpdateRegionPacket(this.shared, this.regionPos, this.biomePalette, this.blockPalette, splitChunks, ListUtil.splitSet(this.chunks, splitChunks, this.set)).toBufs());
            }
        }
        return bufs;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }
}

