/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.mixin;

import com.mojang.authlib.GameProfile;
import folk.sisby.surveyor.PlayerSummary;
import folk.sisby.surveyor.ServerSummary;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorPlayer;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.landmark.PlayerDeathLandmark;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import folk.sisby.surveyor.util.TextUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ServerboundClientInformationPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public class MixinServerPlayerEntity
implements SurveyorPlayer {
    @Unique
    PlayerSummary.ServerPlayerEntitySummary surveyor$summary = null;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void init(MinecraftServer server, ServerLevel world, GameProfile profile, CallbackInfo ci) {
        ServerPlayer self = (ServerPlayer)this;
        this.surveyor$summary = new PlayerSummary.ServerPlayerEntitySummary(self);
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    public void writeSurveyorData(CompoundTag nbt, CallbackInfo ci) {
        ServerPlayer self = (ServerPlayer)this;
        this.surveyor$summary.writeNbt(nbt);
        ServerSummary.of(self.m_20194_()).updatePlayer(Surveyor.getUuid(self), nbt, false, self.m_20194_());
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    public void readSurveyorData(CompoundTag nbt, CallbackInfo ci) {
        this.surveyor$summary.read(nbt);
    }

    @Inject(method={"setClientSettings"}, at={@At(value="HEAD")})
    public void setSurveyorViewDistance(ServerboundClientInformationPacket packet, CallbackInfo ci) {
        this.surveyor$summary.setViewDistance(packet.f_133864_());
    }

    @Inject(method={"onDeath"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/damage/DamageTracker;update()V")})
    public void onDeath(DamageSource damageSource, CallbackInfo ci) {
        if (!Surveyor.CONFIG.playerDeathLandmarks) {
            return;
        }
        ServerPlayer self = (ServerPlayer)this;
        WorldLandmarks summary = WorldSummary.of((Level)self.m_284548_()).landmarks();
        if (summary == null) {
            return;
        }
        summary.put((Level)self.m_284548_(), new PlayerDeathLandmark(self.m_20183_(), Surveyor.getUuid(self), TextUtil.stripInteraction(self.m_21231_().m_19293_()), self.m_284548_().m_46468_(), self.m_217043_().m_188502_()));
    }

    @Inject(method={"copyFrom"}, at={@At(value="TAIL")})
    public void copyFrom(ServerPlayer oldPlayer, boolean alive, CallbackInfo ci) {
        this.surveyor$summary.copyFrom(PlayerSummary.of(oldPlayer));
    }

    @Override
    public PlayerSummary surveyor$getSummary() {
        return this.surveyor$summary;
    }
}

