/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.util.settings;

import com.minelittlepony.common.util.settings.Setting;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class Value<T>
implements Setting<T> {
    private T value;
    private final transient Setting.Type<T> type;
    private final transient String name;
    private transient List<String> comment = new ArrayList<String>();
    private final transient List<Consumer<T>> listeners = new ArrayList<Consumer<T>>();

    public Value(String name, Setting.Type<T> type) {
        this.name = name;
        this.type = type;
        this.value = this.getDefault();
    }

    @Override
    public void onChanged(Consumer<T> listener) {
        this.listeners.add(listener);
    }

    @Override
    @NotNull
    public T get() {
        if (this.value == null) {
            return this.set(this.getDefault());
        }
        return this.value;
    }

    @Override
    public T set(@Nullable T value) {
        this.value = value == null ? this.getDefault() : value;
        this.listeners.forEach(l -> l.accept(this.value));
        return this.value;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Setting.Type<T> getType() {
        return this.type;
    }

    public String toString() {
        return this.name();
    }

    @Override
    public List<String> getComments() {
        return this.comment;
    }

    @Override
    public Setting<T> addComment(String comment) {
        this.comment.add(comment);
        return this;
    }
}

