/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.util.registry;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Locale;
import java.util.function.BiFunction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;

public class RegistryTypeAdapter<T>
extends TypeAdapter<T> {
    private final Registry<T> registry;

    public static <T> TypeAdapter<T> of(Registry<T> registry) {
        return new RegistryTypeAdapter<T>(registry);
    }

    public static <T> TypeAdapter<T> of(final Registry<T> registry, final BiFunction<String, Registry<T>, T> defaultValue) {
        return new RegistryTypeAdapter<T>(registry){

            @Override
            public T read(JsonReader in) throws IOException {
                String s = in.nextString();
                if (s == null) {
                    return null;
                }
                String ls = s.toLowerCase(Locale.US);
                return registry.m_6612_(new ResourceLocation(ls)).orElseGet(() -> defaultValue.apply(ls, registry));
            }
        };
    }

    protected RegistryTypeAdapter(Registry<T> registry) {
        this.registry = registry;
    }

    public void write(JsonWriter out, T value) throws IOException {
        ResourceLocation id;
        if (value != null && (id = this.registry.m_7981_(value)) != null) {
            out.value(id.toString());
            return;
        }
        out.nullValue();
    }

    public T read(JsonReader in) throws IOException {
        String s = in.nextString();
        return (T)(s == null ? null : this.registry.m_7745_(new ResourceLocation(s.toLowerCase(Locale.ROOT))));
    }
}

