/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.client.gui.element;

import com.minelittlepony.common.client.gui.IField;
import com.minelittlepony.common.client.gui.dimension.Bounds;
import com.minelittlepony.common.client.gui.element.Button;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;

public class Toggle
extends Button
implements IField<Boolean, Toggle> {
    private boolean on;
    @NotNull
    private IField.IChangeCallback<Boolean> action = IField.IChangeCallback::none;

    public Toggle(int x, int y, boolean value) {
        super(x, y, 30, 15);
        this.on = value;
    }

    @Override
    public Toggle onChange(@NotNull IField.IChangeCallback<Boolean> action) {
        this.action = action;
        return this;
    }

    @Override
    public Boolean getValue() {
        return this.on;
    }

    @Override
    public Toggle setValue(Boolean value) {
        if (value != this.on) {
            this.on = this.action.perform(value);
        }
        return this;
    }

    @Override
    public Bounds getBounds() {
        Bounds bounds = super.getBounds();
        Component label = this.getStyle().getText();
        int labelWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)label);
        bounds.width = labelWidth > 0 ? Math.max(bounds.width, this.f_93618_ + 10 + labelWidth) : this.f_93618_;
        return bounds;
    }

    @Override
    public void m_5691_() {
        super.m_5691_();
        this.setValue(!this.on);
    }

    @Override
    protected void renderBackground(GuiGraphics context, Minecraft mc, int mouseX, int mouseY) {
        int i = super.m_274533_();
        int sliderX = this.m_252754_() + (this.on ? 1 : 0) * (this.f_93618_ - 8);
        this.renderButtonBlit(context, sliderX, this.m_252907_(), i, 8, this.f_93619_);
    }

    @Override
    protected void renderForground(GuiGraphics context, Minecraft mc, int mouseX, int mouseY, int foreColor) {
        int n = this.m_252907_();
        Objects.requireNonNull(mc.f_91062_);
        int textY = n + 9 / 2;
        int textX = this.m_252754_() + this.f_93618_ + 10;
        this.drawLabel(context, this.getStyle().getText(), textX, textY, foreColor, 0.0);
    }

    protected int m_274533_() {
        return 46;
    }
}

