/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.client.gui;

import com.minelittlepony.common.client.gui.ITextContext;
import com.minelittlepony.common.client.gui.IViewRoot;
import com.minelittlepony.common.client.gui.IViewRootDefaultImpl;
import com.minelittlepony.common.client.gui.dimension.Bounds;
import com.minelittlepony.common.client.gui.dimension.IBounded;
import com.minelittlepony.common.client.gui.dimension.Padding;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import org.jetbrains.annotations.Nullable;

public class GameGui
extends Screen
implements IViewRoot,
IBounded,
ITextContext,
IViewRootDefaultImpl {
    @Nullable
    protected final Screen parent;
    public static boolean drawAllDebugBounds;
    public boolean drawDebugBounds;

    protected GameGui(Component title) {
        this(title, Minecraft.m_91087_().f_91080_);
    }

    protected GameGui(Component title, @Nullable Screen parent) {
        super(title);
        this.parent = parent;
    }

    public static void playSound(SoundEvent event) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)event, (float)1.0f));
    }

    public static void playSound(Holder.Reference<SoundEvent> event) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_(event, (float)1.0f));
    }

    public static boolean isKeyDown(int key) {
        return InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)key);
    }

    public static Supplier<Boolean> keyCheck(int key) {
        return () -> GameGui.isKeyDown(key);
    }

    public void finish() {
        this.m_7861_();
        this.f_96541_.m_91152_(this.parent);
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(context, mouseX, mouseY, partialTicks);
        this.drawDebugOverlays(context, mouseX, mouseY);
    }

    private void drawDebugOverlays(GuiGraphics context, int mouseX, int mouseY) {
        if (this.drawDebugBounds || drawAllDebugBounds) {
            context.m_280168_().m_85836_();
            context.m_280168_().m_252880_(0.0f, 0.0f, -90.0f);
            Padding padding = this.getContentPadding();
            Padding scrollOffset = new Padding(-this.getScrollY() - padding.top, -this.getScrollX() - padding.left, 0, 0);
            for (Bounds bound : this.getAllBounds()) {
                int color = 0xAA000000 | bound.hashCode() << 6;
                if (!this.isUnFixedPosition(bound)) {
                    bound = bound.offset(scrollOffset);
                }
                if (bound.contains(mouseX, mouseY)) {
                    bound.debugMeasure(context);
                }
                bound.draw(context, color);
            }
            context.m_280168_().m_85849_();
        }
    }

    protected boolean isUnFixedPosition(Bounds bound) {
        return true;
    }
}

