/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.create;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import java.lang.ref.WeakReference;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.compat.create.ContraptionHelper;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageBase;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageData;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageSettingsContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.util.NoopStorageWrapper;

public abstract class MountedStorageContainerMenuBase
extends StorageContainerMenuBase<IStorageWrapper> {
    protected final WeakReference<AbstractContraptionEntity> contraptionEntity;
    protected final BlockPos localPos;
    @Nullable
    private CompoundTag lastSettingsNbt = null;
    protected final MountedStorageBase mountedStorage;

    public MountedStorageContainerMenuBase(MenuType<?> menuType, int containerId, Player player, IStorageWrapper parentStorageWrapper, int storageItemSlotIndex, boolean shouldLockStorageItemSlot, int contraptionEntityId, BlockPos localPos) {
        this(menuType, containerId, player, MountedStorageContainerMenuBase.getWrapper(player.m_9236_(), contraptionEntityId, localPos), parentStorageWrapper, storageItemSlotIndex, shouldLockStorageItemSlot, contraptionEntityId, localPos);
    }

    public MountedStorageContainerMenuBase(MenuType<?> menuType, int containerId, Player player, IStorageWrapper wrapper, IStorageWrapper parentStorageWrapper, int storageItemSlotIndex, boolean shouldLockStorageItemSlot, int contraptionEntityId, BlockPos localPos) {
        super(menuType, containerId, player, wrapper, parentStorageWrapper, storageItemSlotIndex, shouldLockStorageItemSlot);
        Entity entity = player.m_9236_().m_6815_(contraptionEntityId);
        if (!(entity instanceof AbstractContraptionEntity)) {
            throw new IllegalArgumentException("Incorrect entity with id " + contraptionEntityId + " expected to find AbstractContraptionEntity");
        }
        AbstractContraptionEntity cEntity = (AbstractContraptionEntity)entity;
        this.contraptionEntity = new WeakReference<AbstractContraptionEntity>(cEntity);
        this.localPos = localPos;
        MountedStorageBase itemStorage = ContraptionHelper.getMountedStorage(cEntity, localPos);
        if (itemStorage == null) {
            throw new IllegalArgumentException("Incorrect storage type at " + String.valueOf(localPos) + " expected to find MountedStorageBase");
        }
        this.mountedStorage = itemStorage;
    }

    protected Optional<MountedStorageBase> getMountedStorage() {
        AbstractContraptionEntity c = (AbstractContraptionEntity)this.contraptionEntity.get();
        if (c == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(ContraptionHelper.getMountedStorage(c, this.localPos));
    }

    private static IStorageWrapper getWrapper(Level level, int contraptionEntityId, BlockPos localPos) {
        Entity entity = level.m_6815_(contraptionEntityId);
        if (!(entity instanceof AbstractContraptionEntity)) {
            return NoopStorageWrapper.INSTANCE;
        }
        AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)entity;
        MountedStorageBase itemStorage = ContraptionHelper.getMountedStorage(contraptionEntity, localPos);
        if (itemStorage == null) {
            return NoopStorageWrapper.INSTANCE;
        }
        return itemStorage.getStorageWrapper();
    }

    public Optional<AbstractContraptionEntity> getContraptionEntity() {
        return Optional.ofNullable((AbstractContraptionEntity)this.contraptionEntity.get());
    }

    public BlockPos getLocalPos() {
        return this.localPos;
    }

    @Override
    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.getContraptionEntity().ifPresent(c -> {
            Vec3 localPosVec = Vec3.m_82512_((Vec3i)this.localPos);
            Vec3 newPos = c.toGlobalVector(localPosVec, 0.0f);
            MountedStorageBase mountedStorage = ContraptionHelper.getMountedStorage(c, this.localPos);
            if (mountedStorage != null) {
                mountedStorage.onClose(player, newPos);
            }
        });
    }

    @Override
    public Optional<BlockPos> getBlockPosition() {
        return Optional.empty();
    }

    @Override
    public Optional<Entity> getEntity() {
        return this.getContraptionEntity().map(c -> c);
    }

    @Override
    public void openSettings() {
        if (this.isClientSide()) {
            this.sendToServer(data -> data.m_128359_("action", "openSettings"));
            return;
        }
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.getContraptionEntity().ifPresent(c -> NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((w, p, pl) -> this.instantiateSettingsContainerMenu(w, pl, c.m_19879_(), this.localPos), (Component)Component.m_237115_((String)this.getSettingsTitleKey())), this::writeSettingsContainerMenuExtraData));
        }
    }

    protected abstract void writeSettingsContainerMenuExtraData(FriendlyByteBuf var1);

    protected abstract String getSettingsTitleKey();

    protected abstract MountedStorageSettingsContainerMenuBase instantiateSettingsContainerMenu(int var1, Player var2, int var3, BlockPos var4);

    @Override
    protected boolean storageItemHasChanged() {
        return false;
    }

    @Override
    public boolean detectSettingsChangeAndReload() {
        if (this.player.m_9236_().f_46443_) {
            return this.storageWrapper.getContentsUuid().map(uuid -> {
                MountedStorageData storage = MountedStorageData.get(uuid);
                if (storage.removeUpdatedStorageSettingsFlag((UUID)uuid)) {
                    CompoundTag contents = storage.getContents();
                    this.storageWrapper.getSettingsHandler().reloadFrom(this.getSettingsTag(contents));
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    protected abstract CompoundTag getSettingsTag(CompoundTag var1);

    public boolean m_6875_(Player player) {
        return this.getContraptionEntity().map(c -> {
            Vec3 localPosVec = Vec3.m_82512_((Vec3i)this.localPos);
            Vec3 currentPos = c.toGlobalVector(localPosVec, 0.0f);
            return c.m_6084_() && player.m_20238_(currentPos) < 64.0;
        }).orElse(false);
    }

    @Override
    protected void sendStorageSettingsToClient() {
        if (this.player.m_9236_().f_46443_) {
            return;
        }
        if (this.lastSettingsNbt == null || !this.lastSettingsNbt.equals((Object)this.storageWrapper.getSettingsHandler().getNbt())) {
            this.lastSettingsNbt = this.storageWrapper.getSettingsHandler().getNbt().m_6426_();
            this.storageWrapper.getContentsUuid().ifPresent(uuid -> {
                CompoundTag settingsContents = new CompoundTag();
                CompoundTag settingsNbt = this.storageWrapper.getSettingsHandler().getNbt();
                if (!settingsNbt.m_128456_()) {
                    settingsContents.m_128365_("settings", (Tag)settingsNbt);
                    Player patt6680$temp = this.player;
                    if (patt6680$temp instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)patt6680$temp;
                        this.sendSettingsToClient((UUID)uuid, serverPlayer, settingsContents);
                    }
                }
            });
        }
    }

    protected abstract void sendSettingsToClient(UUID var1, ServerPlayer var2, CompoundTag var3);
}

