/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas;

import com.google.common.collect.Multimap;
import folk.sisby.antique_atlas.AntiqueAtlas;
import folk.sisby.antique_atlas.AntiqueAtlasConfig;
import folk.sisby.antique_atlas.MarkerTexture;
import folk.sisby.antique_atlas.StructureTileProvider;
import folk.sisby.antique_atlas.TerrainTileProvider;
import folk.sisby.antique_atlas.TerrainTiling;
import folk.sisby.antique_atlas.TileElevation;
import folk.sisby.antique_atlas.TileTexture;
import folk.sisby.antique_atlas.reloader.BiomeTileProviders;
import folk.sisby.antique_atlas.reloader.MarkerTextures;
import folk.sisby.antique_atlas.reloader.StructureTileProviders;
import folk.sisby.antique_atlas.util.Rect;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.client.SurveyorClient;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.LandmarkType;
import folk.sisby.surveyor.landmark.PlayerDeathLandmark;
import folk.sisby.surveyor.landmark.SimplePointLandmark;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import folk.sisby.surveyor.structure.WorldStructureSummary;
import folk.sisby.surveyor.terrain.WorldTerrainSummary;
import it.unimi.dsi.fastutil.Pair;
import java.util.BitSet;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;

public class WorldAtlasData {
    public static final Map<ResourceKey<Level>, WorldAtlasData> WORLDS = new HashMap<ResourceKey<Level>, WorldAtlasData>();
    private final Map<ChunkPos, TileTexture> biomeTiles = new HashMap<ChunkPos, TileTexture>();
    private final Map<ChunkPos, TileTexture> structureTiles = new HashMap<ChunkPos, TileTexture>();
    private final Map<LandmarkType<?>, Map<BlockPos, Pair<Landmark<?>, MarkerTexture>>> landmarkMarkers = new ConcurrentHashMap();
    private final Map<Landmark<?>, MarkerTexture> structureMarkers = new ConcurrentHashMap();
    private final Rect tileScope = new Rect(0, 0, 0, 0);
    private final Set<ChunkPos> terrainDequeHash = new HashSet<ChunkPos>();
    private final Deque<ChunkPos> terrainDeque = new ConcurrentLinkedDeque<ChunkPos>();
    boolean isFinished = false;
    private final Map<ChunkPos, String> debugBiomePredicates = new HashMap<ChunkPos, String>();
    private final Map<ChunkPos, String> debugStructurePredicates = new HashMap<ChunkPos, String>();
    private final Map<ChunkPos, TerrainTileProvider> debugBiomes = new HashMap<ChunkPos, TerrainTileProvider>();
    private final Map<ChunkPos, StructureTileProvider> debugStructures = new HashMap<ChunkPos, StructureTileProvider>();

    public static WorldAtlasData getOrCreate(Level world) {
        return WORLDS.computeIfAbsent((ResourceKey<Level>)world.m_46472_(), k -> new WorldAtlasData());
    }

    public static void onLoad(Level world, WorldSummary summary, LocalPlayer player, Map<ChunkPos, BitSet> terrain, Multimap<ResourceKey<Structure>, ChunkPos> structures, Multimap<LandmarkType<?>, BlockPos> landmarks) {
        WorldAtlasData data = WorldAtlasData.getOrCreate(world);
        data.onTerrainUpdated(world, summary.terrain(), WorldTerrainSummary.toKeys(terrain, (ChunkPos)player.m_146902_()));
        data.onStructuresAdded(world, summary.structures(), structures);
        data.onLandmarksAdded(world, summary.landmarks(), landmarks);
        AntiqueAtlas.LOGGER.info("[Antique Atlas] Beginning to load terrain for {} - {} chunks available.", (Object)world.m_46472_().m_135782_(), (Object)data.terrainDeque.size());
    }

    public void onTerrainUpdated(Level world, WorldTerrainSummary ignored2, Collection<ChunkPos> chunks) {
        for (ChunkPos pos : chunks) {
            if (this.biomeTiles.containsKey(pos) || this.terrainDequeHash.contains(pos)) continue;
            this.terrainDequeHash.add(pos);
            this.terrainDeque.add(pos);
        }
    }

    public void onStructuresAdded(Level world, WorldStructureSummary ws, Multimap<ResourceKey<Structure>, ChunkPos> summaries) {
        summaries.forEach((key, pos) -> StructureTileProviders.getInstance().resolve(this.structureTiles, this.debugStructures, this.debugStructurePredicates, this.structureMarkers, world, (ResourceKey<Structure>)key, (ChunkPos)pos, ws.get(key, pos), (ResourceKey<StructureType<?>>)ws.getType(key), ws.getTags(key)));
    }

    public void tick(Level world) {
        if (!BiomeTileProviders.getInstance().hasFallbacks()) {
            return;
        }
        for (int i = 0; i < AntiqueAtlas.CONFIG.chunkTickLimit; ++i) {
            Pair<TerrainTileProvider, TileElevation> tile;
            ChunkPos pos = this.terrainDeque.pollFirst();
            this.terrainDequeHash.remove(pos);
            if (pos == null) break;
            Pair<TerrainTileProvider, TileElevation> pair = tile = world.m_46472_() == Level.f_46429_ ? TerrainTiling.terrainToTileNether(world, pos) : TerrainTiling.terrainToTile(world, pos);
            if (tile == null) continue;
            this.tileScope.extendTo(pos.f_45578_, pos.f_45579_);
            this.biomeTiles.put(pos, ((TerrainTileProvider)tile.left()).getTexture(pos, (TileElevation)((Object)tile.right())));
            this.debugBiomes.put(pos, (TerrainTileProvider)tile.left());
            this.debugBiomePredicates.put(pos, tile.right() == null ? null : ((TileElevation)((Object)tile.right())).getName());
        }
        if (!this.isFinished && this.terrainDeque.isEmpty()) {
            this.isFinished = true;
            AntiqueAtlas.LOGGER.info("[Antique Atlas] Finished loading terrain for {} - {} tiles.", (Object)world.m_46472_().m_135782_(), (Object)this.biomeTiles.size());
        }
    }

    public Rect getScope() {
        return this.tileScope;
    }

    public TileTexture getTile(int x, int z) {
        return this.getTile(new ChunkPos(x, z));
    }

    public TileTexture getTile(ChunkPos pos) {
        if (!this.biomeTiles.containsKey(pos)) {
            return null;
        }
        return this.structureTiles.getOrDefault(pos, this.biomeTiles.get(pos));
    }

    public ResourceLocation getProvider(ChunkPos pos) {
        if (this.structureTiles.containsKey(pos)) {
            return this.debugStructures.get(pos).id();
        }
        return this.debugBiomes.containsKey(pos) ? this.debugBiomes.get(pos).id() : null;
    }

    public String getTilePredicate(ChunkPos pos) {
        if (this.structureTiles.containsKey(pos)) {
            return this.debugStructurePredicates.get(pos);
        }
        return this.debugBiomePredicates.get(pos);
    }

    private void addLandmarkMarker(Landmark<?> landmark, MarkerTexture texture) {
        this.landmarkMarkers.computeIfAbsent(landmark.type(), t -> new ConcurrentHashMap()).put(landmark.pos(), Pair.of(landmark, (Object)texture));
    }

    private void addLandmark(Landmark<?> baseLandmark) {
        if (baseLandmark.type() == PlayerDeathLandmark.TYPE) {
            PlayerDeathLandmark landmark = (PlayerDeathLandmark)baseLandmark;
            AntiqueAtlasConfig.GraveStyle style = AntiqueAtlas.CONFIG.graveStyle;
            if (landmark.name() == null && style == AntiqueAtlasConfig.GraveStyle.CAUSE) {
                style = AntiqueAtlasConfig.GraveStyle.DIED;
            }
            MutableComponent timeText = Component.m_237113_((String)String.valueOf(1L + landmark.created() / 24000L)).m_130940_(ChatFormatting.WHITE);
            String key = "gui.antique_atlas.marker.death.%s".formatted(style.toString().toLowerCase());
            MutableComponent text = switch (style) {
                default -> throw new IncompatibleClassChangeError();
                case AntiqueAtlasConfig.GraveStyle.CAUSE -> Component.m_237110_((String)key, (Object[])new Object[]{landmark.name().m_6881_().m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.RED), timeText}).m_130940_(ChatFormatting.GRAY);
                case AntiqueAtlasConfig.GraveStyle.GRAVE, AntiqueAtlasConfig.GraveStyle.ITEMS, AntiqueAtlasConfig.GraveStyle.DIED -> Component.m_237110_((String)key, (Object[])new Object[]{Component.m_237115_((String)"gui.antique_atlas.marker.death.%s.verb".formatted(style.toString().toLowerCase())).m_130940_(ChatFormatting.RED), timeText}).m_130940_(ChatFormatting.GRAY);
                case AntiqueAtlasConfig.GraveStyle.EUPHEMISMS -> Component.m_237110_((String)key, (Object[])new Object[]{Component.m_237115_((String)"gui.antique_atlas.marker.death.%s.verb.%s".formatted(style.toString().toLowerCase(), new Random(landmark.seed()).nextInt(11))).m_130940_(ChatFormatting.RED), timeText}).m_130940_(ChatFormatting.GRAY);
            };
            this.addLandmarkMarker((Landmark<?>)new PlayerDeathLandmark(landmark.pos(), landmark.owner(), (Component)text, landmark.created(), landmark.seed()), MarkerTextures.getInstance().getLandmarkType(landmark.type(), style == AntiqueAtlasConfig.GraveStyle.ITEMS ? "items" : null));
        } else {
            this.addLandmarkMarker(baseLandmark, MarkerTextures.getInstance().getOrDefault(baseLandmark.texture(), MarkerTextures.getInstance().getLandmarkType(baseLandmark.type())));
        }
    }

    public void onLandmarksAdded(Level ignored, WorldLandmarks worldLandmarks, Multimap<LandmarkType<?>, BlockPos> landmarks) {
        landmarks.forEach((type, pos) -> this.addLandmark(worldLandmarks.get(type, pos)));
    }

    public void onLandmarksRemoved(Level ignored, WorldLandmarks ignored2, Multimap<LandmarkType<?>, BlockPos> landmarks) {
        landmarks.forEach((type, pos) -> {
            if (this.landmarkMarkers.containsKey(type)) {
                this.landmarkMarkers.get(type).remove(pos);
                if (this.landmarkMarkers.get(type).isEmpty()) {
                    this.landmarkMarkers.remove(type);
                }
            }
        });
    }

    public static boolean landmarkIsEditable(Landmark<?> landmark) {
        return landmark.owner() != null && SurveyorClient.getClientUuid().equals(landmark.owner());
    }

    public boolean deleteLandmark(Level world, Landmark<?> landmark) {
        WorldLandmarks summary = WorldSummary.of((Level)world).landmarks();
        if (summary == null || !WorldAtlasData.landmarkIsEditable(landmark)) {
            return false;
        }
        summary.remove(world, landmark.type(), landmark.pos());
        return true;
    }

    public Map<Landmark<?>, MarkerTexture> getEditableLandmarks() {
        HashMap map = new HashMap();
        this.landmarkMarkers.forEach((type, landmarks) -> landmarks.forEach((pos, pair) -> {
            if (WorldAtlasData.landmarkIsEditable((Landmark)pair.left())) {
                map.put((Landmark)pair.left(), (MarkerTexture)pair.right());
            }
        }));
        return map;
    }

    public Map<Landmark<?>, MarkerTexture> getAllMarkers(int tileChunks) {
        HashMap map = new HashMap();
        this.landmarkMarkers.forEach((type, landmarks) -> landmarks.forEach((pos, pair) -> map.put((Landmark)pair.left(), (MarkerTexture)pair.right())));
        this.structureMarkers.forEach((landmark, texture) -> {
            if (tileChunks >= texture.nearClip() && tileChunks <= texture.farClip()) {
                map.put((Landmark<?>)landmark, (MarkerTexture)texture);
            }
        });
        return map;
    }

    public MarkerTexture getMarkerTexture(Landmark<?> landmark) {
        return this.landmarkMarkers.containsKey(landmark.type()) && this.landmarkMarkers.get(landmark.type()).containsKey(landmark.pos()) ? (MarkerTexture)this.landmarkMarkers.get(landmark.type()).get(landmark.pos()).right() : this.structureMarkers.get(landmark);
    }

    public void placeCustomMarker(Level world, MarkerTexture selectedTexture, DyeColor color, MutableComponent label, BlockPos blockPos) {
        WorldLandmarks summary = WorldSummary.of((Level)world).landmarks();
        if (summary == null) {
            return;
        }
        summary.put(world, (Landmark)new SimplePointLandmark(blockPos, SurveyorClient.getClientUuid(), color, (Component)label, null, selectedTexture.keyId()));
    }
}

