/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.client;

import com.google.common.collect.Multimap;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorEvents;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.SurveyorNetworking;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.client.NetworkHandlerSummary;
import folk.sisby.surveyor.client.SurveyorClient;
import folk.sisby.surveyor.config.NetworkMode;
import folk.sisby.surveyor.packet.C2SKnownLandmarksPacket;
import folk.sisby.surveyor.packet.C2SKnownStructuresPacket;
import folk.sisby.surveyor.packet.C2SKnownTerrainPacket;
import folk.sisby.surveyor.packet.S2CGroupChangedPacket;
import folk.sisby.surveyor.packet.S2CGroupUpdatedPacket;
import folk.sisby.surveyor.packet.S2CPacket;
import folk.sisby.surveyor.packet.S2CStructuresAddedPacket;
import folk.sisby.surveyor.packet.S2CUpdateRegionPacket;
import folk.sisby.surveyor.packet.SyncLandmarksAddedPacket;
import folk.sisby.surveyor.packet.SyncLandmarksRemovedPacket;
import folk.sisby.surveyor.terrain.RegionSummary;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;

public class SurveyorClientNetworking {
    public static void init() {
        SurveyorNetworking.C2S_SENDER = p -> {
            if (!ClientPlayNetworking.canSend((ResourceLocation)p.getId())) {
                return;
            }
            p.toBufs().forEach(buf -> ClientPlayNetworking.send((ResourceLocation)p.getId(), (FriendlyByteBuf)buf));
        };
        ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)S2CUpdateRegionPacket.ID, (c, h, b, s) -> SurveyorClientNetworking.handleClient(b, S2CUpdateRegionPacket::read, SurveyorClientNetworking::handleTerrainAdded));
        ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)S2CStructuresAddedPacket.ID, (c, h, b, s) -> SurveyorClientNetworking.handleClient(b, S2CStructuresAddedPacket::read, SurveyorClientNetworking::handleStructuresAdded));
        ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)S2CGroupChangedPacket.ID, (c, h, b, s) -> SurveyorClientNetworking.handleClient(b, S2CGroupChangedPacket::read, SurveyorClientNetworking::handleGroupChanged));
        ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)S2CGroupUpdatedPacket.ID, (c, h, b, s) -> SurveyorClientNetworking.handleClient(b, S2CGroupUpdatedPacket::read, SurveyorClientNetworking::handleGroupUpdated));
        ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)SyncLandmarksAddedPacket.ID, (c, h, b, s) -> SurveyorClientNetworking.handleClient(b, SyncLandmarksAddedPacket::read, SurveyorClientNetworking::handleLandmarksAdded));
        ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)SyncLandmarksRemovedPacket.ID, (c, h, b, s) -> SurveyorClientNetworking.handleClient(b, SyncLandmarksRemovedPacket::read, SurveyorClientNetworking::handleLandmarksRemoved));
    }

    private static void handleTerrainAdded(ClientLevel world, WorldSummary summary, S2CUpdateRegionPacket packet) {
        if (summary.terrain() == null) {
            return;
        }
        summary.terrain().getRegion(packet.regionPos()).readUpdatePacket(world.m_9598_(), packet);
        (packet.shared() ? SurveyorClient.getSharedExploration() : SurveyorClient.getPersonalExploration()).mergeRegion((ResourceKey<Level>)world.m_46472_(), packet.regionPos(), packet.set());
        SurveyorEvents.Invoke.terrainUpdated((Level)world, packet.set().stream().mapToObj(i -> RegionSummary.chunkForBit(packet.regionPos(), i)).toList());
    }

    private static void handleStructuresAdded(ClientLevel world, WorldSummary summary, S2CStructuresAddedPacket packet) {
        if (summary.structures() == null) {
            return;
        }
        Multimap<ResourceKey<Structure>, ChunkPos> keySet = summary.structures().readUpdatePacket((Level)world, packet);
        if (Minecraft.m_91087_().f_91074_ != null) {
            SurveyorExploration exploration = packet.shared() ? SurveyorClient.getSharedExploration() : SurveyorClient.getPersonalExploration();
            keySet.forEach((key, pos) -> exploration.addStructure((ResourceKey<Level>)world.m_46472_(), (ResourceKey<Structure>)key, (ChunkPos)pos));
        }
    }

    private static void handleGroupChanged(ClientLevel world, WorldSummary summary, S2CGroupChangedPacket packet) {
        if (!SurveyorClient.getSharedExploration().groupPlayers().equals(packet.players().keySet())) {
            SurveyorClient.getSharedExploration().groupPlayers().clear();
            SurveyorClient.getSharedExploration().groupPlayers().addAll(packet.players().keySet());
        }
        NetworkHandlerSummary.of(Minecraft.m_91087_().m_91403_()).mergeSummaries(packet.players());
        SurveyorClient.getSharedExploration().replaceTerrain((ResourceKey<Level>)world.m_46472_(), packet.regionBits());
        SurveyorClient.getSharedExploration().replaceStructures((ResourceKey<Level>)world.m_46472_(), packet.structureKeys());
        SurveyorClient.getExploration().updateClientForLandmarks((Level)world);
        if (summary != null) {
            if (summary.terrain() != null && Surveyor.CONFIG.networking.terrain.atLeast(NetworkMode.SOLO)) {
                new C2SKnownTerrainPacket(summary.terrain().bitSet(null)).send();
            }
            if (summary.structures() != null && Surveyor.CONFIG.networking.structures.atLeast(NetworkMode.SOLO)) {
                new C2SKnownStructuresPacket(summary.structures().keySet(null)).send();
            }
            if (summary.landmarks() != null && Surveyor.CONFIG.networking.landmarks.atLeast(NetworkMode.SOLO)) {
                new C2SKnownLandmarksPacket(summary.landmarks().keySet(null)).send();
            }
        }
    }

    private static void handleGroupUpdated(ClientLevel world, WorldSummary summary, S2CGroupUpdatedPacket packet) {
        NetworkHandlerSummary.of(Minecraft.m_91087_().m_91403_()).mergeSummaries(packet.players());
    }

    private static void handleLandmarksAdded(ClientLevel world, WorldSummary summary, SyncLandmarksAddedPacket packet) {
        if (summary.landmarks() == null) {
            return;
        }
        summary.landmarks().readUpdatePacket((Level)world, packet, null);
    }

    private static void handleLandmarksRemoved(ClientLevel world, WorldSummary summary, SyncLandmarksRemovedPacket packet) {
        if (summary.landmarks() == null) {
            return;
        }
        summary.landmarks().readUpdatePacket((Level)world, packet, null);
    }

    private static <T extends S2CPacket> void handleClient(FriendlyByteBuf buf, Function<FriendlyByteBuf, T> reader, ClientPacketHandler<T> handler) {
        WorldSummary summary;
        S2CPacket packet = (S2CPacket)reader.apply(buf);
        WorldSummary worldSummary = summary = Minecraft.m_91087_().f_91073_ == null ? null : WorldSummary.of((Level)Minecraft.m_91087_().f_91073_);
        if (summary != null && !summary.isClient()) {
            return;
        }
        Minecraft.m_91087_().execute(() -> handler.handle(Minecraft.m_91087_().f_91073_, summary, packet));
    }

    public static interface ClientPacketHandler<T> {
        public void handle(ClientLevel var1, WorldSummary var2, T var3);
    }
}

