/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.client;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import folk.sisby.surveyor.PlayerSummary;
import folk.sisby.surveyor.ServerSummary;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorEvents;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.client.NetworkHandlerSummary;
import folk.sisby.surveyor.client.SurveyorClientCommands;
import folk.sisby.surveyor.client.SurveyorClientEvents;
import folk.sisby.surveyor.client.SurveyorClientNetworking;
import folk.sisby.surveyor.client.SurveyorNetworkHandler;
import folk.sisby.surveyor.config.NetworkMode;
import folk.sisby.surveyor.landmark.LandmarkType;
import folk.sisby.surveyor.packet.C2SKnownLandmarksPacket;
import folk.sisby.surveyor.packet.C2SKnownStructuresPacket;
import folk.sisby.surveyor.packet.C2SKnownTerrainPacket;
import folk.sisby.surveyor.terrain.WorldTerrainSummary;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientChunkEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.apache.commons.io.FileUtils;

public class SurveyorClient
implements ClientModInitializer {
    public static final String SERVERS_FILE_NAME = "servers.txt";
    private static final Multimap<ResourceKey<Level>, LevelChunk> LOADING_CHUNKS = HashMultimap.create();

    public static File getSavePath(Level world) {
        String saveFolder = String.valueOf(world.m_7062_().f_47863_);
        Path savePath = FabricLoader.getInstance().getGameDir().resolve("data").resolve("surveyor").resolve(saveFolder);
        savePath.toFile().mkdirs();
        File serversFile = savePath.resolve(SERVERS_FILE_NAME).toFile();
        try {
            ServerData info = Minecraft.m_91087_().m_91089_();
            if (!(info == null || serversFile.exists() && FileUtils.readFileToString((File)serversFile, (Charset)StandardCharsets.UTF_8).contains(info.f_105362_ + "\n" + info.f_105363_))) {
                FileUtils.writeStringToFile((File)serversFile, (String)(info.f_105362_ + "\n" + info.f_105363_ + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
            }
        }
        catch (IOException e) {
            Surveyor.LOGGER.error("[Surveyor] Error writing servers file for save {}.", (Object)savePath, (Object)e);
        }
        return savePath.toFile();
    }

    public static File getWorldSavePath(Level world) {
        String dimNamespace = world.m_46472_().m_135782_().m_135827_();
        String dimPath = world.m_46472_().m_135782_().m_135815_();
        return SurveyorClient.getSavePath(world).toPath().resolve(dimNamespace).resolve(dimPath).toFile();
    }

    public static boolean serverSupported() {
        return ClientPlayNetworking.canSend((ResourceLocation)C2SKnownTerrainPacket.ID);
    }

    public static Map<UUID, PlayerSummary> getFriends() {
        if (Minecraft.m_91087_().m_91091_()) {
            IntegratedServer server = Minecraft.m_91087_().m_91092_();
            return ServerSummary.of((MinecraftServer)server).getGroupSummaries(SurveyorClient.getClientUuid(), (MinecraftServer)server);
        }
        ClientPacketListener handler = Minecraft.m_91087_().m_91403_();
        if (handler == null) {
            return new HashMap<UUID, PlayerSummary>();
        }
        NetworkHandlerSummary handlerSummary = NetworkHandlerSummary.of(handler);
        return ClientExploration.SHARED.sharedPlayers().stream().collect(Collectors.toMap(u -> u, handlerSummary::getPlayer));
    }

    public static SurveyorExploration getExploration() {
        if (Minecraft.m_91087_().m_91091_()) {
            return SurveyorExploration.ofShared(SurveyorClient.getClientUuid(), (MinecraftServer)Minecraft.m_91087_().m_91092_());
        }
        HashSet<SurveyorExploration> set = new HashSet<SurveyorExploration>();
        set.add(ClientExploration.INSTANCE);
        set.add(ClientExploration.SHARED);
        return PlayerSummary.OfflinePlayerSummary.OfflinePlayerExploration.ofMerged(set);
    }

    public static SurveyorExploration getPersonalExploration() {
        if (Minecraft.m_91087_().m_91091_()) {
            return SurveyorExploration.of(SurveyorClient.getClientUuid(), (MinecraftServer)Minecraft.m_91087_().m_91092_());
        }
        return ClientExploration.INSTANCE;
    }

    public static ClientExploration getSharedExploration() {
        if (Minecraft.m_91087_().m_91091_()) {
            throw new IllegalStateException("You can't edit shared exploration in singleplayer!");
        }
        return ClientExploration.SHARED;
    }

    public static UUID getClientUuid() {
        if (Minecraft.m_91087_().m_91091_()) {
            return ServerSummary.HOST;
        }
        GameProfile profile = ((SurveyorNetworkHandler)Minecraft.m_91087_().m_91403_()).getProfile();
        return UUIDUtil.m_235875_((GameProfile)profile);
    }

    public static ServerLevel stealServerWorld(ResourceKey<Level> worldKey) {
        IntegratedServer integratedServer = Minecraft.m_91087_().m_91092_();
        if (integratedServer == null) {
            return null;
        }
        return integratedServer.m_129880_(worldKey);
    }

    public void onInitializeClient() {
        SurveyorClientNetworking.init();
        ClientCommandRegistrationCallback.EVENT.register(SurveyorClientCommands::registerCommands);
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> client.execute(ClientExploration::onLoad));
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            LOADING_CHUNKS.clear();
            ClientExploration.onUnload();
        });
        ClientChunkEvents.CHUNK_LOAD.register((world, chunk) -> {
            if (WorldSummary.of((Level)world).isClient()) {
                LOADING_CHUNKS.put((Object)world.m_46472_(), (Object)chunk);
            }
        });
        ClientChunkEvents.CHUNK_UNLOAD.register((world, chunk) -> {
            if (WorldSummary.of((Level)world).isClient()) {
                WorldTerrainSummary.onChunkUnload((Level)world, chunk);
            }
        });
        ClientTickEvents.END_WORLD_TICK.register(world -> {
            if (Minecraft.m_91087_().f_91060_.m_109821_() <= 10 || !Minecraft.m_91087_().f_91060_.m_109825_()) {
                return;
            }
            for (LevelChunk chunk : new HashSet(LOADING_CHUNKS.get((Object)world.m_46472_()))) {
                WorldTerrainSummary.onChunkLoad((Level)world, chunk);
                ClientExploration.INSTANCE.addChunk((ResourceKey<Level>)world.m_46472_(), chunk.m_7697_());
                LOADING_CHUNKS.remove((Object)world.m_46472_(), (Object)chunk);
            }
        });
        ClientTickEvents.END_WORLD_TICK.register(world -> {
            if (!SurveyorClientEvents.INITIALIZING_WORLD) {
                return;
            }
            if (Minecraft.m_91087_().f_91074_ != null && SurveyorClient.getExploration() != null) {
                SurveyorClientEvents.INITIALIZING_WORLD = false;
                if (WorldSummary.of((Level)world).isClient()) {
                    WorldSummary summary = WorldSummary.of((Level)world);
                    if (summary.terrain() != null && Surveyor.CONFIG.networking.terrain.atLeast(NetworkMode.SOLO)) {
                        new C2SKnownTerrainPacket(summary.terrain().bitSet(null)).send();
                    }
                    if (summary.structures() != null && Surveyor.CONFIG.networking.structures.atLeast(NetworkMode.SOLO)) {
                        new C2SKnownStructuresPacket(summary.structures().keySet(null)).send();
                    }
                    if (summary.landmarks() != null && Surveyor.CONFIG.networking.landmarks.atLeast(NetworkMode.SOLO)) {
                        new C2SKnownLandmarksPacket(summary.landmarks().keySet(null)).send();
                    }
                }
                SurveyorClientEvents.Invoke.worldLoad(Minecraft.m_91087_().f_91074_.f_108545_, Minecraft.m_91087_().f_91074_);
            }
        });
        SurveyorEvents.Register.landmarksAdded(new ResourceLocation("surveyor", "client"), (world, worldLandmarks, landmarks) -> {
            SurveyorExploration exploration = SurveyorClient.getExploration();
            if (exploration != null) {
                SurveyorClientEvents.Invoke.landmarksAdded(world, exploration.limitLandmarkKeySet((ResourceKey<Level>)world.m_46472_(), worldLandmarks, (Multimap<LandmarkType<?>, BlockPos>)HashMultimap.create((Multimap)landmarks)));
            }
        });
        SurveyorEvents.Register.landmarksRemoved(new ResourceLocation("surveyor", "client"), (world, summary, landmarks) -> SurveyorClientEvents.Invoke.landmarksRemoved(world, landmarks));
        Surveyor.LOGGER.info("[Surveyor Client] is not a map mod either");
    }

    public record ClientExploration(Set<UUID> groupPlayers, Map<ResourceKey<Level>, Map<ChunkPos, BitSet>> terrain, Map<ResourceKey<Level>, Map<ResourceKey<Structure>, LongSet>> structures) implements SurveyorExploration
    {
        public static final String KEY_SHARED = "shared";
        public static final ClientExploration INSTANCE = new ClientExploration(new HashSet<UUID>(), new HashMap<ResourceKey<Level>, Map<ChunkPos, BitSet>>(), new HashMap<ResourceKey<Level>, Map<ResourceKey<Structure>, LongSet>>());
        public static final ClientExploration SHARED = new ClientExploration(new HashSet<UUID>(), new HashMap<ResourceKey<Level>, Map<ChunkPos, BitSet>>(), new HashMap<ResourceKey<Level>, Map<ResourceKey<Structure>, LongSet>>());
        public static File saveFile = null;

        public static void onLoad() {
            if (WorldSummary.of((Level)Minecraft.m_91087_().f_91073_).isClient()) {
                saveFile = SurveyorClient.getSavePath((Level)Minecraft.m_91087_().f_91073_).toPath().resolve(SurveyorClient.getClientUuid().toString() + ".dat").toFile();
                CompoundTag explorationNbt = new CompoundTag();
                if (saveFile.exists()) {
                    try {
                        explorationNbt = NbtIo.m_128937_((File)saveFile);
                    }
                    catch (IOException e) {
                        Surveyor.LOGGER.error("[Surveyor] Error loading client exploration file.", (Throwable)e);
                    }
                }
                INSTANCE.read(explorationNbt);
                SHARED.read(explorationNbt.m_128469_(KEY_SHARED));
            }
        }

        public static void onUnload() {
            if (saveFile != null) {
                try {
                    CompoundTag nbt = INSTANCE.write(new CompoundTag());
                    CompoundTag sharedNbt = SHARED.write(new CompoundTag());
                    nbt.m_128365_(KEY_SHARED, (Tag)sharedNbt);
                    NbtIo.m_128944_((CompoundTag)nbt, (File)saveFile);
                }
                catch (IOException e) {
                    Surveyor.LOGGER.error("[Surveyor] Error saving client exploration file.", (Throwable)e);
                }
                saveFile = null;
            }
            ClientExploration.INSTANCE.terrain.clear();
            ClientExploration.INSTANCE.structures.clear();
            ClientExploration.INSTANCE.groupPlayers.clear();
            ClientExploration.SHARED.terrain.clear();
            ClientExploration.SHARED.structures.clear();
            ClientExploration.SHARED.groupPlayers.clear();
        }

        @Override
        public Set<UUID> sharedPlayers() {
            HashSet<UUID> sharedPlayers = new HashSet<UUID>();
            sharedPlayers.add(SurveyorClient.getClientUuid());
            sharedPlayers.addAll(this.groupPlayers);
            return sharedPlayers;
        }

        @Override
        public boolean personal() {
            return true;
        }

        @Override
        public void addStructure(ResourceKey<Level> worldKey, ResourceKey<Structure> structureKey, ChunkPos pos) {
            SurveyorExploration.super.addStructure(worldKey, structureKey, pos);
            this.updateClientForAddStructure((Level)Minecraft.m_91087_().f_91073_, structureKey, pos);
        }

        @Override
        public void mergeRegion(ResourceKey<Level> worldKey, ChunkPos regionPos, BitSet bitSet) {
            SurveyorExploration.super.mergeRegion(worldKey, regionPos, bitSet);
            this.updateClientForMergeRegion((Level)Minecraft.m_91087_().f_91073_, regionPos, bitSet);
        }

        @Override
        public void addChunk(ResourceKey<Level> worldKey, ChunkPos pos) {
            SurveyorExploration.super.addChunk(worldKey, pos);
            this.updateClientForAddChunk((Level)Minecraft.m_91087_().f_91073_, pos);
        }
    }
}

