/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor;

import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorWorld;
import folk.sisby.surveyor.config.SystemMode;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import folk.sisby.surveyor.structure.WorldStructureSummary;
import folk.sisby.surveyor.terrain.WorldTerrainSummary;
import java.io.File;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public record WorldSummary(@Nullable WorldTerrainSummary terrain, @Nullable WorldStructureSummary structures, @Nullable WorldLandmarks landmarks, boolean isClient) {
    private static boolean ENABLE_TERRAIN = false;
    private static boolean ENABLE_STRUCTURES = false;
    private static boolean ENABLE_LANDMARKS = false;

    public static WorldSummary of(Level world) {
        return ((SurveyorWorld)world).surveyor$getSummary();
    }

    public static WorldSummary load(Level world, File folder, boolean isClient) {
        boolean disableLandmarks;
        boolean disableTerrain = Surveyor.CONFIG.terrain == SystemMode.DISABLED || Surveyor.CONFIG.terrain == SystemMode.DYNAMIC && !ENABLE_TERRAIN && (isClient || world.m_7654_().m_129792_());
        boolean disableStructures = Surveyor.CONFIG.structures == SystemMode.DISABLED || Surveyor.CONFIG.structures == SystemMode.DYNAMIC && !ENABLE_STRUCTURES && (isClient || world.m_7654_().m_129792_());
        boolean bl = disableLandmarks = Surveyor.CONFIG.landmarks == SystemMode.DISABLED || Surveyor.CONFIG.landmarks == SystemMode.DYNAMIC && !ENABLE_LANDMARKS && (isClient || world.m_7654_().m_129792_());
        if (disableTerrain && disableStructures && disableLandmarks) {
            return new WorldSummary(null, null, null, isClient);
        }
        Surveyor.LOGGER.info("[Surveyor] Loading data for {}", (Object)world.m_46472_().m_135782_());
        folder.mkdirs();
        WorldTerrainSummary terrain = disableTerrain ? null : WorldTerrainSummary.load(world, folder);
        WorldStructureSummary structures = disableStructures ? null : WorldStructureSummary.load(world, folder);
        WorldLandmarks landmarks = disableLandmarks ? null : WorldLandmarks.load(world, folder);
        Surveyor.LOGGER.info("[Surveyor] Finished loading data for {}", (Object)world.m_46472_().m_135782_());
        return new WorldSummary(terrain, structures, landmarks, isClient);
    }

    public static void enableTerrain() {
        ENABLE_TERRAIN = true;
    }

    public static void enableStructures() {
        ENABLE_STRUCTURES = true;
    }

    public static void enableLandmarks() {
        ENABLE_LANDMARKS = true;
    }

    public void save(Level world, File folder, boolean suppressLogs) {
        int marks;
        if (!this.isDirty()) {
            return;
        }
        folder.mkdirs();
        int chunks = this.terrain == null ? 0 : this.terrain.save(world, folder);
        int keys = this.structures == null ? 0 : this.structures.save(world, folder);
        int n = marks = this.landmarks == null ? 0 : this.landmarks.save(world, folder);
        if (!(suppressLogs || chunks <= 0 && keys <= 0 && marks <= 0)) {
            Surveyor.LOGGER.info("[Surveyor] Finished saving data for {} | cleaned {} terrain regions, {} structure regions, {} landmarks", new Object[]{world.m_46472_().m_135782_(), chunks, keys, marks});
        }
    }

    public boolean isDirty() {
        return this.terrain != null && this.terrain.isDirty() || this.structures != null && this.structures.isDirty() || this.landmarks != null && this.landmarks.isDirty();
    }
}

