/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.common.item;

import dev.xylonity.knightquest.common.item.KQFullSetChecker;
import dev.xylonity.knightquest.common.item.weapons.CleaverWeapon;
import dev.xylonity.knightquest.common.item.weapons.KhopeshWeapon;
import dev.xylonity.knightquest.common.item.weapons.NailWeapon;
import dev.xylonity.knightquest.common.item.weapons.PaladinWeapon;
import dev.xylonity.knightquest.common.item.weapons.UchigatanaWeapon;
import dev.xylonity.knightquest.common.material.KQArmorMaterials;
import dev.xylonity.knightquest.config.values.KQConfigValues;
import dev.xylonity.knightquest.registry.KnightQuestItems;
import dev.xylonity.knightquest.registry.KnightQuestWeapons;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KQArmorItem
extends ArmorItem {
    private static final MobEffectInstance SHIELD_ARMOR = new MobEffectInstance(MobEffects.f_19606_, -1, 0, false, false, true);
    private static final MobEffectInstance BAT_ARMOR = new MobEffectInstance(MobEffects.f_19611_, -1, 0, false, false, true);
    private static final MobEffectInstance PATH_ARMOR = new MobEffectInstance(MobEffects.f_19596_, -1, 1, false, true, true);
    private static final MobEffectInstance BOW_ARMOR = new MobEffectInstance(MobEffects.f_19596_, -1, 1, false, false, true);
    private static final MobEffectInstance HORN_ARMOR = new MobEffectInstance(MobEffects.f_19600_, 400, 1, false, false, true);
    private static final MobEffectInstance SEA_ARMOR = new MobEffectInstance(MobEffects.f_19593_, -1, 0, false, false, true);
    private static final MobEffectInstance PIRATE_ARMOR = new MobEffectInstance(MobEffects.f_19621_, -1, 0, false, false, true);
    private static final MobEffectInstance SPIDER_ARMOR = new MobEffectInstance(MobEffects.f_19603_, -1, 1, false, false, false);
    private static final MobEffectInstance PHANTOM_ARMOR = new MobEffectInstance(MobEffects.f_19596_, -1, 0, false, false, true);
    private static final MobEffectInstance NETHER_ARMOR = new MobEffectInstance(MobEffects.f_19607_, -1, 0, false, false, true);
    private static final MobEffectInstance HUSK_ARMOR = new MobEffectInstance(MobEffects.f_19606_, -1, 1, false, false, true);
    private static final MobEffectInstance BAMBOO_BLUE = new MobEffectInstance(MobEffects.f_19596_, -1, 1, false, false, true);
    private static final MobEffectInstance SILVERFISH_ARMOR = new MobEffectInstance(MobEffects.f_19598_, -1, 0, false, false, true);
    private static final MobEffectInstance SKULK_ARMOR = new MobEffectInstance(MobEffects.f_19606_, -1, 1, false, false, true);
    private static final MobEffectInstance STRAWHAT_ARMOR = new MobEffectInstance(MobEffects.f_19608_, -1, 0, false, false, true);
    private final String bonusTooltip;
    private final boolean hasTooltip;
    private static final Map<UUID, Map<KQArmorMaterials, Boolean>> effectAppliedByArmorMap = new ConcurrentHashMap<UUID, Map<KQArmorMaterials, Boolean>>();

    public KQArmorItem(KQArmorMaterials material, ArmorItem.Type type, Item.Properties settings, boolean hasTooltip) {
        super((ArmorMaterial)material, type, settings);
        this.bonusTooltip = material.getKeyName();
        this.hasTooltip = hasTooltip;
    }

    private boolean isArmorSetConfigEnabled(String bonusTooltip) {
        try {
            ArmorSet armorSet = ArmorSet.valueOf(bonusTooltip.toUpperCase());
            return armorSet.isEnabled();
        }
        catch (Exception e) {
            return false;
        }
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        if (this.hasTooltip && this.isArmorSetConfigEnabled(this.bonusTooltip)) {
            if (!Objects.equals(this.bonusTooltip, "chainmail") && !Objects.equals(this.bonusTooltip, "tengu")) {
                if (KQConfigValues.REQUIRED_ARMOR_PIECES < 4) {
                    pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.item.knightquest.set_bonus"));
                } else {
                    pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.item.knightquest.full_set_bonus"));
                }
                pTooltipComponents.add((Component)Component.m_237110_((String)("tooltip.item.knightquest." + this.bonusTooltip + "_helmet.bonus"), (Object[])new Object[]{"\u00a77\u00a7o-" + (int)Math.floor(KQConfigValues.EVOKER_DARKNESS_CHANCE * 100.0) + "%", "\u00a77\u00a7o-" + (int)Math.floor(KQConfigValues.BLAZE_FIRE_CHANCE * 100.0) + "%", "\u00a77\u00a7o-" + (int)Math.floor(KQConfigValues.DRAGONSET_DAMAGE_MULTIPLIER * 100.0 - 100.0) + "%", "\u00a77\u00a7o" + KQConfigValues.SKULK_MAX_LIGHT_LEVEL, "\u00a77\u00a7o-" + (int)Math.floor(KQConfigValues.CHANCE_ENDERMANSET * 100.0) + "%", "\u00a77\u00a7o" + KQConfigValues.TELEPORT_RADIUS_ENDERMANSET, "\u00a77\u00a7o-" + (int)Math.floor(KQConfigValues.FORZESET_DEFLECT_CHANCE * 100.0) + "%", "\u00a77\u00a7o" + (100.0 - KQConfigValues.CREEPER_EXPLOSION_DAMAGE_MULTIPLIER * 100.0) + "%", "\u00a77\u00a7o-" + (int)Math.floor(KQConfigValues.SILVERSET_BURN_CHANCE * 100.0) + "%", "\u00a77\u00a7o" + (int)Math.floor(KQConfigValues.HOLLOWSET_HEALING_MULTIPLIER * 100.0) + "%", "\u00a77\u00a7o-" + (int)Math.floor(KQConfigValues.WITHERSET_WITHER_CHANCE * 100.0) + "%", "\u00a77\u00a7o" + Math.floor(KQConfigValues.ZOMBIESET_HEALING_AMOUNT), "\u00a77\u00a7o" + KQConfigValues.ZOMBIESET_HEALING_TICKS / 20, "\u00a77\u00a7o" + KQConfigValues.SILVERFISH_EFFECT_MAX_HEIGHT}));
            } else if (Objects.equals(this.bonusTooltip, "tengu")) {
                pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.item.knightquest.full_helmet_bonus"));
                pTooltipComponents.add((Component)Component.m_237115_((String)("tooltip.item.knightquest." + this.bonusTooltip + "_helmet.bonus")));
            }
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public void onInventoryTick(ItemStack stack, @NotNull Level level, Player player, int slotIndex, int selectedIndex) {
        if (!level.m_5776_()) {
            UUID playerUUID = player.m_20148_();
            if (KQConfigValues.PATHSET) {
                if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.PATHSET) && level.m_46461_()) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.PATHSET, false))) {
                        player.m_7292_(PATH_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.PATHSET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.PATHSET, false))) {
                    player.m_21195_(MobEffects.f_19596_);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.PATHSET, false);
                }
            }
            if (KQConfigValues.BOWSET) {
                if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.BOWSET) && player.m_21205_().m_41720_() instanceof ProjectileWeaponItem) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.BOWSET, false))) {
                        player.m_7292_(BOW_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.BOWSET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.BOWSET, false))) {
                    player.m_21195_(MobEffects.f_19596_);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.BOWSET, false);
                }
            }
            if (KQConfigValues.BATSET) {
                if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.BATSET) && level.m_46462_()) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.BATSET, false))) {
                        player.m_7292_(BAT_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.BATSET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.BATSET, false))) {
                    player.m_21195_(MobEffects.f_19611_);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.BATSET, false);
                }
            }
            if (KQConfigValues.SHIELDSET) {
                if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.SHIELDSET)) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.SHIELDSET, false))) {
                        player.m_7292_(SHIELD_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.SHIELDSET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.SHIELDSET, false))) {
                    player.m_21195_(MobEffects.f_19606_);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.SHIELDSET, false);
                }
            }
            if (KQConfigValues.PHANTOMSET) {
                if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.PHANTOMSET) && level.m_46462_()) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.PHANTOMSET, false))) {
                        player.m_7292_(PHANTOM_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.PHANTOMSET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.PHANTOMSET, false))) {
                    player.m_21195_(MobEffects.f_19596_);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.PHANTOMSET, false);
                }
            }
            if (KQConfigValues.HORNSET) {
                if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.HORNSET) && player.m_271686_() != null) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.HORNSET, false))) {
                        player.m_7292_(HORN_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.HORNSET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.HORNSET, false))) {
                    player.m_21195_(MobEffects.f_19600_);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.HORNSET, false);
                }
            }
            if (KQConfigValues.SEASET) {
                if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.SEASET) && player.m_5842_()) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.SEASET, false))) {
                        player.m_7292_(SEA_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.SEASET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.SEASET, false))) {
                    player.m_21195_(MobEffects.f_19593_);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.SEASET, false);
                }
            }
            if (KQConfigValues.PIRATESET) {
                if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.PIRATESET)) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.PIRATESET, false))) {
                        player.m_7292_(PIRATE_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.PIRATESET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.PIRATESET, false))) {
                    player.m_21195_(MobEffects.f_19621_);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.PIRATESET, false);
                }
            }
            if (KQConfigValues.SPIDERSET) {
                if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.SPIDERSET) && player.m_6144_()) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.SPIDERSET, false))) {
                        player.m_7292_(SPIDER_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.SPIDERSET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.SPIDERSET, false))) {
                    player.m_21195_(MobEffects.f_19603_);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.SPIDERSET, false);
                }
            }
            if (KQConfigValues.NETHERSET) {
                if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.NETHERSET)) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.NETHERSET, false))) {
                        player.m_7292_(NETHER_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.NETHERSET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.NETHERSET, false))) {
                    player.m_21195_(MobEffects.f_19607_);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.NETHERSET, false);
                }
            }
            if (KQConfigValues.SKULK) {
                if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.SKULK) && player.m_9236_().m_46803_(player.m_20183_()) <= KQConfigValues.SKULK_MAX_LIGHT_LEVEL) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.SKULK, false))) {
                        player.m_7292_(SKULK_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.SKULK, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.SKULK, false))) {
                    player.m_21195_(MobEffects.f_19606_);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.SKULK, false);
                }
            }
            if (KQConfigValues.STRAWHATSET) {
                if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.STRAWHATSET)) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.STRAWHATSET, false))) {
                        player.m_7292_(STRAWHAT_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.STRAWHATSET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault((Object)KQArmorMaterials.STRAWHATSET, false))) {
                    player.m_21195_(MobEffects.f_19608_);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.STRAWHATSET, false);
                }
            }
        }
        super.onInventoryTick(stack, level, player, slotIndex, selectedIndex);
    }

    public static enum ArmorSet {
        DEEPSLATE(KQConfigValues.DEEPSLATESET),
        EVOKER(KQConfigValues.EVOKERSET),
        SQUIRE(KQConfigValues.SQUIRESET),
        BLAZE(KQConfigValues.BLAZESET),
        DRAGON(KQConfigValues.DRAGONSET),
        BAMBOO_GREEN(KQConfigValues.BAMBOOSET_GREEN),
        SHINOBI(KQConfigValues.SHINOBI),
        BAMBOO(KQConfigValues.BAMBOOSET),
        PATH(KQConfigValues.PATHSET),
        BOW(KQConfigValues.BOWSET),
        BAT(KQConfigValues.BATSET),
        SHIELD(KQConfigValues.SHIELDSET),
        PHANTOM(KQConfigValues.PHANTOMSET),
        HORN(KQConfigValues.HORNSET),
        SEA(KQConfigValues.SEASET),
        PIRATE(KQConfigValues.PIRATESET),
        SPIDER(KQConfigValues.SPIDERSET),
        NETHER(KQConfigValues.NETHERSET),
        SKULK(KQConfigValues.SKULK),
        STRAWHAT(KQConfigValues.STRAWHATSET),
        ENDERMAN(KQConfigValues.ENDERMANSET),
        VETERAN(KQConfigValues.VETERANSET),
        FORZE(KQConfigValues.FORZESET),
        CREEPER(KQConfigValues.CREEPERSET),
        POLAR(KQConfigValues.POLAR),
        SILVER(KQConfigValues.SILVERSET),
        HOLLOW(KQConfigValues.HOLLOWSET),
        WITHER(KQConfigValues.WITHERSET),
        APPLE(KQConfigValues.APPLE_SET),
        CONQUISTADOR(KQConfigValues.CONQUISTADORSET),
        WITCH(KQConfigValues.WITCH),
        TENGU(KQConfigValues.TENGU_HELMET),
        HUSK(KQConfigValues.HUSKSET),
        BAMBOO_BLUE(KQConfigValues.BAMBOOSET_BLUE),
        WARLORD(KQConfigValues.WARLORDSET),
        ZOMBIE(KQConfigValues.ZOMBIESET),
        SILVERFISH(KQConfigValues.SILVERFISHSET),
        SKELETON(KQConfigValues.SKELETONSET);

        private final Boolean configValue;

        private ArmorSet(Boolean configValue) {
            this.configValue = configValue;
        }

        public boolean isEnabled() {
            return this.configValue;
        }
    }

    @Mod.EventBusSubscriber(modid="knightquest")
    public static class ArmorStatusManagerEvents {
        private static final Map<UUID, Boolean> doubleJumpStates = new HashMap<UUID, Boolean>();

        private static boolean isTeleportPositionValid(Level level, BlockPos pos) {
            return !level.m_8055_(pos.m_7495_()).m_60795_() && level.m_8055_(pos).m_60795_() && level.m_8055_(pos.m_7494_()).m_60795_();
        }

        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            Object random5;
            LivingEntity stack;
            Player player;
            LivingEntity livingEntity;
            Entity entity2 = event.getSource().m_7639_();
            if (entity2 instanceof LivingEntity && (livingEntity = (LivingEntity)entity2).m_21205_().m_41720_() == KnightQuestWeapons.KUKRI.get() && KQConfigValues.KUKRI) {
                event.getEntity().m_146917_(event.getEntity().m_146888_() + KQConfigValues.FREEZE_TICKS_KUKRI);
            }
            if ((entity2 = event.getSource().m_7639_()) instanceof Player) {
                player = (Player)entity2;
                if (event.getEntity() != null) {
                    stack = player.m_21205_();
                    if (stack.m_41720_() instanceof UchigatanaWeapon && KQConfigValues.UCHIGATANA) {
                        if (stack.m_41784_().m_128471_("ShouldDoActiveAttack")) {
                            stack.m_41784_().m_128379_("ShouldDoActiveAttack", false);
                            event.setAmount((float)((double)event.getAmount() + (double)event.getAmount() * KQConfigValues.EXTRA_DAMAGE_UCHIGATANA));
                            event.getEntity().m_7292_(new MobEffectInstance(MobEffects.f_216964_, 80, 1, false, false));
                        }
                        if ((double)event.getEntity().m_21223_() < KQConfigValues.ENEMY_HEALTH_PASSIVE_UCHIGATANA * (double)event.getEntity().m_21233_()) {
                            event.setAmount((float)((double)event.getAmount() + (double)event.getAmount() * KQConfigValues.EXTRA_DAMAGE_PASSIVE_UCHIGATANA));
                        }
                    }
                    if (stack.m_41720_() instanceof CleaverWeapon && KQConfigValues.CLEAVER && (double)event.getEntity().m_21223_() > KQConfigValues.ENEMY_HEALTH_PASSIVE_CLEAVER * (double)event.getEntity().m_21233_()) {
                        event.setAmount((float)((double)event.getAmount() + (double)event.getAmount() * KQConfigValues.EXTRA_DAMAGE_PASSIVE_CLEAVER));
                    }
                }
            }
            if ((stack = event.getEntity()) instanceof Player && (stack = (player = (Player)stack).m_21205_()).m_41720_() instanceof KhopeshWeapon && event.getSource().m_7639_() != null && KQConfigValues.KHOPESH && player.m_9236_().m_46467_() - stack.m_41784_().m_128454_("KhopeshActive") < (long)KQConfigValues.REFLECTION_TIME_KHOPESH) {
                event.getSource().m_7639_().m_6469_(event.getSource(), event.getAmount() * 0.5f);
            }
            if ((stack = event.getSource().m_7639_()) instanceof LivingEntity && (livingEntity = stack).m_21205_().m_41720_() == KnightQuestWeapons.KHOPESH.get() && KQConfigValues.KHOPESH && (double)livingEntity.m_217043_().m_188501_() <= KQConfigValues.CHANCE_BURN_KHOPESH) {
                event.getEntity().m_20254_(livingEntity.m_217043_().m_188503_(7) + 1);
            }
            if ((stack = event.getEntity()) instanceof Player) {
                Random random2;
                player = (Player)stack;
                if (KQConfigValues.DEEPSLATESET && event.getSource().m_276093_(DamageTypes.f_268671_) && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.DEEPSLATESET)) {
                    float originalDamage = event.getAmount();
                    float reducedDamage = (float)((double)originalDamage * KQConfigValues.DEEPSLATE_FALL_DAMAGE_MULTIPLIER);
                    event.setAmount(reducedDamage);
                }
                if (KQConfigValues.EVOKERSET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.EVOKERSET)) {
                    Entity entity3;
                    Random random3 = new Random();
                    if (event.getSource().m_7639_() != null && (entity3 = event.getSource().m_7639_()) instanceof LivingEntity) {
                        LivingEntity entity4 = (LivingEntity)entity3;
                        if (random3.nextFloat() < (float)KQConfigValues.EVOKER_DARKNESS_CHANCE) {
                            entity4.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 120, 0, false, false, true));
                        }
                    }
                }
                if (KQConfigValues.SQUIRESET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.SQUIRESET)) {
                    event.setAmount((float)((double)event.getAmount() * KQConfigValues.SQUIRE_DAMAGE_RECEIVED_MULTIPLIER));
                }
                if (KQConfigValues.BLAZESET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.BLAZESET)) {
                    Random random4 = new Random();
                    if (event.getSource().m_7639_() != null && random4.nextFloat() < (float)KQConfigValues.BLAZE_FIRE_CHANCE) {
                        event.getSource().m_7639_().m_20254_(random4.nextInt(KQConfigValues.BLAZE_FIRE_DURATION_MIN, KQConfigValues.BLAZE_FIRE_DURATION_MAX));
                    }
                }
                if (KQConfigValues.DRAGONSET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.DRAGONSET) && event.getSource().m_276093_(DamageTypes.f_268482_)) {
                    event.setAmount(0.0f);
                }
                if (KQConfigValues.BAMBOOSET_GREEN && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.BAMBOOSET_GREEN) && player.m_21023_(MobEffects.f_19614_) && (event.getSource().m_276093_(DamageTypes.f_268515_) || event.getSource().m_276093_(DamageTypes.f_268530_))) {
                    event.setAmount(0.0f);
                    player.m_21195_(MobEffects.f_19614_);
                }
                if (KQConfigValues.SHINOBI && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.SHINOBI) && event.getSource().m_7639_() != null) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 120, 1, false, false, true));
                }
                if (KQConfigValues.BAMBOOSET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.BAMBOOSET) && event.getSource().m_276093_(DamageTypes.f_268671_)) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    int particleCount = 80;
                    double particleRadius = 1.2;
                    for (int i = 0; i < particleCount; ++i) {
                        double angleOffset = Math.PI * 2 / (double)particleCount * (double)i;
                        double xParticleOffset = particleRadius * Math.cos(angleOffset);
                        double zParticleOffset = particleRadius * Math.sin(angleOffset);
                        serverPlayer.f_8906_.m_9829_((Packet)new ClientboundLevelParticlesPacket((ParticleOptions)ParticleTypes.f_123777_, true, player.m_20185_() + xParticleOffset, player.m_20186_() + 0.1, player.m_20189_() + zParticleOffset, 0.2f, 0.05f, 0.2f, 0.0f, 1));
                    }
                    Class classToPush = KQConfigValues.BAMBOOSET_PUSH_PLAYERS ? Entity.class : Monster.class;
                    player.m_9236_().m_45976_(classToPush, player.m_20191_().m_82400_(3.5)).forEach(entity -> {
                        Vec3 direction = entity.m_20182_().m_82546_(player.m_20182_()).m_82541_().m_82490_((double)event.getAmount() * 0.5);
                        entity.m_5997_(direction.f_82479_, direction.f_82480_ + 0.5, direction.f_82481_);
                    });
                }
                if (KQConfigValues.ENDERMANSET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.ENDERMANSET) && event.getSource().m_7639_() != null && (double)(random2 = new Random()).nextFloat() < KQConfigValues.CHANCE_ENDERMANSET) {
                    int radius = KQConfigValues.TELEPORT_RADIUS_ENDERMANSET;
                    BlockPos playerPos = player.m_20183_();
                    ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
                    for (int x = -radius; x <= radius; ++x) {
                        for (int y = -radius; y <= radius; ++y) {
                            for (int z = -radius; z <= radius; ++z) {
                                BlockPos targetPos = new BlockPos(playerPos.m_123341_() + x, playerPos.m_123342_() + y, playerPos.m_123343_() + z);
                                if (!ArmorStatusManagerEvents.isTeleportPositionValid(player.m_9236_(), targetPos)) continue;
                                validPositions.add(targetPos);
                            }
                        }
                    }
                    if (!validPositions.isEmpty()) {
                        BlockPos randomPos = (BlockPos)validPositions.get(random2.nextInt(validPositions.size()));
                        event.setAmount(0.0f);
                        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        player.m_6021_((double)randomPos.m_123341_(), (double)randomPos.m_123342_(), (double)randomPos.m_123343_());
                    }
                }
                if (KQConfigValues.VETERANSET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.VETERANSET) && (double)player.m_21223_() < (double)player.m_21233_() * 0.5) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 200, 0, false, false, true));
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 200, 1, false, false, true));
                }
                if (KQConfigValues.FORZESET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.FORZESET)) {
                    Random random5 = new Random();
                    if (event.getSource().m_7639_() != null && (double)random5.nextFloat() < KQConfigValues.FORZESET_DEFLECT_CHANCE) {
                        event.getSource().m_7639_().m_6469_(event.getSource(), event.getAmount() * (float)KQConfigValues.FORZESET_DEFLECT_DAMAGE);
                    }
                }
                if (KQConfigValues.CREEPERSET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.CREEPERSET) && event.getSource().m_7639_() != null && (event.getSource().m_276093_(DamageTypes.f_268565_) || event.getSource().m_276093_(DamageTypes.f_268448_))) {
                    event.setAmount((float)((double)event.getAmount() * KQConfigValues.CREEPER_EXPLOSION_DAMAGE_MULTIPLIER));
                }
                if (KQConfigValues.POLAR && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.POLAR) && event.getSource().m_7639_() != null && event.getSource().m_276093_(DamageTypes.f_268444_)) {
                    event.setAmount(0.0f);
                }
            }
            if ((random5 = event.getSource().m_7639_()) instanceof Player) {
                player = (Player)random5;
                if (event.getEntity() != null) {
                    if (KQConfigValues.SILVERSET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.SILVERSET) && player.m_9236_().m_46462_() && (double)((Random)(random5 = new Random())).nextFloat() < KQConfigValues.SILVERSET_BURN_CHANCE) {
                        event.getEntity().m_20254_(random5.nextInt(2, 8));
                    }
                    if (KQConfigValues.HOLLOWSET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.HOLLOWSET)) {
                        player.m_5634_(Math.min((float)((double)event.getAmount() * KQConfigValues.HOLLOWSET_HEALING_MULTIPLIER), event.getEntity().m_21223_()));
                    }
                    if (KQConfigValues.DRAGONSET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.DRAGONSET)) {
                        event.setAmount((float)((double)event.getAmount() * KQConfigValues.DRAGONSET_DAMAGE_MULTIPLIER));
                    }
                    if (KQConfigValues.WITHERSET && event.getSource().m_276093_(DamageTypes.f_268739_) && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.WITHERSET)) {
                        random5 = new Random();
                        if (event.getSource().m_7639_() != null && (double)((Random)random5).nextFloat() < KQConfigValues.WITHERSET_WITHER_CHANCE) {
                            event.getEntity().m_7292_(new MobEffectInstance(MobEffects.f_19615_, 120, 0, false, false, false));
                        }
                    }
                }
            }
        }

        @SubscribeEvent
        public static void onLivingUpdate(LivingEntityUseItemEvent.Finish event) {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                if (KQConfigValues.APPLE_SET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.APPLE_SET) && event.getItem().m_41720_().equals(Items.f_42436_)) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 1, false, true, true));
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 4800, 1, false, true, true));
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 2400, 0, false, true, true));
                }
            }
        }

        @SubscribeEvent
        public static void onLivingDead(LivingDeathEvent event) {
            Entity entity;
            if (event.getEntity() != null && (entity = event.getSource().m_7639_()) instanceof Player) {
                Player player = (Player)entity;
                if (KQConfigValues.CONQUISTADORSET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.CONQUISTADORSET)) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 200, 1, false, true, true));
                }
                if (KQConfigValues.WITCH && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.WITCH)) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 80, 0, false, true, true));
                }
            }
        }

        @SubscribeEvent
        public static void onLivingTick(LivingEvent.LivingTickEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                ItemStack helmet = player.m_150109_().m_36052_(3);
                ItemStack stack = player.m_21205_();
                if ((KQConfigValues.TENGU_HELMET || KQConfigValues.NAIL) && (helmet.m_41720_().equals(KnightQuestItems.TENGU_HELMET.get()) || stack.m_41720_() instanceof NailWeapon && stack.m_41784_().m_128471_("Activated"))) {
                    boolean canDoubleJump = doubleJumpStates.getOrDefault(player.m_20148_(), true);
                    if (!player.m_20096_() && player.m_20184_().f_82480_ < 0.0 && canDoubleJump) {
                        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ArmorStatusManagerEvents.handleClientSideDoubleJump(player));
                    }
                    if (player.m_20096_()) {
                        doubleJumpStates.put(player.m_20148_(), true);
                    }
                }
                if (stack.m_41720_() instanceof PaladinWeapon && KQConfigValues.PALADIN && player.f_19797_ % KQConfigValues.REGEN_TICKS_PALADIN == 0 && (double)player.m_21223_() < (double)player.m_21233_() * KQConfigValues.REGEN_MAX_PALADIN && stack.m_41784_().m_128471_("Activated")) {
                    player.m_5634_((float)KQConfigValues.REGEN_HP_PALADIN);
                }
                if (KQConfigValues.HUSKSET) {
                    if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.HUSKSET) && (player.m_9236_().m_204166_(new BlockPos((int)player.m_20185_(), (int)player.m_20186_(), (int)player.m_20189_())).m_203565_(Biomes.f_48203_) || player.m_9236_().m_204166_(new BlockPos((int)player.m_20185_(), (int)player.m_20186_(), (int)player.m_20189_())).m_203565_(Biomes.f_48159_) || player.m_9236_().m_204166_(new BlockPos((int)player.m_20185_(), (int)player.m_20186_(), (int)player.m_20189_())).m_203565_(Biomes.f_48217_))) {
                        if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(player.m_20148_(), k -> new HashMap()).getOrDefault((Object)KQArmorMaterials.HUSKSET, false))) {
                            player.m_7292_(HUSK_ARMOR);
                            effectAppliedByArmorMap.get(player.m_20148_()).put(KQArmorMaterials.HUSKSET, true);
                        }
                    } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(player.m_20148_(), k -> new HashMap()).getOrDefault((Object)KQArmorMaterials.HUSKSET, false))) {
                        player.m_21195_(MobEffects.f_19606_);
                        effectAppliedByArmorMap.get(player.m_20148_()).put(KQArmorMaterials.HUSKSET, false);
                    }
                }
                if (KQConfigValues.BAMBOOSET_BLUE) {
                    if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.BAMBOOSET_BLUE) && (player.m_9236_().m_204166_(new BlockPos((int)player.m_20185_(), (int)player.m_20186_(), (int)player.m_20189_())).m_203565_(Biomes.f_48222_) || player.m_9236_().m_204166_(new BlockPos((int)player.m_20185_(), (int)player.m_20186_(), (int)player.m_20189_())).m_203565_(Biomes.f_48197_) || player.m_9236_().m_204166_(new BlockPos((int)player.m_20185_(), (int)player.m_20186_(), (int)player.m_20189_())).m_203565_(Biomes.f_186769_))) {
                        if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(player.m_20148_(), k -> new HashMap()).getOrDefault((Object)KQArmorMaterials.BAMBOOSET_BLUE, false))) {
                            player.m_7292_(BAMBOO_BLUE);
                            effectAppliedByArmorMap.get(player.m_20148_()).put(KQArmorMaterials.BAMBOOSET_BLUE, true);
                        }
                    } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(player.m_20148_(), k -> new HashMap()).getOrDefault((Object)KQArmorMaterials.BAMBOOSET_BLUE, false))) {
                        player.m_21195_(MobEffects.f_19596_);
                        effectAppliedByArmorMap.get(player.m_20148_()).put(KQArmorMaterials.BAMBOOSET_BLUE, false);
                    }
                }
                if (KQConfigValues.WARLORDSET && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.WARLORDSET)) {
                    for (Entity entity : player.m_9236_().m_45976_(Player.class, player.m_20191_().m_82400_((double)KQConfigValues.WARLORD_SET_EFFECT_RADIUS))) {
                        Player nearbyPlayer;
                        if (KQConfigValues.SHOULD_WARLORD_SET_EFFECT_APPLY_TO_ITSELF) {
                            if (!(entity instanceof Player)) continue;
                            nearbyPlayer = (Player)entity;
                            nearbyPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 100, 0, false, false, true));
                            continue;
                        }
                        if (!(entity instanceof Player)) continue;
                        nearbyPlayer = (Player)entity;
                        if (entity == player) continue;
                        nearbyPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 100, 0, false, false, true));
                    }
                }
                if (KQConfigValues.ZOMBIESET && !player.m_9236_().f_46443_ && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.ZOMBIESET) && player.m_9236_().m_46462_() && player.f_19797_ % KQConfigValues.ZOMBIESET_HEALING_TICKS == 0) {
                    player.m_5634_((float)KQConfigValues.ZOMBIESET_HEALING_AMOUNT);
                }
                if (KQConfigValues.POLAR && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.POLAR) && player.m_146888_() > 0) {
                    player.m_146917_(0);
                }
                if (KQConfigValues.SILVERFISHSET) {
                    if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.SILVERFISHSET) && player.m_20186_() < (double)KQConfigValues.SILVERFISH_EFFECT_MAX_HEIGHT) {
                        if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(player.m_20148_(), k -> new HashMap()).getOrDefault((Object)KQArmorMaterials.SILVERFISHSET, false))) {
                            player.m_7292_(SILVERFISH_ARMOR);
                            effectAppliedByArmorMap.get(player.m_20148_()).put(KQArmorMaterials.SILVERFISHSET, true);
                        }
                    } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(player.m_20148_(), k -> new HashMap()).getOrDefault((Object)KQArmorMaterials.SILVERFISHSET, false))) {
                        player.m_21195_(MobEffects.f_19598_);
                        effectAppliedByArmorMap.get(player.m_20148_()).put(KQArmorMaterials.SILVERFISHSET, false);
                    }
                }
            }
        }

        @SubscribeEvent
        public static void onArrowHit(EntityJoinLevelEvent event) {
            Entity entity = event.getEntity();
            if (entity instanceof AbstractArrow) {
                Player player;
                Entity entity2;
                AbstractArrow arrow = (AbstractArrow)entity;
                if (KQConfigValues.SKELETONSET && (entity2 = arrow.m_19749_()) instanceof Player && KQFullSetChecker.hasFullSetOn(player = (Player)entity2, KQArmorMaterials.SKELETONSET)) {
                    arrow.m_36767_((byte)5);
                }
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void handleClientSideDoubleJump(Player player) {
            boolean canDoubleJump;
            if (Minecraft.m_91087_().f_91066_.f_92089_.m_90857_() && (canDoubleJump = doubleJumpStates.getOrDefault(player.m_20148_(), true).booleanValue())) {
                doubleJumpStates.put(player.m_20148_(), false);
                for (int i = 0; i < 360; i += 60) {
                    double angleRadians = Math.toRadians(i);
                    double particleX = player.m_20185_() + 0.4 * Math.cos(angleRadians);
                    double particleZ = player.m_20189_() + 0.4 * Math.sin(angleRadians);
                    player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, particleX, player.m_20186_(), particleZ, 0.0, 0.35, 0.0);
                }
                player.m_6135_();
            }
        }
    }
}

