/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.common.entity.entities;

import dev.xylonity.knightlib.registry.KnightLibItems;
import dev.xylonity.knightquest.common.entity.entities.ai.MoveToPumpkinGoal;
import dev.xylonity.knightquest.common.entity.entities.ai.RangedAttackGoal;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SamhainEntity
extends TamableAnimal
implements GeoEntity,
RangedAttackMob {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.m_135353_(SamhainEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> SIT_VARIATION = SynchedEntityData.m_135353_(SamhainEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public SamhainEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21553_(true);
    }

    @NotNull
    public Iterable<ItemStack> m_6168_() {
        return Arrays.asList(this.m_6844_(EquipmentSlot.HEAD), this.m_6844_(EquipmentSlot.CHEST), this.m_6844_(EquipmentSlot.LEGS), this.m_6844_(EquipmentSlot.FEET));
    }

    public static AttributeSupplier setAttributes() {
        return TamableAnimal.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22281_, 0.5).m_22268_(Attributes.f_22283_, 2.0).m_22268_(Attributes.f_22279_, 0.5).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, new RangedAttackGoal<SamhainEntity>(this, 0.7, 10, 15.0f));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.6, true));
        this.f_21345_.m_25352_(4, (Goal)new FollowOwnerGoal((TamableAnimal)this, 0.6, 6.0f, 2.0f, false));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new MoveToPumpkinGoal(this, 0.68f));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", this::predicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackcontroller", this::attackPredicate)});
    }

    private PlayState attackPredicate(AnimationState<?> event) {
        if (this.m_6117_() && this.m_21205_().m_41720_() instanceof ProjectileWeaponItem) {
            event.getController().forceAnimationReset();
            event.getController().setAnimation(RawAnimation.begin().then("bow_attack", Animation.LoopType.PLAY_ONCE));
        } else if (this.f_20911_ && event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            event.getController().forceAnimationReset();
            event.getController().setAnimation(RawAnimation.begin().then("attack", Animation.LoopType.PLAY_ONCE));
            this.f_20911_ = false;
        }
        return PlayState.CONTINUE;
    }

    private PlayState predicate(AnimationState<?> event) {
        if (this.isSitting()) {
            String sitVariation = this.getSitVariation() == 0 ? "sit" : (this.getSitVariation() == 1 ? "sit3" : "sit2");
            event.getController().setAnimation(RawAnimation.begin().then(sitVariation, Animation.LoopType.LOOP));
        } else if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
        } else {
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @NotNull
    public InteractionResult m_6071_(Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item itemForTaming = (Item)KnightLibItems.GREAT_ESSENCE.get();
        Item item = itemstack.m_41720_();
        if (item == itemForTaming && !this.m_21824_()) {
            if (this.m_9236_().f_46443_) {
                return InteractionResult.CONSUME;
            }
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (!ForgeEventFactory.onAnimalTame((Animal)this, (Player)player) && !this.m_9236_().f_46443_) {
                super.m_21828_(player);
                this.f_21344_.m_26569_();
                this.m_6710_(null);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
                this.setSitting(true);
            }
            this.setSitVariation(this.m_217043_().m_216339_(0, 3));
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_() && !this.m_9236_().f_46443_ && hand == InteractionHand.MAIN_HAND && this.m_269323_() == player) {
            if ((itemstack.m_41720_().equals(KnightLibItems.GREAT_ESSENCE.get()) || itemstack.m_41720_().equals(KnightLibItems.SMALL_ESSENCE.get())) && this.m_21223_() < this.m_21233_()) {
                if (itemstack.m_41720_().equals(KnightLibItems.GREAT_ESSENCE.get())) {
                    this.m_5634_(16.0f);
                } else if (itemstack.m_41720_().equals(KnightLibItems.SMALL_ESSENCE.get())) {
                    this.m_5634_(4.0f);
                }
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
            } else if (player.m_6144_()) {
                this.removeArmor(player);
                this.removeItem(player);
            } else {
                this.setSitting(!this.isSitting());
                this.setSitVariation(this.m_217043_().m_216339_(0, 3));
            }
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_41720_() == itemForTaming) {
            return InteractionResult.PASS;
        }
        return super.m_6071_(player, hand);
    }

    protected void m_7581_(ItemEntity itemEntity) {
        ItemStack itemStack = itemEntity.m_32055_();
        Item item = itemStack.m_41720_();
        if ((item instanceof SwordItem || item instanceof AxeItem) && this.m_21824_()) {
            EquipmentSlot slot = LivingEntity.m_147233_((ItemStack)itemStack);
            ItemStack currentItem = this.m_21120_(InteractionHand.MAIN_HAND);
            if (currentItem.m_41619_()) {
                this.m_8061_(slot, itemStack.m_41620_(1));
                if (itemStack.m_41619_()) {
                    itemEntity.m_146870_();
                }
            }
        } else if (item instanceof ArmorItem) {
            EquipmentSlot slot;
            ItemStack currentArmor;
            ArmorItem armorItem = (ArmorItem)item;
            if (this.m_21824_() && (currentArmor = this.m_6844_(slot = armorItem.m_40402_())).m_41619_()) {
                this.m_8061_(slot, itemStack.m_41620_(1));
                if (itemStack.m_41619_()) {
                    itemEntity.m_146870_();
                }
            }
        }
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        if (this.m_21805_() != null) {
            tag.m_128362_("ownerUUID", this.m_21805_());
        }
        this.setSitting(tag.m_128471_("isSitting"));
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            CompoundTag stackNbt;
            ItemStack stack;
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || (stack = ItemStack.m_41712_((CompoundTag)(stackNbt = tag.m_128469_(slot.m_20751_())))).m_41619_()) continue;
            this.m_8061_(slot, stack);
        }
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        if (tag.m_128403_("ownerUUID")) {
            this.m_21816_(tag.m_128342_("ownerUUID"));
        }
        tag.m_128379_("isSitting", this.isSitting());
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack;
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || (stack = this.m_6844_(slot)).m_41619_()) continue;
            CompoundTag stackNbt = new CompoundTag();
            stack.m_41739_(stackNbt);
            tag.m_128365_(slot.m_20751_(), (Tag)stackNbt);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SITTING, (Object)false);
        this.f_19804_.m_135372_(SIT_VARIATION, (Object)0);
    }

    private void setSitVariation(int sitVariation) {
        this.f_19804_.m_135381_(SIT_VARIATION, (Object)sitVariation);
    }

    private int getSitVariation() {
        return (Integer)this.f_19804_.m_135370_(SIT_VARIATION);
    }

    private void removeArmor(Player pPlayer) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack armorStack;
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || (armorStack = this.m_6844_(slot)).m_41619_()) continue;
            boolean addedToInventory = pPlayer.m_150109_().m_36054_(armorStack);
            if (!addedToInventory) {
                pPlayer.m_19983_(armorStack);
            }
            this.m_8061_(slot, ItemStack.f_41583_);
        }
    }

    private void removeItem(Player pPlayer) {
        ItemStack itemStack = this.m_21120_(InteractionHand.MAIN_HAND);
        if (!itemStack.m_41619_()) {
            boolean addedToInventory = pPlayer.m_150109_().m_36054_(itemStack);
            if (!addedToInventory) {
                pPlayer.m_19983_(itemStack);
            }
            this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        }
    }

    public void setSitting(boolean sitting) {
        this.f_19804_.m_135381_(SITTING, (Object)sitting);
        this.m_21839_(sitting);
    }

    public boolean isSitting() {
        return (Boolean)this.f_19804_.m_135370_(SITTING);
    }

    public boolean m_6573_(@NotNull Player player) {
        return false;
    }

    public void m_7105_(boolean tamed) {
        super.m_7105_(tamed);
        if (tamed) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_(20.0);
            Objects.requireNonNull(this.m_21051_(Attributes.f_22281_)).m_22100_(0.5);
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(0.5);
            this.m_21153_(20.0f);
        } else {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_(8.0);
            Objects.requireNonNull(this.m_21051_(Attributes.f_22281_)).m_22100_(0.5);
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(0.5);
        }
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel serverLevel, @NotNull AgeableMob ageableMob) {
        return null;
    }

    @NotNull
    protected SoundEvent m_5501_() {
        return SoundEvents.f_144067_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_215672_;
    }

    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return SoundEvents.f_215675_;
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        this.m_5496_(SoundEvents.f_12624_, 0.15f, 1.0f);
    }

    public void m_6504_(@NotNull LivingEntity pTarget, float pVelocity) {
        ItemStack itemstack = this.m_6298_(this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrow abstractarrow = this.getArrow(itemstack, pVelocity);
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            abstractarrow = ((BowItem)this.m_21205_().m_41720_()).customArrow(abstractarrow);
        }
        double d0 = pTarget.m_20185_() - this.m_20185_();
        double d1 = pTarget.m_20227_(0.34) - abstractarrow.m_20186_();
        double d2 = pTarget.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        abstractarrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.m_9236_().m_46791_().m_19028_() * 4));
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)abstractarrow);
    }

    protected AbstractArrow getArrow(ItemStack pArrowStack, float pVelocity) {
        return ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)pArrowStack, (float)pVelocity);
    }
}

