/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.common.entity.entities;

import dev.xylonity.knightquest.config.values.KQConfigValues;
import dev.xylonity.knightquest.registry.KnightQuestItems;
import dev.xylonity.knightquest.registry.KnightQuestWeapons;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FallenKnightEntity
extends Monster
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public FallenKnightEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @NotNull
    public Iterable<ItemStack> m_6168_() {
        return Arrays.asList(this.m_6844_(EquipmentSlot.HEAD), this.m_6844_(EquipmentSlot.CHEST), this.m_6844_(EquipmentSlot.LEGS), this.m_6844_(EquipmentSlot.FEET));
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 35.0).m_22268_(Attributes.f_22281_, 0.5).m_22268_(Attributes.f_22283_, 2.0).m_22268_(Attributes.f_22279_, 0.5).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.6, true));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackcontroller", 2, this::attackPredicate)});
    }

    private PlayState attackPredicate(AnimationState<?> event) {
        if (this.f_20911_ && event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            event.getController().forceAnimationReset();
            event.getController().setAnimation(RawAnimation.begin().then("animation.model.attack", Animation.LoopType.PLAY_ONCE));
            this.f_20911_ = false;
        }
        return PlayState.CONTINUE;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42740_));
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)KnightQuestWeapons.PALADIN_SWORD.get()));
        Item[] helmets = new Item[]{KnightQuestItems.VETERAN_HELMET.get(), KnightQuestItems.APPLE_HELMET.get(), KnightQuestItems.HORN_HELMET.get(), KnightQuestItems.ZOMBIE_HELMET2.get()};
        Item[] chestplates = new Item[]{KnightQuestItems.VETERAN_CHESTPLATE.get(), KnightQuestItems.APPLE_CHESTPLATE.get(), KnightQuestItems.HORN_CHESTPLATE.get(), KnightQuestItems.ZOMBIE_CHESTPLATE.get()};
        Item[] leggings = new Item[]{KnightQuestItems.VETERAN_LEGGINGS.get(), KnightQuestItems.APPLE_LEGGINGS.get(), KnightQuestItems.HORN_LEGGINGS.get(), KnightQuestItems.ZOMBIE_LEGGINGS.get()};
        Item[] boots = new Item[]{KnightQuestItems.VETERAN_BOOTS.get(), KnightQuestItems.APPLE_BOOTS.get(), KnightQuestItems.HORN_BOOTS.get(), KnightQuestItems.ZOMBIE_BOOTS.get()};
        int index = this.f_19796_.m_188503_(helmets.length);
        this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)helmets[index]));
        this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)chestplates[index]));
        this.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)leggings[index]));
        this.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)boots[index]));
        AttributeInstance maxHealth = this.m_21051_(Attributes.f_22276_);
        if (maxHealth != null) {
            maxHealth.m_22100_(KQConfigValues.FALLENKNIGHT_MAX_HEALTH);
            this.m_21153_((float)KQConfigValues.FALLENKNIGHT_MAX_HEALTH);
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    private PlayState predicate(AnimationState<?> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().then("animation.model.walk", Animation.LoopType.LOOP));
        } else {
            event.getController().setAnimation(RawAnimation.begin().then("animation.model.idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            CompoundTag stackNbt;
            ItemStack stack;
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || (stack = ItemStack.m_41712_((CompoundTag)(stackNbt = tag.m_128469_(slot.m_20751_())))).m_41619_()) continue;
            this.m_8061_(slot, stack);
        }
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack;
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || (stack = this.m_6844_(slot)).m_41619_()) continue;
            CompoundTag stackNbt = new CompoundTag();
            stack.m_41739_(stackNbt);
            tag.m_128365_(slot.m_20751_(), (Tag)stackNbt);
        }
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12603_;
    }

    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return SoundEvents.f_12608_;
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        this.m_5496_(SoundEvents.f_12614_, 0.15f, 1.0f);
    }
}

